/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.internal.Util;
import chariot.model.Enums;
import chariot.model.Game;
import chariot.model.LightUser;
import chariot.model.Variant;
import java.time.ZonedDateTime;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GameEvent {
    public Type type();

    public record OpponentGone(Type type, boolean gone, Optional<Integer> claimWinInSeconds) implements GameEvent
    {
    }

    public record Chat(Type type, String username, String text, Enums.Room room) implements GameEvent
    {
    }

    public record State(Type type, String moves, long wtime, long btime, long winc, long binc, boolean wdraw, boolean bdraw, boolean wtakeback, boolean btakeback, Game.Status status, String winner) implements GameEvent
    {
    }

    public record Full(Type type, String id, boolean rated, Variant variant, Clock clock, String speed, Perf perf, Long createdTime, LightUser white, LightUser black, String initialFen, State state) implements GameEvent
    {
        public ZonedDateTime createdAt() {
            return Util.fromLong(this.createdTime());
        }

        public record Clock(Integer initial, Integer increment) {
        }

        public record Perf(String name) {
        }
    }

    public static enum Type {
        gameFull,
        gameState,
        chatLine,
        opponentGone;

    }
}

