/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.internal.Util;
import chariot.model.Enums;
import chariot.model.Player;
import chariot.model.Variant;
import java.time.ZonedDateTime;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MoveInfo {

    public record Players(Player white, Player black) {
    }

    public record Status(int id, String name) {
    }

    public record Move(String fen, String lm, int wc, int bc) implements MoveInfo
    {
        public Move {
            string2 = Util.orEmpty(string2);
        }
    }

    public record GameSummary(String id, String speed, String perf, String initialFen, String fen, Status status, String source, String lastMove, int turns, int startedAtTurn, Long createdTime, boolean rated, Variant variant, Enums.Color player, Players players) implements MoveInfo
    {
        public GameSummary {
            string7 = Util.orEmpty(string7);
            string4 = Util.orEmpty(string4);
        }

        public ZonedDateTime createdAt() {
            return Util.fromLong(this.createdTime());
        }
    }
}

