/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.model.Entry;
import chariot.model.Err;
import chariot.model.Fail;
import chariot.model.None;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface One<T> {
    public static <T> One<T> entry(T t) {
        return new Entry<T>(t);
    }

    public static <T> One<T> none() {
        return new None();
    }

    public static <T> One<T> fail(int n, Err err) {
        return new Fail(n, err);
    }

    default public Optional<T> maybe() {
        Optional optional;
        One one = this;
        if (one instanceof Entry) {
            Entry entry = (Entry)one;
            optional = Optional.of(entry.entry());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    default public <R> Optional<R> map(Function<? super T, ? extends R> function) {
        return this.maybe().map(function);
    }

    default public T orElse(T t) {
        return this.maybe().orElse(t);
    }

    default public T orElseGet(Supplier<? extends T> supplier) {
        return this.maybe().orElseGet(supplier);
    }

    default public void ifPresent(Consumer<? super T> consumer) {
        this.maybe().ifPresent(consumer);
    }

    default public void ifPresentOrElse(Consumer<? super T> consumer, Runnable runnable) {
        this.maybe().ifPresentOrElse(consumer, runnable);
    }

    default public boolean isPresent() {
        return this.maybe().isPresent();
    }

    default public T get() {
        return this.maybe().get();
    }
}

