/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.internal.Util;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Pgn {
    public List<Tag> tags();

    public List<Move> moveList();

    public Map<String, String> tagMap();

    public String moves();

    default public List<String> moveListSAN() {
        return this.moveList().stream().filter(San.class::isInstance).map(San.class::cast).map(San::san).toList();
    }

    private static int indexOfOrEnd(String string, int n, String string2) {
        int n2 = string2.indexOf(string, n);
        return n2 == -1 ? string2.length() : n2;
    }

    public static Pgn of(List<Tag> list, String string) {
        return new BasicPgn(List.copyOf(list), string);
    }

    public static List<Pgn> readFromFile(Path path) {
        List<Pgn> list;
        block8: {
            Stream<String> stream = Files.lines(path);
            try {
                list = StreamSupport.stream(new Util.PgnSpliterator(stream.iterator()), false).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Pgn> readFromString(String string) {
        List<Pgn> list;
        block8: {
            Stream<String> stream = string.lines();
            try {
                list = StreamSupport.stream(new Util.PgnSpliterator(stream.iterator()), false).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface San
    extends Move {
        public String san();
    }

    public record BasicPgn(List<Tag> tags, String moves) implements Pgn
    {
        @Override
        public String toString() {
            return String.join((CharSequence)"\n\n", String.join((CharSequence)"\n", this.tags.stream().map(Object::toString).toList()), this.moves);
        }

        @Override
        public Map<String, String> tagMap() {
            return this.tags.stream().collect(Collectors.toMap(Tag::name, Tag::value));
        }

        @Override
        public List<Move> moveList() {
            return Move.parse(this.moves());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Tag {
        public String name();

        public String value();

        public static Tag parse(String string) {
            return Tag.of(string.substring(1, string.indexOf(32)), string.substring(string.indexOf(34) + 1, string.length() - 2));
        }

        public static Tag of(String string, String string2) {
            return new BasicTag(string, string2);
        }

        public record BasicTag(String name, String value) implements Tag
        {
            @Override
            public String toString() {
                return "[%s \"%s\"]".formatted(this.name, this.value);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Move {
        public static String render(Move move) {
            if (move instanceof Variation) {
                Variation variation = (Variation)move;
                return "(%s)".formatted(String.join((CharSequence)" ", variation.variation().stream().map(Move::render).toList()));
            }
            if (move instanceof Result) {
                Result result = (Result)move;
                return result.result();
            }
            if (move instanceof NumBegin) {
                NumBegin numBegin = (NumBegin)move;
                return "%d. %s".formatted(numBegin.move(), numBegin.san());
            }
            if (move instanceof NumEnd) {
                NumEnd numEnd = (NumEnd)move;
                return "%d... %s".formatted(numEnd.move(), numEnd.san());
            }
            if (move instanceof Empty) {
                Empty empty = (Empty)move;
                return "";
            }
            if (move instanceof End) {
                End end = (End)move;
                return end.san();
            }
            if (move instanceof Comment) {
                Comment comment = (Comment)move;
                return "{%s}".formatted(comment.comment());
            }
            return "{oops}";
        }

        public static List<Move> parse(String string) {
            if ((string = string.trim()).isEmpty()) {
                return List.of(new Empty());
            }
            if (Set.of("*", "1-0", "0-1", "1/2-1/2").contains(string)) {
                return List.of(new Result(string));
            }
            if (Character.isDigit(string.charAt(0))) {
                int n = string.indexOf(".");
                int n2 = Integer.parseInt(string.substring(0, n));
                boolean bl = string.charAt(n + 1) == '.';
                int n3 = string.indexOf(" ", n + 1);
                while (Character.isWhitespace(string.charAt(n3))) {
                    ++n3;
                }
                int n4 = Pgn.indexOfOrEnd(" ", n3, string);
                String string2 = string.substring(n3, n4);
                return Stream.concat(Stream.of(bl ? new NumEnd(n2, string2) : new NumBegin(n2, string2)), Move.parse(string.substring(n4)).stream()).toList();
            }
            if ('(' == string.charAt(0)) {
                boolean bl = false;
                int n = 1;
                int n5 = 1;
                while (n != 0) {
                    switch (string.charAt(n5)) {
                        case '{': {
                            boolean bl2 = true;
                            break;
                        }
                        case '}': {
                            boolean bl2 = false;
                            break;
                        }
                        default: {
                            boolean bl2 = bl = bl;
                        }
                    }
                    if (!bl) {
                        n = switch (string.charAt(n5)) {
                            case '(' -> n + 1;
                            case ')' -> n - 1;
                            default -> n;
                        };
                    }
                    ++n5;
                }
                return Stream.concat(Stream.of(new Variation(Move.parse(string.substring(1, n5 - 1)))), Move.parse(string.substring(n5)).stream()).toList();
            }
            if ('{' == string.charAt(0)) {
                int n = string.indexOf(125);
                return Stream.concat(Stream.of(new Comment(string.substring(1, n))), Move.parse(string.substring(n + 1)).stream()).toList();
            }
            int n = Pgn.indexOfOrEnd(" ", 0, string);
            return Stream.concat(Stream.of(new End(string.substring(0, n))), Move.parse(string.substring(n)).stream()).toList();
        }
    }

    public record Comment(String comment) implements Move
    {
    }

    public record End(String san) implements San
    {
    }

    public record Empty() implements Move
    {
    }

    public record NumEnd(int move, String san) implements San
    {
    }

    public record NumBegin(int move, String san) implements San
    {
    }

    public record Result(String result) implements Move
    {
    }

    public record Variation(List<Move> variation) implements Move
    {
    }
}

