/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.model.LightUser;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Player {
    default public String name() {
        if (this instanceof Anonymous) {
            return "Anonymous";
        }
        Player player = this;
        if (player instanceof User) {
            User user = (User)player;
            return user.user().name();
        }
        player = this;
        if (player instanceof Computer) {
            Computer computer = (Computer)player;
            return "Stockfish level " + computer.aiLevel();
        }
        return "<unknown user>";
    }

    default public Optional<Analysis> analysis() {
        Player player = this;
        if (player instanceof User) {
            User user = (User)player;
            return user.analysis();
        }
        player = this;
        if (player instanceof Anonymous) {
            Anonymous anonymous = (Anonymous)player;
            return anonymous.analysis();
        }
        return Optional.empty();
    }

    default public Optional<Integer> accuracy() {
        Player player = this;
        if (player instanceof User) {
            User user = (User)player;
            return user.accuracy();
        }
        return Optional.empty();
    }

    public record Anonymous(Optional<Analysis> analysis) implements Player
    {
    }

    public record User(LightUser user, Integer rating, Integer ratingDiff, boolean provisional, Optional<Boolean> berserk, Optional<Analysis> analysis, Optional<Integer> accuracy) implements Player,
    LUser
    {
        @Override
        public String id() {
            return this.user.id();
        }

        @Override
        public String name() {
            return this.user.name();
        }

        @Override
        public String title() {
            return this.user.title();
        }

        @Override
        public boolean patron() {
            return this.user.patron();
        }
    }

    public record Computer(Integer aiLevel) implements Player
    {
    }

    public record Analysis(int inaccuracy, int mistake, int blunder, int acpl) {
    }

    public static interface LUser {
        public String id();

        public String name();

        public String title();

        public boolean patron();
    }
}

