/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.internal.Util;
import chariot.model.Enums;
import chariot.model.LightUser;
import chariot.model.Variant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Tournament {
    public String id();

    public String createdBy();

    public String system();

    public Integer minutes();

    public Clock clock();

    public boolean rated();

    public String fullName();

    public Integer nbPlayers();

    public Variant variant();

    public Long startsAt();

    public Long finishesAt();

    public Enums.TournamentState status();

    public Perf perf();

    default public ZonedDateTime startsTime() {
        return Util.fromLong(this.startsAt());
    }

    default public ZonedDateTime finishesTime() {
        return Util.fromLong(this.finishesAt());
    }

    public record TeamBattle(String id, String createdBy, String system, Integer minutes, Clock clock, boolean rated, String fullName, Integer nbPlayers, Variant variant, Long startsAt, Long finishesAt, Enums.TournamentState status, Perf perf, boolean hasMaxRating, Long secondsToStart, LightUser winner, Teams teamBattle) implements Tournament
    {

        public record Teams(List<String> teams, Integer nbLeaders) {
        }
    }

    public record LocalArena(String id, String createdBy, String system, Integer minutes, Clock clock, boolean rated, String fullName, Integer nbPlayers, Variant variant, Long startsAt, Long finishesAt, Enums.TournamentState status, Perf perf, Pos position, boolean hasMaxRating, Long secondsToStart, LightUser winner) implements Tournament
    {
        public LocalArena {
            pos = pos == null ? Pos.none : pos;
        }
    }

    public record Scheduled(String id, String createdBy, String system, Integer minutes, Clock clock, boolean rated, String fullName, Integer nbPlayers, Variant variant, Long startsAt, Long finishesAt, Enums.TournamentState status, Perf perf, Pos position, boolean hasMaxRating, Long secondsToStart, LightUser winner, Schedule schedule) implements Tournament
    {
        public Scheduled {
            pos = pos == null ? Pos.none : pos;
        }

        public record Schedule(String freq, String speed) {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Pos {
        public static final None none = new None();

        default public void ifPresent(Consumer<Position> consumer) {
            Pos pos = this;
            if (pos instanceof Position) {
                Position position = (Position)pos;
                consumer.accept(position);
            }
        }

        public record Position(String eco, String name, String wikiPath, String fen) implements Pos
        {
        }

        public record None() implements Pos
        {
        }
    }

    public record Perf(String icon, String key, String name, Integer position) {
    }

    public record Clock(Integer increment, Integer limit) {
    }
}

