/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.internal.Util;
import chariot.model.Trophy;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public record User(String id, String username, String url, boolean disabled, boolean closed, boolean tosViolation, boolean booster, boolean patron, boolean streaming, boolean followable, boolean following, boolean blocking, boolean followsYou, boolean verified, Optional<String> title, Optional<String> playing, Optional<Profile> profile, List<Trophy> trophies, Long createdAt, Long seenAt, PlayTime playTime, Count count, Perfs perfs) {
    public User {
        string3 = Util.orEmpty(string3);
        list = list == null ? List.of() : list;
    }

    public ZonedDateTime createdTime() {
        return Util.fromLong(this.createdAt());
    }

    public ZonedDateTime seenTime() {
        return Util.fromLong(this.seenAt());
    }

    public record PlayTime(Long total, Long tv) {
    }

    public record Count(Integer all, Integer rated, Integer ai, Integer draw, Integer drawH, Integer loss, Integer lossH, Integer win, Integer winH, Integer bookmark, Integer playing, Integer imported, Integer me) {
    }

    public record Perfs(Perf chess960, Perf atomic, Perf racingKings, Perf ultraBullet, Perf blitz, Perf kingOfTheHill, Perf bullet, Perf correspondence, Perf horde, Perf puzzle, Perf classical, Perf rapid, StormPerf storm) {
        public Perfs {
            perf = Perfs.orNone(perf);
            perf2 = Perfs.orNone(perf2);
            perf3 = Perfs.orNone(perf3);
            perf4 = Perfs.orNone(perf4);
            perf5 = Perfs.orNone(perf5);
            perf6 = Perfs.orNone(perf6);
            perf7 = Perfs.orNone(perf7);
            perf8 = Perfs.orNone(perf8);
            perf9 = Perfs.orNone(perf9);
            perf10 = Perfs.orNone(perf10);
            perf11 = Perfs.orNone(perf11);
            perf12 = Perfs.orNone(perf12);
            stormPerf = stormPerf == null ? StormPerf.none : stormPerf;
        }

        private static Perf orNone(Perf perf) {
            return perf == null ? Perf.none : perf;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface Perf {
            public static final None none = new None();

            default public Optional<Stats> maybe() {
                Optional<Stats> optional;
                Perf perf = this;
                if (perf instanceof Stats) {
                    Stats stats = (Stats)perf;
                    optional = Optional.of(stats);
                } else {
                    optional = Optional.empty();
                }
                return optional;
            }

            default public void ifPresent(Consumer<Stats> consumer) {
                Perf perf = this;
                if (perf instanceof Stats) {
                    Stats stats = (Stats)perf;
                    consumer.accept(stats);
                }
            }

            public record Stats(Integer games, Integer rating, Integer rd, Integer prog, Boolean prov) implements Perf
            {
            }

            public record None() implements Perf
            {
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface StormPerf {
            public static final None none = new None();

            default public Optional<Stats> maybe() {
                Optional<Stats> optional;
                StormPerf stormPerf = this;
                if (stormPerf instanceof Stats) {
                    Stats stats = (Stats)stormPerf;
                    optional = Optional.of(stats);
                } else {
                    optional = Optional.empty();
                }
                return optional;
            }

            default public void ifPresent(Consumer<Stats> consumer) {
                StormPerf stormPerf = this;
                if (stormPerf instanceof Stats) {
                    Stats stats = (Stats)stormPerf;
                    consumer.accept(stats);
                }
            }

            public record Stats(Integer runs, Integer score) implements StormPerf
            {
            }

            public record None() implements StormPerf
            {
            }
        }
    }

    public record Profile(String country, String location, String bio, String firstName, String lastName, String links, Integer fideRating, Integer uscfRating, Integer ecfRating) {
        public Profile {
            string = Util.orEmpty(string);
            string2 = Util.orEmpty(string2);
            string3 = Util.orEmpty(string3);
            string4 = Util.orEmpty(string4);
            string5 = Util.orEmpty(string5);
            string6 = Util.orEmpty(string6);
        }
    }
}

