/*
 * Decompiled with CFR 0.152.
 */
package chariot.util;

import chariot.util.ConsoleRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Board {
    public static Board fromStandardPosition() {
        return Board.fromFEN(FEN.standard);
    }

    public static Board fromFEN(String string) {
        return Board.fromFEN(FEN.parse(string));
    }

    public static Board fromFEN(FEN fEN) {
        return Board.fromFENWithHistory(fEN, List.of());
    }

    private static Board fromFENWithHistory(FEN fEN2, List<FEN> list) {
        Map<Coordinate, Piece> map;
        GameState gameState = GameState.ongoing;
        if (fEN2.halfMoveClock() >= 100) {
            gameState = GameState.draw_by_fifty_move_rule;
        }
        if (gameState == GameState.ongoing && Board.validMoves(fEN2).isEmpty()) {
            map = Board.pieceMap(fEN2.positions());
            Coordinate coordinate = map.entrySet().stream().filter(entry -> ((Piece)entry.getValue()).type() == PieceType.KING && ((Piece)entry.getValue()).color() == fEN2.whoseTurn()).map(entry -> (Coordinate)entry.getKey()).findAny().orElse(Coordinate.rowCol(-1, -1));
            GameState gameState2 = gameState = Board.isCoordinateAttacked(coordinate, fEN2.whoseTurn().other(), map) ? GameState.checkmate : GameState.stalemate;
        }
        record PositionAndMove(String position, int move) {
        }
        if (gameState == GameState.ongoing && Stream.concat(Stream.of(fEN2), list.stream()).map(fEN -> new PositionAndMove(fEN.positions(), fEN.move())).distinct().collect(Collectors.groupingBy(PositionAndMove::position, Collectors.counting())).values().stream().anyMatch(l -> l >= 3L)) {
            gameState = GameState.draw_by_threefold_repetition;
        }
        map = new BoardData(Board.pieceMap(fEN2.positions()), fEN2, list, gameState);
        return map;
    }

    public String toFEN();

    public String to960FEN();

    public String toStandardFEN();

    public Set<Move> validMoves();

    public Board play(String var1);

    default public boolean ended() {
        BoardData boardData;
        Board board = this;
        return board instanceof BoardData && (boardData = (BoardData)board).gameState() != GameState.ongoing;
    }

    default public boolean whiteToMove() {
        return !this.blackToMove();
    }

    default public boolean blackToMove() {
        BoardData boardData;
        Board board = this;
        return board instanceof BoardData && (boardData = (BoardData)board).fen().whoseTurn() == Side.BLACK;
    }

    default public String toString(Consumer<ConsoleRenderer.Config> consumer) {
        return ConsoleRenderer.render(this, consumer);
    }

    public Piece get(Coordinate var1);

    default public Piece get(int n, int n2) {
        return this.get(Coordinate.rowCol(n, n2));
    }

    default public Piece get(String string) {
        return this.get(Coordinate.name(string));
    }

    private static Map<Coordinate, Piece> pieceMap(String string) {
        HashMap<Coordinate, Piece> hashMap = new HashMap<Coordinate, Piece>(32);
        String[] stringArray = string.split("/");
        for (int i = stringArray.length - 1; i >= 0; --i) {
            int n = 0;
            for (char c : stringArray[i].toCharArray()) {
                if (c >= '1' && c <= '8') {
                    n += Character.getNumericValue(c);
                    continue;
                }
                hashMap.put(Coordinate.rowCol(7 - i, n), Piece.parse(c));
                ++n;
            }
        }
        return hashMap;
    }

    private static String positions(Map<Coordinate, Piece> map) {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        for (int i = 7; i >= 0; --i) {
            Object object = "";
            int n = 0;
            for (int j = 0; j <= 7; ++j) {
                Piece piece = map.get(Coordinate.rowCol(i, j));
                if (piece == null) {
                    ++n;
                    continue;
                }
                if (n > 0) {
                    object = (String)object + n;
                    n = 0;
                }
                object = (String)object + piece.letter();
            }
            if (n > 0) {
                object = (String)object + n;
            }
            arrayList.add((String)object);
        }
        return String.join((CharSequence)"/", arrayList);
    }

    public String toSAN(String var1);

    public String toSAN(String ... var1);

    public List<String> toSAN(List<String> var1);

    public String toSAN(Move var1);

    private static Set<Move> validMoves(FEN fEN) {
        return Board.validMoves(fEN, Board.pieceMap(fEN.positions()));
    }

    private static Set<Move> validMoves(FEN fEN, Map<Coordinate, Piece> map) {
        return map.entrySet().stream().filter(entry -> ((Piece)entry.getValue()).color() == fEN.whoseTurn()).flatMap(entry -> Board.validMovesByPiece((Coordinate)entry.getKey(), map, fEN).stream()).collect(Collectors.toSet());
    }

    public static Set<Move> validMovesByPiece(Coordinate coordinate3, Map<Coordinate, Piece> map, FEN fEN) {
        Cloneable cloneable;
        Coordinate coordinate4;
        Piece piece = map.get(coordinate3);
        if (piece == null) {
            return Set.of();
        }
        Coordinate coordinate5 = coordinate4 = piece.type() == PieceType.KING ? coordinate3 : (Coordinate)map.entrySet().stream().filter(entry -> ((Piece)entry.getValue()).type() == PieceType.KING && ((Piece)entry.getValue()).color() == piece.color()).map(entry -> (Coordinate)entry.getKey()).findAny().orElse(null);
        if (coordinate4 == null) {
            System.err.println("No king: " + String.valueOf(fEN));
            return Set.of();
        }
        int n = coordinate3.row();
        int n2 = coordinate3.col();
        Set<Coordinate> set = Board.coordinatesAttackedByPiece(coordinate3, map);
        Set set2 = switch (piece.type()) {
            default -> throw new IncompatibleClassChangeError();
            case PieceType.PAWN -> {
                cloneable = new HashSet<Record>();
                cloneable.addAll(set.stream().filter(coordinate -> map.containsKey(coordinate) && ((Piece)map.get(coordinate)).color() == piece.color().other() || coordinate.name().equals(fEN.ep())).map(coordinate2 -> new FromTo(coordinate3, (Coordinate)coordinate2)).toList());
                Coordinate var10_9 = Coordinate.rowCol(n + (piece.color() == Side.BLACK ? -1 : 1), n2);
                if (!map.containsKey(var10_9)) {
                    Coordinate var11_10;
                    cloneable.add(new FromTo(coordinate3, var10_9));
                    if ((n == 1 && piece.color() == Side.WHITE || n == 6 && piece.color() == Side.BLACK) && !map.containsKey(var11_10 = Coordinate.rowCol(n + (piece.color() == Side.BLACK ? -2 : 2), n2))) {
                        cloneable.add(new FromTo(coordinate3, var11_10));
                    }
                }
                yield cloneable;
            }
            case PieceType.KNIGHT, PieceType.BISHOP, PieceType.ROOK, PieceType.QUEEN -> set.stream().filter(coordinate -> !map.containsKey(coordinate) || map.containsKey(coordinate) && ((Piece)map.get(coordinate)).color() == piece.color().other()).map(coordinate2 -> new FromTo(coordinate3, (Coordinate)coordinate2)).collect(Collectors.toSet());
            case PieceType.KING -> {
                cloneable = new HashSet();
                cloneable.addAll(set.stream().filter(coordinate -> !map.containsKey(coordinate) || map.containsKey(coordinate) && ((Piece)map.get(coordinate)).color() == piece.color().other()).map(coordinate2 -> new FromTo(coordinate3, (Coordinate)coordinate2)).toList());
                cloneable.addAll(fEN.castlingRights().validCastlingMoves(coordinate3, Board::isCoordinateAttacked, map));
                yield cloneable;
            }
        };
        cloneable = new HashMap<Coordinate, Piece>(map);
        return set2.stream().filter(move -> {
            boolean bl = false;
            if (move instanceof FromTo) {
                FromTo fromTo = (FromTo)move;
                Piece piece2 = (Piece)cloneable.remove(fromTo.from());
                Piece piece3 = cloneable.put(fromTo.to(), piece2);
                bl = !Board.isCoordinateAttacked(piece2.type() == PieceType.KING ? fromTo.to() : coordinate4, piece.color().other(), cloneable);
                cloneable.put(fromTo.from(), piece2);
                if (piece3 != null) {
                    cloneable.put(fromTo.to(), piece3);
                } else {
                    cloneable.remove(fromTo.to());
                }
            } else if (move instanceof Castling) {
                Castling castling = (Castling)move;
                bl = true;
            } else if (move instanceof Invalid) {
                Invalid invalid = (Invalid)move;
            }
            return bl;
        }).collect(Collectors.toSet());
    }

    public static boolean isCoordinateAttacked(Coordinate coordinate, Side side, Map<Coordinate, Piece> map) {
        return map.entrySet().stream().filter(entry -> ((Piece)entry.getValue()).color() == side).map(entry -> Board.coordinatesAttackedByPiece((Coordinate)entry.getKey(), map)).anyMatch(set -> set.contains(coordinate));
    }

    public static Set<Coordinate> coordinatesAttackedByPiece(Coordinate coordinate2, Map<Coordinate, Piece> map) {
        record Dir(int dx, int dy) {
        }
        Piece piece = map.get(coordinate2);
        if (piece == null) {
            return Set.of();
        }
        int n = coordinate2.row();
        int n2 = coordinate2.col();
        Set<Coordinate> set = switch (piece.type()) {
            default -> throw new IncompatibleClassChangeError();
            case PieceType.PAWN -> Set.of(Coordinate.rowCol(n + (piece.color() == Side.BLACK ? -1 : 1), n2 - 1), Coordinate.rowCol(n + (piece.color() == Side.BLACK ? -1 : 1), n2 + 1));
            case PieceType.KNIGHT -> Set.of(Coordinate.rowCol(n + 1, n2 + 2), Coordinate.rowCol(n + 1, n2 - 2), Coordinate.rowCol(n - 1, n2 + 2), Coordinate.rowCol(n - 1, n2 - 2), Coordinate.rowCol(n + 2, n2 + 1), Coordinate.rowCol(n + 2, n2 - 1), Coordinate.rowCol(n - 2, n2 + 1), Coordinate.rowCol(n - 2, n2 - 1));
            case PieceType.BISHOP -> {
                Coordinate var11_10;
                int var10_9;
                int var9_8;
                HashSet<Coordinate> var6_5 = new HashSet<Coordinate>();
                block8: for (Dir var8_7 : List.of(new Dir(-1, 1), new Dir(1, 1), new Dir(-1, -1), new Dir(1, -1))) {
                    var9_8 = n + var8_7.dy();
                    for (var10_9 = n2 + var8_7.dx(); var9_8 >= 0 && var9_8 <= 7 && var10_9 >= 0 && var10_9 <= 7; var9_8 += var8_7.dy(), var10_9 += var8_7.dx()) {
                        var11_10 = Coordinate.rowCol(var9_8, var10_9);
                        var6_5.add(var11_10);
                        if (map.containsKey(var11_10)) continue block8;
                    }
                }
                yield var6_5;
            }
            case PieceType.ROOK -> {
                Coordinate var11_10;
                int var10_9;
                int var9_8;
                HashSet<Coordinate> var6_5 = new HashSet();
                block10: for (Dir var8_7 : List.of(new Dir(0, 1), new Dir(0, -1), new Dir(1, 0), new Dir(-1, 0))) {
                    var9_8 = n + var8_7.dy();
                    for (var10_9 = n2 + var8_7.dx(); var9_8 >= 0 && var9_8 <= 7 && var10_9 >= 0 && var10_9 <= 7; var9_8 += var8_7.dy(), var10_9 += var8_7.dx()) {
                        var11_10 = Coordinate.rowCol(var9_8, var10_9);
                        var6_5.add(var11_10);
                        if (map.containsKey(var11_10)) continue block10;
                    }
                }
                yield var6_5;
            }
            case PieceType.QUEEN -> {
                Coordinate var11_10;
                int var10_9;
                int var9_8;
                HashSet<Coordinate> var6_5 = new HashSet();
                block12: for (Dir var8_7 : List.of(new Dir(0, 1), new Dir(0, -1), new Dir(1, 0), new Dir(-1, 0), new Dir(-1, 1), new Dir(1, 1), new Dir(-1, -1), new Dir(1, -1))) {
                    var9_8 = n + var8_7.dy();
                    for (var10_9 = n2 + var8_7.dx(); var9_8 >= 0 && var9_8 <= 7 && var10_9 >= 0 && var10_9 <= 7; var9_8 += var8_7.dy(), var10_9 += var8_7.dx()) {
                        var11_10 = Coordinate.rowCol(var9_8, var10_9);
                        var6_5.add(var11_10);
                        if (map.containsKey(var11_10)) continue block12;
                    }
                }
                yield var6_5;
            }
            case PieceType.KING -> Set.of(Coordinate.rowCol(n + 1, n2 + 1), Coordinate.rowCol(n + 1, n2), Coordinate.rowCol(n + 1, n2 - 1), Coordinate.rowCol(n, n2 - 1), Coordinate.rowCol(n, n2 + 1), Coordinate.rowCol(n - 1, n2 + 1), Coordinate.rowCol(n - 1, n2), Coordinate.rowCol(n - 1, n2 - 1));
        };
        return set.stream().filter(coordinate -> coordinate.row() >= 0 && coordinate.row() <= 7 && coordinate.col() >= 0 && coordinate.col() <= 7).collect(Collectors.toSet());
    }

    public record FEN(String positions, Side whoseTurn, CastlingRights castlingRights, String ep, int halfMoveClock, int move) {
        public static final FEN standard = new FEN("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR", Side.WHITE, CastlingRights.parse("KQkq"), "-", 0, 1);

        FEN with(Component component) {
            int n;
            int n2;
            String string;
            CastlingRights castlingRights;
            Side side;
            String string2;
            Record record;
            if (component instanceof Positions) {
                record = (Positions)component;
                string2 = record.value;
            } else {
                string2 = this.positions();
            }
            if (component instanceof WhoseTurn) {
                record = (WhoseTurn)component;
                side = ((WhoseTurn)record).value;
            } else {
                side = this.whoseTurn();
            }
            if (component instanceof Castling) {
                record = (Castling)component;
                castlingRights = ((Castling)record).value;
            } else {
                castlingRights = this.castlingRights();
            }
            if (component instanceof EP) {
                record = (EP)component;
                string = ((EP)record).value;
            } else {
                string = this.ep();
            }
            if (component instanceof HalfMoveClock) {
                record = (HalfMoveClock)component;
                n2 = ((HalfMoveClock)record).value;
            } else {
                n2 = this.halfMoveClock();
            }
            if (component instanceof Move) {
                record = (Move)component;
                n = ((Move)record).value;
            } else {
                n = this.move();
            }
            return new FEN(string2, side, castlingRights, string, n2, n);
        }

        FEN with(Component ... componentArray) {
            FEN fEN = this;
            for (Component component : componentArray) {
                fEN = fEN.with(component);
            }
            return fEN;
        }

        static FEN parse(String string) {
            FEN fEN = standard;
            String[] stringArray = string.split(" ");
            if (stringArray.length > 0) {
                fEN = fEN.with((Component)new Positions(stringArray[0]));
            }
            if (stringArray.length > 1) {
                fEN = fEN.with((Component)new WhoseTurn("b".equals(stringArray[1]) ? Side.BLACK : Side.WHITE));
            }
            if (stringArray.length > 2) {
                fEN = fEN.with((Component)new Castling(CastlingRights.parse(stringArray[2], fEN.positions())));
            }
            if (stringArray.length > 3) {
                fEN = fEN.with((Component)new EP(stringArray[3]));
            }
            if (stringArray.length > 4) {
                fEN = fEN.with((Component)new HalfMoveClock(Integer.parseInt(stringArray[4])));
            }
            if (stringArray.length > 5) {
                fEN = fEN.with((Component)new Move(Integer.parseInt(stringArray[5])));
            }
            return fEN;
        }

        @Override
        public String toString() {
            return "%s %s %s %s %d %d".formatted(this.positions, Character.valueOf(this.whoseTurn.toChar()), this.castlingRights.toString(), this.ep, this.halfMoveClock, this.move);
        }

        public String asStandard() {
            return "%s %s %s %s %d %d".formatted(this.positions, Character.valueOf(this.whoseTurn.toChar()), this.castlingRights.asStandard(), this.ep, this.halfMoveClock, this.move);
        }

        public String as960() {
            return "%s %s %s %s %d %d".formatted(this.positions, Character.valueOf(this.whoseTurn.toChar()), this.castlingRights.as960(), this.ep, this.halfMoveClock, this.move);
        }

        record Positions(String value) implements Component
        {
        }

        record WhoseTurn(Side value) implements Component
        {
        }

        record Castling(CastlingRights value) implements Component
        {
        }

        record EP(String value) implements Component
        {
        }

        record HalfMoveClock(int value) implements Component
        {
        }

        record Move(int value) implements Component
        {
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static interface Component {
        }
    }

    public static enum GameState {
        ongoing,
        draw_by_threefold_repetition,
        draw_by_fifty_move_rule,
        stalemate,
        checkmate;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Coordinate {
        public int row();

        public int col();

        default public String name() {
            return Character.toString(97 + this.col()) + String.valueOf(this.row() + 1);
        }

        public static Coordinate rowCol(int n, int n2) {
            return new RowCol(n, n2);
        }

        public static Coordinate name(String string) {
            return Coordinate.rowCol(Character.getNumericValue(string.charAt(1)) - 1, Character.getNumericValue(55 - (104 - string.toLowerCase().charAt(0))));
        }
    }

    public static enum Side {
        BLACK,
        WHITE;


        Side other() {
            return this == BLACK ? WHITE : BLACK;
        }

        char toChar() {
            return this == BLACK ? (char)'b' : 'w';
        }
    }

    public record BoardData(Map<Coordinate, Piece> pieceMap, FEN fen, List<FEN> history, GameState gameState) implements Board
    {
        public BoardData {
            map = Map.copyOf(map);
            list = List.copyOf(list);
        }

        @Override
        public Piece get(Coordinate coordinate) {
            return this.pieceMap.get(coordinate);
        }

        @Override
        public String toFEN() {
            return this.fen().toString();
        }

        @Override
        public String to960FEN() {
            return this.fen().as960();
        }

        @Override
        public String toStandardFEN() {
            return this.fen().asStandard();
        }

        @Override
        public Set<Move> validMoves() {
            return Board.validMoves(this.fen(), this.pieceMap());
        }

        @Override
        public String toString() {
            return ConsoleRenderer.render(this);
        }

        @Override
        public Board play(String string) {
            if (string.contains(" ")) {
                return this.playMultipleMoves(Arrays.stream(string.split(" ")));
            }
            return this.playSingleMove(Move.parse(string, this.fen));
        }

        private Board playMultipleMoves(Stream<String> stream) {
            return stream.reduce(this, (board, string) -> board.play((String)string), (board, board2) -> board);
        }

        private Board playSingleMove(Move move) {
            Object object;
            Object object2;
            if (this.ended()) {
                return this;
            }
            FEN fEN = this.fen();
            HashMap<Coordinate, Piece> hashMap = new HashMap<Coordinate, Piece>(this.pieceMap);
            boolean bl = false;
            String string = "-";
            if (move instanceof FromTo) {
                object2 = (FromTo)move;
                Piece piece = (Piece)hashMap.remove(((FromTo)object2).from());
                Piece piece2 = hashMap.put(((FromTo)object2).to(), piece);
                switch (piece.type()) {
                    case PAWN: {
                        if (((FromTo)object2).from().col() != ((FromTo)object2).to().col() && piece2 == null) {
                            hashMap.remove(Coordinate.rowCol(((FromTo)object2).from().row(), ((FromTo)object2).to().col()));
                        }
                        bl = true;
                        if (piece.color() == Side.BLACK) {
                            if (((FromTo)object2).from().row() != 6 || ((FromTo)object2).to().row() != 4) break;
                            Piece piece3 = this.pieceMap().get(Coordinate.rowCol(4, ((FromTo)object2).from().col() - 1));
                            Piece piece4 = this.pieceMap().get(Coordinate.rowCol(4, ((FromTo)object2).from().col() + 1));
                            if (piece3 != null && piece3.type() == PieceType.PAWN && piece3.color() == Side.WHITE) {
                                string = Coordinate.rowCol(5, ((FromTo)object2).from().col()).name();
                                break;
                            }
                            if (piece4 == null || piece4.type() != PieceType.PAWN || piece4.color() != Side.WHITE) break;
                            string = Coordinate.rowCol(5, ((FromTo)object2).from().col()).name();
                            break;
                        }
                        if (((FromTo)object2).from().row() != 1 || ((FromTo)object2).to().row() != 3) break;
                        Piece piece5 = this.pieceMap().get(Coordinate.rowCol(3, ((FromTo)object2).from().col() - 1));
                        Piece piece6 = this.pieceMap().get(Coordinate.rowCol(3, ((FromTo)object2).from().col() + 1));
                        if (piece5 != null && piece5.type() == PieceType.PAWN && piece5.color() == Side.BLACK) {
                            string = Coordinate.rowCol(2, ((FromTo)object2).from().col()).name();
                            break;
                        }
                        if (piece6 == null || piece6.type() != PieceType.PAWN || piece6.color() != Side.BLACK) break;
                        string = Coordinate.rowCol(2, ((FromTo)object2).from().col()).name();
                        break;
                    }
                    case KING: {
                        CastlingRights castlingRights = this.fen().castlingRights().withoutQueenSide(piece.color()).withoutKingSide(piece.color());
                        fEN = fEN.with((FEN.Component)new FEN.Castling(castlingRights));
                        break;
                    }
                    case ROOK: {
                        String string2;
                        String string3;
                        CastlingRights castlingRights = this.fen().castlingRights();
                        String string4 = string3 = piece.color() == Side.WHITE ? castlingRights.files().Q() : castlingRights.files().q();
                        if (!string3.isEmpty() && ((FromTo)object2).from().equals(Coordinate.name(string3 + (piece.color() == Side.WHITE ? "1" : "8")))) {
                            castlingRights = castlingRights.withoutQueenSide(piece.color());
                        }
                        String string5 = string2 = piece.color() == Side.WHITE ? castlingRights.files().K() : castlingRights.files().k();
                        if (!string2.isEmpty() && ((FromTo)object2).from().equals(Coordinate.name(string2 + (piece.color() == Side.WHITE ? "1" : "8")))) {
                            castlingRights = castlingRights.withoutKingSide(piece.color());
                        }
                        fEN = fEN.with((FEN.Component)new FEN.Castling(castlingRights));
                        break;
                    }
                }
                if (piece2 != null) {
                    bl = true;
                }
            } else if (move instanceof Promotion) {
                object = (Promotion)move;
                Piece piece = (Piece)hashMap.remove(((Promotion)object).pawn().from());
                Coordinate coordinate = ((Promotion)object).pawn().to();
                Piece piece7 = Piece.piece(((Promotion)object).piece(), piece.color());
                Piece piece8 = hashMap.put(coordinate, piece7);
                bl = true;
            } else if (move instanceof Castling) {
                Castling castling = (Castling)move;
                Piece piece = (Piece)hashMap.remove(castling.king().from());
                Piece piece9 = (Piece)hashMap.remove(castling.rook().from());
                Piece piece10 = hashMap.put(castling.king().to(), piece);
                Piece piece11 = hashMap.put(castling.rook().to(), piece9);
                fEN = fEN.with((FEN.Component)new FEN.Castling(this.fen().castlingRights().withoutQueenSide(piece.color()).withoutKingSide(piece.color())));
            } else if (move instanceof Invalid) {
                Invalid invalid = (Invalid)move;
                System.err.println("Invalid move: " + String.valueOf(invalid));
                return this;
            }
            fEN = fEN.with((FEN.Component)new FEN.Positions(Board.positions(hashMap)));
            fEN = fEN.with((FEN.Component)new FEN.WhoseTurn(this.fen().whoseTurn().other()));
            fEN = fEN.with((FEN.Component)new FEN.EP(string));
            fEN = bl ? fEN.with((FEN.Component)new FEN.HalfMoveClock(0)) : fEN.with((FEN.Component)new FEN.HalfMoveClock(this.fen().halfMoveClock() + 1));
            if (this.fen().whoseTurn() == Side.BLACK) {
                fEN = fEN.with((FEN.Component)new FEN.Move(this.fen().move() + 1));
            }
            object2 = new ArrayList<FEN>(this.history);
            ((ArrayList)object2).add(this.fen());
            object = Board.fromFENWithHistory(fEN, List.copyOf(object2));
            return object;
        }

        @Override
        public String toSAN(String string) {
            if (string.contains(" ")) {
                return String.join((CharSequence)" ", this.multipleMovesToSAN(string.split(" ")));
            }
            return this.singleMoveToSAN(string);
        }

        @Override
        public String toSAN(String ... stringArray) {
            return String.join((CharSequence)" ", this.multipleMovesToSAN(stringArray));
        }

        @Override
        public List<String> toSAN(List<String> list) {
            return this.multipleMovesToSAN(list.stream());
        }

        private List<String> multipleMovesToSAN(String[] stringArray) {
            return this.multipleMovesToSAN(Arrays.stream(stringArray));
        }

        private List<String> multipleMovesToSAN(Stream<String> stream) {
            record BoardMoves(Board board, List<String> sans) {
            }
            BoardMoves boardMoves3 = stream.reduce(new BoardMoves(this, new ArrayList<String>()), (boardMoves, string) -> {
                boardMoves.sans().add(boardMoves.board().toSAN((String)string));
                return new BoardMoves(boardMoves.board().play((String)string), boardMoves.sans());
            }, (boardMoves, boardMoves2) -> boardMoves);
            return boardMoves3.sans();
        }

        private String singleMoveToSAN(String string) {
            return this.toSAN(Move.parse(string, this.fen));
        }

        @Override
        public String toSAN(Move move) {
            Record record;
            if (move instanceof Invalid) {
                Invalid invalid = (Invalid)move;
                return "";
            }
            Object object = this.playSingleMove(move);
            String string = object instanceof BoardData ? (((BoardData)(record = (BoardData)object)).gameState() == GameState.checkmate ? "#" : (((Boolean)(object = ((BoardData)record).pieceMap().entrySet().stream().filter(entry -> ((Piece)entry.getValue()).type() == PieceType.KING && ((Piece)entry.getValue()).color() == this.fen().whoseTurn().other()).findFirst().map(arg_0 -> this.lambda$toSAN$5((BoardData)record, arg_0)).orElse(false))).booleanValue() ? "+" : "")) : "";
            if (move instanceof FromTo) {
                record = (FromTo)move;
                object = this.pieceMap().get(((FromTo)record).from());
                if (object == null) {
                    return "-";
                }
                if (object.color() != this.fen().whoseTurn()) {
                    return "-";
                }
                if (object.type() == PieceType.PAWN) {
                    if (this.pieceMap().containsKey(((FromTo)record).to()) || ((FromTo)record).from().col() != ((FromTo)record).to().col()) {
                        String string2 = ((FromTo)record).from().name().substring(0, 1);
                        String string3 = "x";
                        String string4 = ((FromTo)record).to().name();
                        String string5 = "%s%s%s%s".formatted(string2, string3, string4, string);
                        return string5;
                    }
                    String string6 = ((FromTo)record).to().name();
                    String string7 = "%s%s".formatted(string6, string);
                    return string7;
                }
                if (object.type() == PieceType.KING) {
                    String string8 = "K";
                    String string9 = this.pieceMap().containsKey(((FromTo)record).to()) ? "x" : "";
                    String string10 = ((FromTo)record).to().name();
                    String string11 = "%s%s%s%s".formatted(string8, string9, string10, string);
                    return string11;
                }
                List<Map.Entry> list = this.pieceMap().entrySet().stream().filter(arg_0 -> BoardData.lambda$toSAN$6((Piece)object, arg_0)).filter(arg_0 -> BoardData.lambda$toSAN$7((Piece)object, arg_0)).filter(arg_0 -> this.lambda$toSAN$8((FromTo)record, arg_0)).toList();
                record Unique(boolean file, boolean rank) {
                }
                Unique unique3 = list.stream().reduce(new Unique(true, true), (arg_0, arg_1) -> BoardData.lambda$toSAN$9((FromTo)record, arg_0, arg_1), (unique, unique2) -> new Unique(unique.file() && unique2.file(), unique.rank() && unique2.rank()));
                String string12 = object.letter().toUpperCase();
                String string13 = unique3.file() && unique3.rank() ? "" : (unique3.file() ? ((FromTo)record).from().name().substring(1, 2) : (unique3.rank() ? ((FromTo)record).from().name().substring(0, 1) : ((FromTo)record).from().name()));
                String string14 = this.pieceMap().containsKey(((FromTo)record).to()) ? "x" : "";
                String string15 = ((FromTo)record).to().name();
                String string16 = "%s%s%s%s%s".formatted(string12, string13, string14, string15, string);
                return string16;
            }
            if (move instanceof Castling) {
                record = (Castling)move;
                object = ((Castling)record).king().from().col() < ((Castling)record).rook().from().col() ? "O-O" : "O-O-O";
                String string17 = "%s%s".formatted(object, string);
                return string17;
            }
            if (move instanceof Promotion) {
                record = (Promotion)move;
                if (this.pieceMap().containsKey(((Promotion)record).pawn().to())) {
                    object = ((Promotion)record).pawn().from().name().substring(0, 1);
                    String string18 = "x";
                    String string19 = ((Promotion)record).pawn().to().name();
                    String string20 = "=" + ((Promotion)record).piece().toChar();
                    String string21 = "%s%s%s%s%s".formatted(object, string18, string19, string20, string);
                    return string21;
                }
                object = ((Promotion)record).pawn().to().name();
                String string22 = "=" + ((Promotion)record).piece().toChar();
                String string23 = "%s%s%s".formatted(object, string22, string);
                return string23;
            }
            return "";
        }

        private static /* synthetic */ 1Unique lambda$toSAN$9(FromTo fromTo, 1Unique unique, Map.Entry entry) {
            return new Unique(unique.file() && ((Coordinate)entry.getKey()).col() != fromTo.from().col(), unique.rank() && ((Coordinate)entry.getKey()).row() != fromTo.from().row());
        }

        private /* synthetic */ boolean lambda$toSAN$8(FromTo fromTo, Map.Entry entry) {
            return Board.coordinatesAttackedByPiece((Coordinate)entry.getKey(), this.pieceMap()).contains(fromTo.to());
        }

        private static /* synthetic */ boolean lambda$toSAN$7(Piece piece, Map.Entry entry) {
            return entry.getValue() != piece;
        }

        private static /* synthetic */ boolean lambda$toSAN$6(Piece piece, Map.Entry entry) {
            return ((Piece)entry.getValue()).type() == piece.type() && ((Piece)entry.getValue()).color() == piece.color();
        }

        private /* synthetic */ Boolean lambda$toSAN$5(BoardData boardData, Map.Entry entry) {
            return Board.isCoordinateAttacked((Coordinate)entry.getKey(), this.fen().whoseTurn(), boardData.pieceMap());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Piece {
        public PieceType type();

        public Side color();

        public static Piece piece(PieceType pieceType, Side side) {
            return new StandardPiece(pieceType, side);
        }

        public static Piece parse(char c) {
            return switch (c) {
                case 'p' -> Piece.piece(PieceType.PAWN, Side.BLACK);
                case 'n' -> Piece.piece(PieceType.KNIGHT, Side.BLACK);
                case 'b' -> Piece.piece(PieceType.BISHOP, Side.BLACK);
                case 'r' -> Piece.piece(PieceType.ROOK, Side.BLACK);
                case 'q' -> Piece.piece(PieceType.QUEEN, Side.BLACK);
                case 'k' -> Piece.piece(PieceType.KING, Side.BLACK);
                case 'P' -> Piece.piece(PieceType.PAWN, Side.WHITE);
                case 'N' -> Piece.piece(PieceType.KNIGHT, Side.WHITE);
                case 'B' -> Piece.piece(PieceType.BISHOP, Side.WHITE);
                case 'R' -> Piece.piece(PieceType.ROOK, Side.WHITE);
                case 'Q' -> Piece.piece(PieceType.QUEEN, Side.WHITE);
                case 'K' -> Piece.piece(PieceType.KING, Side.WHITE);
                default -> throw new RuntimeException("Unknown piece " + c);
            };
        }

        default public String letter() {
            return switch (this.type()) {
                default -> throw new IncompatibleClassChangeError();
                case PieceType.PAWN -> {
                    if (this.color() == Side.BLACK) {
                        yield "p";
                    }
                    yield "P";
                }
                case PieceType.KNIGHT -> {
                    if (this.color() == Side.BLACK) {
                        yield "n";
                    }
                    yield "N";
                }
                case PieceType.BISHOP -> {
                    if (this.color() == Side.BLACK) {
                        yield "b";
                    }
                    yield "B";
                }
                case PieceType.ROOK -> {
                    if (this.color() == Side.BLACK) {
                        yield "r";
                    }
                    yield "R";
                }
                case PieceType.QUEEN -> {
                    if (this.color() == Side.BLACK) {
                        yield "q";
                    }
                    yield "Q";
                }
                case PieceType.KING -> this.color() == Side.BLACK ? "k" : "K";
            };
        }

        default public String unicode() {
            return switch (this.type()) {
                default -> throw new IncompatibleClassChangeError();
                case PieceType.PAWN -> {
                    if (this.color() == Side.BLACK) {
                        yield "\u265f";
                    }
                    yield "\u2659";
                }
                case PieceType.KNIGHT -> {
                    if (this.color() == Side.BLACK) {
                        yield "\u265e";
                    }
                    yield "\u2658";
                }
                case PieceType.BISHOP -> {
                    if (this.color() == Side.BLACK) {
                        yield "\u265d";
                    }
                    yield "\u2657";
                }
                case PieceType.ROOK -> {
                    if (this.color() == Side.BLACK) {
                        yield "\u265c";
                    }
                    yield "\u2656";
                }
                case PieceType.QUEEN -> {
                    if (this.color() == Side.BLACK) {
                        yield "\u265b";
                    }
                    yield "\u2655";
                }
                case PieceType.KING -> this.color() == Side.BLACK ? "\u265a" : "\u2654";
            };
        }
    }

    public static enum PieceType {
        PAWN,
        KNIGHT,
        BISHOP,
        ROOK,
        QUEEN,
        KING;


        char toChar() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case PAWN -> 'P';
                case KNIGHT -> 'N';
                case BISHOP -> 'B';
                case ROOK -> 'R';
                case QUEEN -> 'Q';
                case KING -> 'K';
            };
        }
    }

    public record FromTo(Coordinate from, Coordinate to) implements Move
    {
        @Override
        public String toString() {
            return this.uci();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CastlingRights {
        default public CastlingRights withoutKingSide(Side side) {
            RookFiles rookFiles = new RookFiles(side == Side.WHITE ? "" : this.files().K(), this.files().Q(), side == Side.WHITE ? this.files().k() : "", this.files().q());
            if (this instanceof Standard) {
                return new Standard(rookFiles);
            }
            return new Chess960(rookFiles);
        }

        default public CastlingRights withoutQueenSide(Side side) {
            RookFiles rookFiles = new RookFiles(this.files().K(), side == Side.WHITE ? "" : this.files().Q(), this.files().k(), side == Side.WHITE ? this.files().q() : "");
            if (this instanceof Standard) {
                return new Standard(rookFiles);
            }
            return new Chess960(rookFiles);
        }

        public static CastlingRights parse(String string, String string2) {
            Map<Coordinate, Piece> map = Board.pieceMap(string2);
            List<Map.Entry> list = map.entrySet().stream().filter(entry -> ((Piece)entry.getValue()).type() == PieceType.KING).toList();
            char c = list.stream().filter(entry -> ((Piece)entry.getValue()).color() == Side.WHITE).map(entry -> Character.valueOf(((Coordinate)entry.getKey()).name().charAt(0))).findAny().orElse(Character.valueOf('e')).charValue();
            char c3 = list.stream().filter(entry -> ((Piece)entry.getValue()).color() == Side.BLACK).map(entry -> Character.valueOf(((Coordinate)entry.getKey()).name().charAt(0))).findAny().orElse(Character.valueOf('e')).charValue();
            List<Map.Entry> list2 = map.entrySet().stream().filter(entry -> ((Piece)entry.getValue()).type() == PieceType.ROOK).toList();
            char c4 = list2.stream().filter(entry -> ((Piece)entry.getValue()).color() == Side.WHITE).map(entry -> Character.valueOf(((Coordinate)entry.getKey()).name().charAt(0))).filter(c2 -> c2.charValue() > c).findAny().orElse(Character.valueOf('h')).charValue();
            char c5 = list2.stream().filter(entry -> ((Piece)entry.getValue()).color() == Side.WHITE).map(entry -> Character.valueOf(((Coordinate)entry.getKey()).name().charAt(0))).filter(c2 -> c2.charValue() < c).findAny().orElse(Character.valueOf('a')).charValue();
            char c6 = list2.stream().filter(entry -> ((Piece)entry.getValue()).color() == Side.BLACK).map(entry -> Character.valueOf(((Coordinate)entry.getKey()).name().charAt(0))).filter(c2 -> c2.charValue() > c3).findAny().orElse(Character.valueOf('h')).charValue();
            char c7 = list2.stream().filter(entry -> ((Piece)entry.getValue()).color() == Side.BLACK).map(entry -> Character.valueOf(((Coordinate)entry.getKey()).name().charAt(0))).filter(c2 -> c2.charValue() < c3).findAny().orElse(Character.valueOf('a')).charValue();
            return CastlingRights.parse(string, c, c3, c4, c5, c6, c7);
        }

        public static CastlingRights parse(String string) {
            return CastlingRights.parse(string, 'e', 'e', 'h', 'a', 'h', 'a');
        }

        private static CastlingRights parse(String string, char c, char c2, char c3, char c4, char c5, char c6) {
            if (string.isEmpty() || string.equals("-")) {
                return new Standard(new RookFiles("", "", "", ""));
            }
            if ("abcdefgh".chars().anyMatch(n -> string.toLowerCase().contains(Character.toString(n)))) {
                String string2 = "abcdefgh".toUpperCase().chars().filter(n -> n > Character.toUpperCase(c)).mapToObj(Character::toString).filter(string::contains).findAny().orElse("");
                String string3 = "abcdefgh".toUpperCase().chars().filter(n -> n < Character.toUpperCase(c)).mapToObj(Character::toString).filter(string::contains).findAny().orElse("");
                String string4 = "abcdefgh".chars().filter(n -> n > c2).mapToObj(Character::toString).filter(string::contains).findAny().orElse("");
                String string5 = "abcdefgh".chars().filter(n -> n < c2).mapToObj(Character::toString).filter(string::contains).findAny().orElse("");
                return new Chess960(new RookFiles(string2, string3, string4, string5));
            }
            String string6 = string.contains("K") ? Character.toString(c3).toUpperCase() : "";
            String string7 = string.contains("Q") ? Character.toString(c4).toUpperCase() : "";
            String string8 = string.contains("k") ? Character.toString(c5) : "";
            String string9 = string.contains("q") ? Character.toString(c6) : "";
            return new Standard(new RookFiles(string6, string7, string8, string9));
        }

        public RookFiles files();

        default public String asStandard() {
            return CastlingRights.dashIfEmpty(String.join((CharSequence)"", this.files().K.isEmpty() ? "" : "K", this.files().Q().isEmpty() ? "" : "Q", this.files().k().isEmpty() ? "" : "k", this.files().q().isEmpty() ? "" : "q"));
        }

        default public String as960() {
            return CastlingRights.dashIfEmpty(String.join((CharSequence)"", this.files().K, this.files().Q(), this.files().k(), this.files().q()));
        }

        public static String dashIfEmpty(String string) {
            return string.isEmpty() ? "-" : string;
        }

        default public Set<Castling> validCastlingMoves(Coordinate coordinate2, AttackedCoordinatePredicate attackedCoordinatePredicate, Map<Coordinate, Piece> map) {
            int n;
            int n2;
            Object object;
            Piece piece;
            Coordinate coordinate3;
            Piece piece2 = map.get(coordinate2);
            if (piece2 == null) {
                return Set.of();
            }
            if (attackedCoordinatePredicate.test(coordinate2, piece2.color().other(), map)) {
                return Set.of();
            }
            HashSet<Castling> hashSet = new HashSet<Castling>(2);
            Coordinate coordinate4 = Coordinate.name("g" + (piece2.color() == Side.WHITE ? "1" : "8"));
            Coordinate coordinate5 = Coordinate.name("f" + (piece2.color() == Side.WHITE ? "1" : "8"));
            Coordinate coordinate6 = Coordinate.name("c" + (piece2.color() == Side.WHITE ? "1" : "8"));
            Coordinate coordinate7 = Coordinate.name("d" + (piece2.color() == Side.WHITE ? "1" : "8"));
            Coordinate coordinate8 = piece2.color() == Side.WHITE ? ("".equals(this.files().K()) ? null : Coordinate.name(this.files().K().toLowerCase() + "1")) : (coordinate3 = "".equals(this.files().k()) ? null : Coordinate.name(this.files().k().toLowerCase() + "8"));
            if (coordinate3 != null && (piece = map.get(coordinate3)) != null && piece.type() == PieceType.ROOK && piece.color() == piece2.color()) {
                int n3;
                object = new HashSet(8);
                for (int i = n3 = coordinate3.col() - coordinate5.col(); i != 0; i -= n3 > 0 ? 1 : -1) {
                    object.add(Coordinate.rowCol(coordinate3.row(), coordinate5.col() + i));
                }
                HashSet<Coordinate> hashSet2 = new HashSet<Coordinate>(8);
                for (n = n2 = coordinate2.col() - coordinate4.col(); n != 0; n -= n2 > 0 ? 1 : -1) {
                    hashSet2.add(Coordinate.rowCol(coordinate2.row(), coordinate4.col() + n));
                }
                object.remove(coordinate2);
                object.remove(coordinate3);
                hashSet2.remove(coordinate2);
                hashSet2.remove(coordinate3);
                if (object.stream().noneMatch(coordinate -> map.containsKey(coordinate)) && hashSet2.stream().noneMatch(coordinate -> map.containsKey(coordinate)) && hashSet2.stream().noneMatch(coordinate -> attackedCoordinatePredicate.test((Coordinate)coordinate, piece2.color().other(), map))) {
                    hashSet.add(new Castling(new FromTo(coordinate2, coordinate4), new FromTo(coordinate3, coordinate5)));
                }
            }
            Object object2 = piece2.color() == Side.WHITE ? ("".equals(this.files().Q()) ? null : Coordinate.name(this.files().Q().toLowerCase() + "1")) : (piece = "".equals(this.files().q()) ? null : Coordinate.name(this.files().q().toLowerCase() + "8"));
            if (piece != null && (object = map.get(piece)) != null && object.type() == PieceType.ROOK && object.color() == piece2.color()) {
                int n4;
                HashSet<Coordinate> hashSet3 = new HashSet<Coordinate>(8);
                for (n2 = n4 = piece.col() - coordinate7.col(); n2 != 0; n2 -= n4 > 0 ? 1 : -1) {
                    hashSet3.add(Coordinate.rowCol(piece.row(), coordinate7.col() + n2));
                }
                HashSet<Coordinate> hashSet4 = new HashSet<Coordinate>(8);
                for (int i = n = coordinate2.col() - coordinate6.col(); i != 0; i -= n > 0 ? 1 : -1) {
                    hashSet4.add(Coordinate.rowCol(coordinate2.row(), coordinate6.col() + i));
                }
                hashSet3.remove(coordinate2);
                hashSet3.remove(piece);
                hashSet4.remove(coordinate2);
                hashSet4.remove(piece);
                if (hashSet3.stream().noneMatch(coordinate -> map.containsKey(coordinate)) && hashSet4.stream().noneMatch(coordinate -> map.containsKey(coordinate)) && hashSet4.stream().noneMatch(coordinate -> attackedCoordinatePredicate.test((Coordinate)coordinate, piece2.color().other(), map))) {
                    hashSet.add(new Castling(new FromTo(coordinate2, coordinate6), new FromTo((Coordinate)((Object)piece), coordinate7)));
                }
            }
            return hashSet;
        }

        public record RookFiles(String K, String Q, String k, String q) {
        }

        public record Standard(RookFiles files) implements CastlingRights
        {
            @Override
            public String toString() {
                return this.asStandard();
            }
        }

        public record Chess960(RookFiles files) implements CastlingRights
        {
            @Override
            public String toString() {
                return this.as960();
            }
        }

        @FunctionalInterface
        public static interface AttackedCoordinatePredicate {
            public boolean test(Coordinate var1, Side var2, Map<Coordinate, Piece> var3);
        }
    }

    public record Castling(FromTo king, FromTo rook) implements Move
    {
        @Override
        public String toString() {
            return this.uci();
        }
    }

    public record Invalid(String info) implements Move
    {
    }

    public record Promotion(FromTo pawn, PieceType piece) implements Move
    {
        @Override
        public String toString() {
            return this.uci();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Move {
        public static Move parse(String string, String string2) {
            return Move.parse(string, FEN.parse(string2));
        }

        private static Move parse(String string, FEN fEN) {
            if (Objects.toString(string, "").isBlank()) {
                return new Invalid("move: " + string + " fen: " + String.valueOf(fEN));
            }
            Map<Coordinate, Piece> map = Board.pieceMap(fEN.positions());
            String string2 = Move.convertToUCI(string, fEN, map);
            if (string2.isEmpty()) {
                return new Invalid("move: " + string + " fen: " + String.valueOf(fEN));
            }
            return Move.parseUCI(string2, fEN, map);
        }

        private static String convertToUCI(String string2, FEN fEN, Map<Coordinate, Piece> map) {
            char[] cArray = string2.toCharArray();
            if (cArray.length >= 4 && cArray[0] >= 'a' && cArray[0] <= 'h' && cArray[1] >= '1' && cArray[1] <= '8' && cArray[2] >= 'a' && cArray[2] <= 'h' && cArray[3] >= '1' && cArray[3] <= '8') {
                return string2;
            }
            string2 = string2.replace("x", "").replace("#", "").replace("+", "");
            cArray = string2.toCharArray();
            switch (string2) {
                case "O-O": 
                case "0-0": {
                    return fEN.whoseTurn() == Side.WHITE ? "e1g1" : "e8g8";
                }
                case "O-O-O": 
                case "0-0-0": {
                    return fEN.whoseTurn() == Side.WHITE ? "e1c1" : "e8c8";
                }
            }
            return switch (cArray[0]) {
                case 'B', 'K', 'N', 'Q', 'R' -> {
                    char var4_5 = cArray[0];
                    Coordinate var5_8 = Coordinate.name(string2.substring(string2.length() - 2));
                    String var6_10 = string2.substring(1, string2.length() - 2);
                    if (var6_10.length() == 2) {
                        yield var6_10 + String.valueOf(var5_8);
                    }
                    if (var6_10.length() == 1) {
                        char var7_11 = var6_10.charAt(0);
                        if (var7_11 >= '0' && var7_11 <= '8') {
                            yield map.entrySet().stream().filter(entry -> Character.toUpperCase(((Piece)entry.getValue()).type().toChar()) == var4_5).filter(entry -> ((Piece)entry.getValue()).color() == fEN.whoseTurn()).filter(entry -> ((Coordinate)entry.getKey()).name().charAt(1) == var7_11).map(entry -> ((Coordinate)entry.getKey()).name()).filter(string -> Board.validMovesByPiece(Coordinate.name(string), map, fEN).contains(new FromTo(Coordinate.name(string), var5_8))).map(string -> string + var5_8.name()).findAny().orElse("");
                        }
                        yield map.entrySet().stream().filter(entry -> Character.toUpperCase(((Piece)entry.getValue()).type().toChar()) == var4_5).filter(entry -> ((Piece)entry.getValue()).color() == fEN.whoseTurn()).filter(entry -> ((Coordinate)entry.getKey()).name().charAt(0) == var7_11).map(entry -> ((Coordinate)entry.getKey()).name()).filter(string -> Board.validMovesByPiece(Coordinate.name(string), map, fEN).contains(new FromTo(Coordinate.name(string), var5_8))).map(string -> string + var5_8.name()).findAny().orElse("");
                    }
                    yield map.entrySet().stream().filter(entry -> Character.toUpperCase(((Piece)entry.getValue()).type().toChar()) == var4_5).filter(entry -> ((Piece)entry.getValue()).color() == fEN.whoseTurn()).map(entry -> ((Coordinate)entry.getKey()).name()).filter(string -> Board.validMovesByPiece(Coordinate.name(string), map, fEN).contains(new FromTo(Coordinate.name(string), var5_8))).map(string -> string + var5_8.name()).findAny().orElse("");
                }
                case 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h' -> {
                    char var4_6 = cArray[0];
                    Coordinate var5_9 = Coordinate.name(string2.substring(string2.length() - 2));
                    yield map.entrySet().stream().filter(entry -> ((Piece)entry.getValue()).type() == PieceType.PAWN).filter(entry -> ((Piece)entry.getValue()).color() == fEN.whoseTurn()).map(entry -> ((Coordinate)entry.getKey()).name()).filter(string -> string.charAt(0) == var4_6).filter(string -> Board.validMovesByPiece(Coordinate.name(string), map, fEN).contains(new FromTo(Coordinate.name(string), var5_9))).map(string -> string + var5_9.name()).findAny().orElse("");
                }
                default -> "";
            };
        }

        private static Move parseUCI(String string, FEN fEN, Map<Coordinate, Piece> map) {
            Coordinate coordinate = Coordinate.name(string.substring(0, 2));
            Coordinate coordinate2 = Coordinate.name(string.substring(2, 4));
            Piece piece = map.get(coordinate);
            if (piece == null || piece.color() != fEN.whoseTurn()) {
                return new Invalid("from: " + String.valueOf(coordinate) + " to: " + String.valueOf(coordinate2) + " piece: " + String.valueOf(piece) + " fen: " + String.valueOf(fEN));
            }
            FromTo fromTo = new FromTo(coordinate, coordinate2);
            Set<Move> set = Board.validMovesByPiece(coordinate, map, fEN);
            if (!set.contains(fromTo)) {
                return set.stream().filter(move -> {
                    Castling castling;
                    return move instanceof Castling && (castling = (Castling)move).king().equals(fromTo);
                }).findAny().orElseGet(() -> new Invalid("move: " + String.valueOf(fromTo) + " fen: " + String.valueOf(fEN)));
            }
            if (string.length() == 5) {
                PieceType pieceType = switch (string.charAt(4)) {
                    case 'q' -> PieceType.QUEEN;
                    case 'n' -> PieceType.KNIGHT;
                    case 'b' -> PieceType.BISHOP;
                    case 'r' -> PieceType.ROOK;
                    default -> PieceType.QUEEN;
                };
                return new Promotion(fromTo, pieceType);
            }
            return fromTo;
        }

        default public String uci() {
            Move move = this;
            if (move instanceof FromTo) {
                FromTo fromTo = (FromTo)move;
                return this.uci(fromTo.from(), fromTo.to());
            }
            move = this;
            if (move instanceof Castling) {
                Castling castling = (Castling)move;
                return this.uci(castling.king().from(), castling.king().to());
            }
            move = this;
            if (move instanceof Promotion) {
                Promotion promotion = (Promotion)move;
                return this.uci(promotion.pawn().from(), promotion.pawn().to()) + Character.toLowerCase(promotion.piece().toChar());
            }
            move = this;
            if (move instanceof Invalid) {
                Invalid invalid = (Invalid)move;
                return invalid.info();
            }
            return "gotta catch them all";
        }

        default public String uci(Coordinate coordinate, Coordinate coordinate2) {
            return coordinate.name() + coordinate2.name();
        }
    }

    public record StandardPiece(PieceType type, Side color) implements Piece
    {
    }

    public record RowCol(int row, int col) implements Coordinate
    {
        @Override
        public String toString() {
            return this.name();
        }
    }
}

