/*
 * Decompiled with CFR 0.152.
 */
package chariot.util;

import chariot.util.Board;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record ConsoleRenderer() {
    static String noframeTemplate = "%s %s %s %s %s %s %s %s\n%s %s %s %s %s %s %s %s\n%s %s %s %s %s %s %s %s\n%s %s %s %s %s %s %s %s\n%s %s %s %s %s %s %s %s\n%s %s %s %s %s %s %s %s\n%s %s %s %s %s %s %s %s\n%s %s %s %s %s %s %s %s";
    static String frameTemplate = "\u250c\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2510\n\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502\n\u251c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2524\n\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502\n\u251c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2524\n\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502\n\u251c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2524\n\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502\n\u251c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2524\n\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502\n\u251c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2524\n\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502\n\u251c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2524\n\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502\n\u251c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2524\n\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502 %s\u2502\n\u2514\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2518";

    public static String render(Board board) {
        return ConsoleRenderer.render(board, (Config config) -> {});
    }

    public static String render(Board board, Consumer<Config> consumer) {
        var var2_2 = new Config(){
            Data mutate = new Data(false, false, false, false);

            @Override
            public Config frame(boolean bl) {
                this.mutate = this.mutate.with((Data.Component)new Data.Frame(bl));
                return this;
            }

            @Override
            public Config letter(boolean bl) {
                this.mutate = this.mutate.with((Data.Component)new Data.Letter(bl));
                return this;
            }

            @Override
            public Config coordinates(boolean bl) {
                this.mutate = this.mutate.with((Data.Component)new Data.Coordinates(bl));
                return this;
            }

            @Override
            public Config flipped(boolean bl) {
                this.mutate = this.mutate.with((Data.Component)new Data.Flipped(bl));
                return this;
            }
        };
        consumer.accept(var2_2);
        Data data = var2_2.mutate;
        return ConsoleRenderer.render(board, data);
    }

    private static String render(Board board, Data data) {
        List<String> list;
        String string;
        Function<Board.Piece, String> function = piece -> (data.letter() ? piece.letter() : piece.unicode()) + (data.frame() ? " " : "");
        Supplier<String> supplier = () -> data.frame() ? "  " : " ";
        String string2 = string = data.frame() ? frameTemplate : noframeTemplate;
        if (data.coordinates()) {
            list = string.lines().toList();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Comparator comparator = data.flipped() ? Comparator.naturalOrder() : Comparator.reverseOrder();
            Comparator comparator2 = data.flipped() ? Comparator.reverseOrder() : Comparator.naturalOrder();
            Iterator iterator = Arrays.stream("12345678".split("")).sorted(comparator).iterator();
            List<String> list2 = Stream.concat(Stream.of(" "), Arrays.stream("abcdefgh".split("")).sorted(comparator2)).toList();
            for (int i = 0; i < list.size(); ++i) {
                boolean bl = !data.frame() || i % 2 != 0;
                String string3 = bl ? (String)iterator.next() : " ";
                arrayList.add(string3 + " " + list.get(i) + "\n");
            }
            arrayList.add(String.join((CharSequence)"%1$s", list2).formatted(data.frame() ? "   " : " "));
            string = arrayList.stream().collect(Collectors.joining());
        }
        list = new ArrayList<String>();
        if (!data.flipped()) {
            for (int i = 7; i >= 0; --i) {
                for (int j = 0; j <= 7; ++j) {
                    ((ArrayList)list).add(board.get(i, j) != null ? function.apply(board.get(i, j)) : supplier.get());
                }
            }
        } else {
            for (int i = 0; i <= 7; ++i) {
                for (int j = 7; j >= 0; --j) {
                    ((ArrayList)list).add(board.get(i, j) != null ? function.apply(board.get(i, j)) : supplier.get());
                }
            }
        }
        return string.formatted(((ArrayList)list).toArray());
    }

    record Data(boolean frame, boolean letter, boolean coordinates, boolean flipped) {
        Data with(Component component) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Record record;
            if (component instanceof Frame) {
                record = (Frame)component;
                bl4 = record.value;
            } else {
                bl4 = this.frame;
            }
            if (component instanceof Letter) {
                record = (Letter)component;
                bl3 = ((Letter)record).value;
            } else {
                bl3 = this.letter;
            }
            if (component instanceof Coordinates) {
                record = (Coordinates)component;
                bl2 = ((Coordinates)record).value;
            } else {
                bl2 = this.coordinates;
            }
            if (component instanceof Flipped) {
                record = (Flipped)component;
                bl = ((Flipped)record).value;
            } else {
                bl = this.flipped;
            }
            return new Data(bl4, bl3, bl2, bl);
        }

        Data with(Component ... componentArray) {
            Data data = this;
            for (Component component : componentArray) {
                data = data.with(component);
            }
            return data;
        }

        record Frame(boolean value) implements Component
        {
        }

        record Letter(boolean value) implements Component
        {
        }

        record Coordinates(boolean value) implements Component
        {
        }

        record Flipped(boolean value) implements Component
        {
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static interface Component {
        }
    }

    public static interface Config {
        public Config frame(boolean var1);

        public Config letter(boolean var1);

        public Config coordinates(boolean var1);

        public Config flipped(boolean var1);

        default public Config frame() {
            return this.frame(true);
        }

        default public Config letter() {
            return this.letter(true);
        }

        default public Config coordinates() {
            return this.coordinates(true);
        }

        default public Config flipped() {
            return this.flipped(true);
        }
    }
}

