package io.tpmn.suezx;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Canvas;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;


public class SuezXBannerAd extends RelativeLayout {

    private static final String TAG = SuezXBannerAd.class.getSimpleName();

    public static final String BASE_URL = "https://ad.tpmn.io";
//    public static final String BASE_URL = "https://adtest.tpmn.co.kr";

    private Map<String, Object> reqParams = null;

    private String publisherId = "";
    private String inventoryId = "";
    private String userAgent = "";
    private String userAgentEnc = "";
    private String userId = "";
    private String gdpr = "0";
    private String gdprConsent = "0";
    private String yob = "";
    private String gender = "";

    private int adHeight = 50;

    private int refreshInterval = 30;
    private boolean autoRefresh = true;
    private boolean isAttached = false;
    private boolean isVisible = false;
    private boolean usesCache = false;

    private SuezXBannerListener bannerListener;
    private SuezXBannerController bannerController;

    private WebView bannerWebView;
    private final Handler updateHandler = new Handler();
    private static Method mWebView_SetLayerType;
    private static Field mWebView_LAYER_TYPE_SOFTWARE;

    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int SOCKET_TIMEOUT = 10000;


    public SuezXBannerAd(Context context) {
        this(context, null, 0);
    }

    public SuezXBannerAd(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuezXBannerAd(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        if (attrs != null) {
            setParams(context, attrs);
        }

        userAgent = SuezXUtils.getUserAgent(getContext());
        userAgentEnc = SuezXUtils.getUserAgent(getContext(), true);
        isVisible = (getVisibility() == VISIBLE);
    }


    public interface SuezXBannerListener {
        void onBannerLoaded();
        void onBannerFailed(SuezXError suezXError);
        void onBannerClicked();
        void onBannerClosed();
    }


    public void setPublisherId(String publisherId) {
        this.publisherId = publisherId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setGdpr(String gdpr) {
        this.gdpr = gdpr;
    }

    public void setGdprConsent(String gdprConsent) {
        this.gdprConsent = gdprConsent;
    }

    public void setYob(String yob) {
        if (yob != null)
            this.yob = yob;
    }

    public void setGender(String gender) {
        if (gender != null)
            this.gender = gender;
    }

    public void setBannerListener(SuezXBannerListener bannerListener) {
        this.bannerListener = bannerListener;
    }

    public void setAdHeight(int adHeight) {
        this.adHeight = adHeight;

        synchronized(this) {
            try {
                if (bannerWebView != null) {
                    FrameLayout.LayoutParams webViewParams = new FrameLayout.LayoutParams(-1, (int) getDensityPixel(this.adHeight));
                    webViewParams.gravity = Gravity.CENTER;
                    bannerWebView.setLayoutParams(webViewParams);
                }
            } catch (Exception e) {
            }
        }
    }

    public void setUseCache(boolean usesCache) {
        this.usesCache = usesCache;
        if (bannerWebView != null) {
            if (usesCache) {
                bannerWebView.getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);
                bannerWebView.clearCache(true);
                bannerWebView.setDrawingCacheEnabled(true);
            } else {
                bannerWebView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
                bannerWebView.clearCache(true);
                bannerWebView.setDrawingCacheEnabled(false);
            }
        }
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval < 20 ? 20 : refreshInterval > 120 ? 120 : refreshInterval;
    }

    public void loadAd() {
        Log.d(TAG, "loadAd");

        if (!isAttached) {
            if (bannerController == null || bannerWebView == null)
                initialize();
        }

        new Thread(new Runnable() {
            @Override
            public void run() {
                final String reqUrl = createRequestUrl();
                Log.i(TAG, "reqUrl: " + reqUrl);

                if (SuezXUtils.NVL(publisherId) || SuezXUtils.NVL(inventoryId)) {
                    notifyAdFailed(SuezXError.INVALID_ID);
                    return;
                }

                final String response = getResponse(reqUrl);

                int responseSize = response.length();
                int maxLogSize = 4000;
                if (responseSize <= maxLogSize) {
                    Log.i(TAG, "response: " + response);
                }
                else {
                    Log.i(TAG, "response:");
                    for (int start = 0; start < responseSize; start += maxLogSize) {
                        int end = Math.min(start + maxLogSize, responseSize);
                        Log.i(TAG, response.substring(start, end));
                    }
                }

                renderAd(response);
            }
        }).start();
    }


    private synchronized void initialize() {
        Log.d(TAG, "initialize");

        setFocusable(true);
        setFocusableInTouchMode(true);
        setHorizontalScrollBarEnabled(false);
        setVerticalScrollBarEnabled(false);

        if (!checkPermission()) {
            notifyAdFailed(SuezXError.PERMISSION_DENIED);
            AlertDialog.Builder localBuilder = new AlertDialog.Builder(getContext());
            localBuilder.setIcon(17301543)
                    .setTitle("Tpmn Android SDK")
                    .setMessage("Ensure that you add the INTERNET, ACCESS_NETWORK_STATE and ACCESS_WIFI_STATE permissions in your AndroidManifest.xml")
                    .setCancelable(false).show();
            return;
        }

        if (bannerWebView == null) {
            bannerWebView = createWebView(this);
            FrameLayout.LayoutParams webViewParams = new FrameLayout.LayoutParams(-1, (int) getDensityPixel(adHeight));
            webViewParams.gravity = Gravity.CENTER;
            this.addView(bannerWebView, webViewParams);
        }

        if (bannerController == null) {
            bannerController = new SuezXBannerController(this);
            bannerController.viewAd(true);
        }
    }

    private WebView createWebView(final SuezXBannerAd suezXBannerAd) {
        Log.d(TAG, "createWebView");

        final WebView webView = new WebView(getContext()) {
            @Override
            public void draw(final Canvas canvas) {
                if (getWidth() > 0 && getHeight() > 0)
                    super.draw(canvas);
            }
        };

        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        if (0 != (getContext().getApplicationInfo().flags &= ApplicationInfo.FLAG_DEBUGGABLE)) {
            WebView.setWebContentsDebuggingEnabled(true);
        }
        webSettings.setUserAgentString(userAgentEnc);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setSupportZoom(false);
        webSettings.setAllowFileAccess(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        // webSettings.setPluginState(WebSettings.PluginState.ON);

        if (usesCache) {
            webView.getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);
            webView.clearCache(true);
            webView.setDrawingCacheEnabled(true);
        }
        else {
            webView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
            webView.clearCache(true);
            webView.setDrawingCacheEnabled(false);
        }

        webView.addJavascriptInterface(new SuezXBannerWebInterface(suezXBannerAd), SuezXUtils.WEBVIEW_NAME);
        //setLayer(webView);

        webView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(final WebView view, final String url) {
                Log.d(TAG, "WebViewClient - shouldOverrideUrlLoading (API < 24)");

                if (url.startsWith("http") || url.startsWith("market")) {
                    Log.d(TAG, "if");
                    doOpenUrl(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            @TargetApi(Build.VERSION_CODES.N)
            @Override
            public boolean shouldOverrideUrlLoading(final WebView view, WebResourceRequest request) {
                Log.d(TAG, "WebViewClient - shouldOverrideUrlLoading (API >= 24)");

                String url = request.getUrl().toString();
                if (url.startsWith("http") || url.startsWith("market")) {
                    Log.d(TAG, "if");
                    doOpenUrl(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, request);
            }

            @Override
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                notifyAdFailed(SuezXError.NETWORK_ERROR); // TODO
            }
        });

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
                WebView newWebView = new WebView(view.getContext());
                newWebView.setWebViewClient(new WebViewClient() {
                    @Override
                    public boolean shouldOverrideUrlLoading(WebView view, String url) {
                        Log.d(TAG, "WebChromeClient - shouldOverrideUrlLoading (API < 24)");
                        if (url.startsWith("http") || url.startsWith("market")) {
                            Log.d(TAG, "if");
                            doOpenUrl(url);
                            return true;
                        }
                        return super.shouldOverrideUrlLoading(view, url);
                    }

                    @TargetApi(Build.VERSION_CODES.N)
                    @Override
                    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                        Log.d(TAG, "WebChromeClient - shouldOverrideUrlLoading (API >= 24)");

                        String url = request.getUrl().toString();
                        if (url.startsWith("http") || url.startsWith("market")) {
                            Log.d(TAG, "if");
                            doOpenUrl(url);
                            return true;
                        }
                        return super.shouldOverrideUrlLoading(view, request);
                    }
                });
                newWebView.setWebChromeClient(new WebChromeClient() {
                    @Override
                    public void onConsoleMessage(String message, int lineNumber, String sourceID) {
                        //Log.e("MyApplication", message + " -- From line "
                        //        + lineNumber + " of "
                        //        + sourceID);
                    }
                });
                WebView.WebViewTransport transport = (WebView.WebViewTransport) resultMsg.obj;
                transport.setWebView(newWebView);
                resultMsg.sendToTarget();
                return true;
            }

            @Override
            public void onConsoleMessage(String message, int lineNumber, String sourceID) {
                //Log.e("MyApplication", message + " -- From line "
                //        + lineNumber + " of "
                //        + sourceID);
            }
        });

        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        webView.setBackgroundColor(Color.TRANSPARENT);

        return webView;
    }

    // TODO
    // https://stackoverflow.com/questions/11753000/how-to-open-the-google-play-store-directly-from-my-android-application/45727784
    // https://developer.android.com/distribute/marketing-tools/linking-to-google-play?hl=ko
    private void doOpenUrl(@NonNull final String url) {
        Log.d(TAG, "doOpenUrl with " + url);

        notifyAdClicked();

        try {
            final Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.addCategory(Intent.CATEGORY_BROWSABLE);

            PackageManager pkgMgr = getContext().getPackageManager();
            List<ResolveInfo> activities = pkgMgr.queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY);
//            List<ResolveInfo> activities = pkgMgr.queryIntentActivities(intent, 0);
            String pkgName = "";
            Log.d(TAG, "size: " + activities.size());
            if (activities.size() > 0) {
                pkgName = activities.get(0).activityInfo.applicationInfo.packageName;
                for(ResolveInfo a : activities) {
                    Log.d(TAG, "doOpenUrl - " + a.activityInfo.applicationInfo.packageName);
                }
            }
            Log.d(TAG, "pkgName: " + pkgName);

            if (!pkgName.equals("")) intent.setPackage(pkgName);
            getContext().startActivity(intent);
        } catch (Exception e) {
        }
    }

    @NonNull
    private String createRequestUrl() {
        Log.d(TAG, "createRequestUrl");

        if (reqParams == null)
            reqParams = SuezXUtils.getRequestParams(getContext());

        String reqUrl = BASE_URL + "/appbanner.tpmn";
        reqUrl += "?pi=" + publisherId;
        reqUrl += "&ii=" + inventoryId;
        reqUrl += "&ua=" + userAgentEnc;
        reqUrl += "&cn=" + reqParams.get("cn");
        reqUrl += "&os=" + "android";
        reqUrl += "&osv=" + Build.VERSION.RELEASE;
        try {
            reqUrl += "&dn=" + URLEncoder.encode(Build.MODEL,"UTF-8");
        } catch(UnsupportedEncodingException e) {
            Log.e(TAG, e.toString());
        }
        reqUrl += "&udid=" + reqParams.get("udid");
        reqUrl += "&dnt=" + reqParams.get("dnt");
        reqUrl += "&v=" + BuildConfig.appversion;
        reqUrl += "&ct=" + reqParams.get("ct");
        reqUrl += "&bundle=" + reqParams.get("bundle");
        reqUrl += "&av=" + reqParams.get("av");
        reqUrl += "&mcc=" + reqParams.get("mcc");
        reqUrl += "&mnc=" + reqParams.get("mnc");
        reqUrl += "&locale=" + reqParams.get("locale");
        reqUrl += "&gdpr=" + gdpr;
        reqUrl += "&gdpr_consent=" + gdprConsent;
        reqUrl += "&mraid=" + 0; // TODO
        reqUrl += "&yob=" + yob;
        reqUrl += "&gender=" + gender;
        reqUrl += "&keywords=" + ""; // TODO

        // deprecated?
//                url += "&close_yn=" + (useClose?"Y":"N");
//                url +="&uid="+ SuezXUtils.nvl(userId,"");

        return reqUrl;
    }

    @NonNull
    private String getResponse(@NonNull final String url) {
        @NonNull String response = "";

        HttpsURLConnection conn = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, null, new SecureRandom());

            conn = (HttpsURLConnection) new URL(url).openConnection();
            conn.setSSLSocketFactory(sc.getSocketFactory());
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(SuezXBannerAd.CONNECTION_TIMEOUT);
            conn.setReadTimeout(SuezXBannerAd.SOCKET_TIMEOUT);
            conn.setRequestProperty("User-Agent", userAgent);
            conn.connect();

            int responseCode = conn.getResponseCode();
            Log.i(TAG, "responseCode: " + responseCode);

            switch (responseCode) {
                // 200
                case HttpsURLConnection.HTTP_OK:
                    String str;
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((str = br.readLine()) != null) {
                        sb.append(str);
                    }
                    br.close();
                    response = sb.toString();
                    break;
                // 204: No ad or invalid publisher/inventory ID
                case HttpURLConnection.HTTP_NO_CONTENT:
                    notifyAdFailed(SuezXError.NO_FILL);
                    break;
                // 404
                case HttpURLConnection.HTTP_NOT_FOUND:
                    notifyAdFailed(SuezXError.SERVER_ERROR);
                    break;
                // 500
                case HttpURLConnection.HTTP_INTERNAL_ERROR:
                    notifyAdFailed(SuezXError.SERVER_ERROR);
                    break;
                default:
                    notifyAdFailed(SuezXError.SERVER_ERROR); // TODO
            }
        } catch (final Exception e) {
            notifyAdFailed(SuezXError.UNSPECIFIED); // TODO
        } finally {
            if (conn != null) conn.disconnect();
        }

        return response;
    }

    private void renderAd(@NonNull final String response) {
        Log.d(TAG, "renderAd");

        // responseCode is not 200
        if (response.equals("")) {
            return;
        }
        // responseCode is 200 but response is neither JSON nor HTML
        else if (!response.startsWith("{") && !response.startsWith("<")) {
            notifyAdFailed(SuezXError.SERVER_ERROR);
            return;
        }
        updateHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    // JSON
                    if (response.startsWith("{")) {
                        bannerWebView.loadDataWithBaseURL(BASE_URL, SuezXUtils.parseJson(response).getHtml(), "text/html", "utf-8", null);
                    }
                    // HTML
                    else {
                        bannerWebView.loadDataWithBaseURL(BASE_URL, response, "text/html", "utf-8", null);
                    }
                    notifyAdLoaded(); // TODO: Here or in case 200 like interstitial?
                } catch (Exception e) {
                    notifyAdFailed(SuezXError.INTERNAL_ERROR);
                }
            }
        });
    }







    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        isAttached = true;
        if (bannerController == null || bannerWebView == null)
            initialize();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        isAttached = false;
        if (bannerController != null)
            bannerController.viewAd(false);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == View.VISIBLE) {
            if (bannerController != null)
                bannerController.viewAd(true);
        }
    }


    private int getDensityPixel(int paramInt) {
        return (int) (paramInt * getResources().getDisplayMetrics().density);
    }










    private static void setLayer(WebView webView){
        if (mWebView_SetLayerType != null && mWebView_LAYER_TYPE_SOFTWARE !=null) {
            try {
                mWebView_SetLayerType.invoke(webView, mWebView_LAYER_TYPE_SOFTWARE.getInt(WebView.class), null);
            } catch (InvocationTargetException ite) {
            } catch (IllegalArgumentException e) {
            } catch (IllegalAccessException e) {
            }
        }
        else{
        }
    }


    private void notifyAdLoaded() {
        if (bannerListener != null) {
            bannerListener.onBannerLoaded();
        }
    }

    private void notifyAdFailed(SuezXError suezXError) {
        if (bannerListener != null) {
            bannerListener.onBannerFailed(suezXError);
        }
    }

    private void notifyAdClicked() {
        if (bannerListener != null) {
            bannerListener.onBannerClicked();
        }
    }

    private void notifyAdClosed() {
        if (bannerListener != null) {
            bannerListener.onBannerClosed();
        }
    }











    private boolean checkPermission() {
        boolean b = true;
        if (!SuezXUtils.checkSelfPermission("android.permission.INTERNET", getContext())) {
            b = false;
        }

        if (!SuezXUtils.checkSelfPermission("android.permission.ACCESS_NETWORK_STATE", getContext())) {
            b = false;
        }

        if (!SuezXUtils.checkSelfPermission("android.permission.ACCESS_WIFI_STATE", getContext())) {
            b = false;
        }
        return b;
    }



    public boolean isAutoRefresh() {
        return autoRefresh;
    }



    public void pause() {
        if (bannerController != null) {
            bannerController.viewAd(false);
        }
    }

    public void resume() {
        if (bannerController != null) {
            bannerController.viewAd(true);
        }
    }


    public void destroy() {
        try {
            if (bannerController != null) {
                bannerController.closeAd();
                bannerController = null;
            }
        } catch (Exception localException) { }
    }

    public void viewClose() {
        if ((bannerController == null)) {
            return;
        }
        try {
            if (bannerController != null) {
                bannerController.closeAd();
                bannerController = null;
            }
            setVisibility(View.GONE);
            notifyAdClosed();
            removeAllViews();
            bannerWebView.destroy();
            destroy();
        } catch (Exception localException) {
            localException.printStackTrace();
        }
    }


    public void close() {
        try {
            destroy();
            setVisibility(View.GONE);
            notifyAdClosed();
            removeAllViews();
            bannerWebView.destroy();
        } catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        isVisible = (visibility == 0);
        if (bannerController != null)
            bannerController.viewAd(isVisible);
    }

    public boolean isInForeground()
    {
        return isVisible;
    }



    public int getRefreshInterval() {
        return refreshInterval;
    }



    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPackagename(){
        String pName = "";
        List<PackageInfo> packs = getContext().getPackageManager().getInstalledPackages(0);
        for(int i = 0; i < packs.size(); i++){
            pName = packs.get(i).packageName;
            if(pName.contains("browser") || pName.equals("com.android.chrome")){
                return pName;
            }
        }
        return "";
    }





    private void setParams(Context context, AttributeSet attrs) {
        if ((context == null) || (attrs == null)) {
            return;
        }

        setRefreshInterval(attrs.getAttributeIntValue(null, "refreshInterval", 60));

        String inventoryId = attrs.getAttributeValue(null, "inventoryId");
        String publisherId = attrs.getAttributeValue(null, "publisherId");
        String userId = attrs.getAttributeValue(null, "userId");
        setAdHeight(attrs.getAttributeIntValue(null,"adHeight",50));
        //setAdHeight(Integer.valueOf(attrs.getAttributeValue(null,"adHeight")));
        //String height = attrs.getAttributeValue(null,"adHeight");

        if ((inventoryId != null) && (!inventoryId.trim().equals("")))
            setInventoryId(inventoryId);
        if ((publisherId != null) && (!publisherId.trim().equals("")))
            setPublisherId(publisherId);
        if ((userId != null) && (!userId.trim().equals("")))
            setUserId(userId);
        /*if ((height != null) && (!height.trim().equals("")))
            setAdHeight(Integer.valueOf(height));*/

        setUseCache(attrs.getAttributeBooleanValue(null, "useCache", true));
    }
}