package io.tpmn.suezx;

import java.lang.ref.WeakReference;

public class SuezXBannerController {

    private static final String TAG = SuezXBannerController.class.getSimpleName();
    private final RunAd runAd;
    private final Thread runAdThread;
    private SuezXBannerAd k;
    private boolean l;


    public SuezXBannerController(SuezXBannerAd paramAdView)
    {
        this.k = paramAdView;
        this.runAd = new RunAd(this.k);
        this.runAdThread= new Thread(this.runAd, "TpmnAdViewUpdater");
    }


    public void closeAd()
    {
        if ((this.runAdThread != null) && (this.runAdThread.isAlive())) {
            this.runAdThread.interrupt();
        }
        viewAd(false);
        this.k = null;
    }


    public void viewAd(boolean paramBoolean)
    {
        this.l = paramBoolean;

        if (this.l)
        {
            if (this.k == null) {
                return;
            }

            if (!this.k.isInForeground()) {
                return;
            }

            if (this.runAdThread != null)
            {
                if (this.runAd.bHold)
                {
                    this.runAd.push();
                }else{
                    try{
                        if (!this.runAdThread.isAlive())
                            this.runAdThread.start();
                    }catch(Exception e){
                    }
                }
            }

        }else{
            if (this.runAd != null)
            {
                this.runAd.hold();
            }
        }
    }

    private final class RunAd implements Runnable {
        private final Object b = new Object();
        private final WeakReference<SuezXBannerAd> weakReferenceAdview;
        private boolean bHold = false;

        public RunAd(SuezXBannerAd arg2)
        {
            this.weakReferenceAdview = new WeakReference(arg2);
        }

        public void run() {
            SuezXBannerAd localAdView = (SuezXBannerAd)this.weakReferenceAdview.get();
            if(localAdView.isAutoRefresh()){
                while (true) {
                    try {
//		        	BannerAdView localAdView = (BannerAdView)this.weakReferenceAdview.get();
                        if ((localAdView != null) && (localAdView.isInForeground())) {
                            if (!bHold && localAdView.isShown()) {
                                localAdView.loadAd();
                            }
                            Thread.sleep(localAdView.getRefreshInterval() * 1000);
                        } else {
                            this.bHold = true;
                        }
                    } catch (Exception localException) {
                        break;
                    }

                    synchronized (this.b) {
                        while (this.bHold) {
                            try {
                                this.b.wait();
                            } catch (InterruptedException localInterruptedException) {
                                return;
                            }
                        }
                    }

                    if (Thread.interrupted()) break;

                }
            }
            else {
                /* 광고 Refresh 하지 않음 */
                try{
                    if ((localAdView != null) && (localAdView.isInForeground())){
                        if (!bHold && localAdView.isShown())
                        {
                            localAdView.loadAd();
                        }
                    } else {
                        this.bHold = true;
                    }

                } catch (Exception e){

                }
            }

        }

        public void hold()
        {
            synchronized (this.b) {
                this.bHold = true;
            }
        }

        public void push() {
            synchronized (this.b) {
                this.bHold = false;
                this.b.notifyAll();
            }
        }
    }
}
