package io.tpmn.suezx;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Canvas;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

import static io.tpmn.suezx.SuezXInterstitialAd.response;

public class SuezXInterstitialActivity extends Activity {

    private static final String TAG = SuezXInterstitialActivity.class.getSimpleName();

    private static final String BASE_URL = "https://ad.tpmn.io";
    //    private static final String BASE_URL = "https://adtest.tpmn.co.kr";

    private boolean bDebug = false;
    //private boolean bAnimation = false;

    private WebView interstitialWebView;
    private RelativeLayout mLayout;
    private static Method mWebView_SetLayerType;
    private static Field mWebView_LAYER_TYPE_SOFTWARE;


    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        mLayout = new RelativeLayout(this);
        mLayout.setBackgroundColor(0xff000000);

        setContentView(mLayout, new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        interstitialWebView = createWebView(this);
        interstitialWebView.setVisibility(View.INVISIBLE);

        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
        layoutParams.addRule(RelativeLayout.CENTER_IN_PARENT);

        mLayout.addView(interstitialWebView, layoutParams);

        renderAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        try {
            if (interstitialWebView != null) {
                ViewGroup parent = (ViewGroup) interstitialWebView.getParent();
                if (parent != null) {
                    parent.removeView(interstitialWebView);
                }
                interstitialWebView.removeAllViews();
                interstitialWebView.destroy();
            }
            SuezXInterstitialAd.state = SuezXInterstitialAd.SuezXInterstitialState.IDLE;
        } catch(Exception e) {}
        finish(); // onCreate() -> onDestroy()
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();

        endAnimation();
    }

    @Override
    public void finish() {
        super.finish();

        overridePendingTransition(0,0);
    }



    private WebView createWebView(final Context context) {
        final WebView webView = new WebView(context) {
            @Override
            public void draw(final Canvas canvas) {
                if (this.getWidth() > 0 && this.getHeight() > 0)
                    super.draw(canvas);
            }
        };

        WebSettings webSettings = webView.getSettings();

        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        if (0 != (getApplicationInfo().flags &= ApplicationInfo.FLAG_DEBUGGABLE)) {
            WebView.setWebContentsDebuggingEnabled(true);
        }

        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setSupportZoom(false);
        webSettings.setAllowFileAccess(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        //webSettings.setPluginState(WebSettings.PluginState.ON);
        if (SuezXInterstitialAd.usesCache) {
            webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
            webView.setDrawingCacheEnabled(true);
            webSettings.setAppCacheEnabled(true);
        }
        else{
            webSettings.setCacheMode(WebSettings.LOAD_NO_CACHE);
            webView.clearCache(true);
            webView.setDrawingCacheEnabled(false);
            webSettings.setAppCacheEnabled(false);
        }

        webView.addJavascriptInterface(new SuezXInterstitialWebInterface(this), SuezXUtils.WEBVIEW_NAME);
        webView.setBackgroundColor(Color.BLACK);
        //setLayer(webView);

        webView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(final WebView view, final String url) {
                Log.d(TAG, "WebViewClient - shouldOverrideUrlLoading (API < 24)");

                if (url.startsWith("http") || url.startsWith("market")) {
                    Log.d(TAG, "if");
                    doOpenUrl(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            @TargetApi(Build.VERSION_CODES.N)
            @Override
            public boolean shouldOverrideUrlLoading(final WebView view, WebResourceRequest request) {
                Log.d(TAG, "WebViewClient - shouldOverrideUrlLoading (API >= 24)");

                String url = request.getUrl().toString();
                if (url.startsWith("http") || url.startsWith("market")) {
                    Log.d(TAG, "if");
                    doOpenUrl(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, request);
            }

            @Override
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                // TODO Auto-generated method stub
                super.onReceivedError(view, errorCode, description, failingUrl);
                if (SuezXInterstitialAd.interstitialListener != null) {
                    SuezXInterstitialAd.interstitialListener.onInterstitialFailed(SuezXError.NETWORK_ERROR); // TODO
                }
                SuezXInterstitialActivity.this.onDestroy();
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                // TODO Auto-generated method stub
                super.onPageFinished(view, url);
                view.setVisibility(View.VISIBLE);
//				startAnimation();
            }
        });

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
                WebView newWebView = new WebView(view.getContext());
                newWebView.setWebViewClient(new WebViewClient() {
                    @Override
                    public boolean shouldOverrideUrlLoading(final WebView view, final String url) {
                        Log.d(TAG, "WebChromeClient - shouldOverrideUrlLoading (API < 24)");

                        if (url.startsWith("http") || url.startsWith("market")) {
                            Log.d(TAG, "if");
                            doOpenUrl(url);
                            return true;
                        }
                        return super.shouldOverrideUrlLoading(view, url);
                    }

                    @TargetApi(Build.VERSION_CODES.N)
                    @Override
                    public boolean shouldOverrideUrlLoading(final WebView view, WebResourceRequest request) {
                        Log.d(TAG, "WebChromeClient - shouldOverrideUrlLoading (API >= 24)");

                        String url = request.getUrl().toString();
                        if (url.startsWith("http") || url.startsWith("market")) {
                            Log.d(TAG, "if");
                            doOpenUrl(url);
                            return true;
                        }
                        return super.shouldOverrideUrlLoading(view, request);
                    }
                });

                newWebView.setWebChromeClient(new WebChromeClient(){
                    @Override
                    public void onConsoleMessage(String message, int lineNumber, String sourceID) {

                        //Log.e("MyApplication", message + " -- From line "
                        //        + lineNumber + " of "
                        //        + sourceID);

                    }
                });
                WebView.WebViewTransport transport = (WebView.WebViewTransport) resultMsg.obj;
                transport.setWebView(newWebView);
                resultMsg.sendToTarget();
                return true;
            }

            @Override
            public void onConsoleMessage(String message, int lineNumber, String sourceID) {

                //Log.e("MyApplication", message + " -- From line "
                //        + lineNumber + " of "
                //        + sourceID);

            }
        });

        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        return webView;
    }

    private void doOpenUrl(final String url) {
        if (SuezXInterstitialAd.interstitialListener != null) {
            SuezXInterstitialAd.interstitialListener.onInterstitialClicked();
        }
        try {
            final Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            String pName = "";
            pName = getBrowser(url);
            if(!pName.equals("")) intent.setPackage(pName);
            this.startActivity(intent);
        } catch(Exception e) {
        }
//		InterstitialAdActivity.this.onDestroy();
    }

    private void renderAd() {
        Log.d(TAG, "renderAd");

        // responseCode is not 200
        if (response.equals("")) {
            return;
        }
        // responseCode is 200 but response is neither JSON nor HTML
        else if (!response.startsWith("{") && !response.startsWith("<")) {
            SuezXInterstitialAd.notifyAdFailed(SuezXError.SERVER_ERROR);
            return;
        }

        try {
            // JSON
            if (response.startsWith("{")) {
                interstitialWebView.loadDataWithBaseURL(BASE_URL, SuezXUtils.parseJson(response).getHtml(), "text/html", "utf-8", null);
            }
            // HTML
            else {
                interstitialWebView.loadDataWithBaseURL(BASE_URL, response, "text/html", "utf-8", null);
            }
        } catch (Exception e) {
            SuezXInterstitialAd.notifyAdFailed(SuezXError.INTERNAL_ERROR);
        }
    }

//	private void endActivity() {
//		this.finish();
//	}



    private static void setLayer(WebView webView){
        if (mWebView_SetLayerType != null && mWebView_LAYER_TYPE_SOFTWARE !=null) {
            try {
                mWebView_SetLayerType.invoke(webView, mWebView_LAYER_TYPE_SOFTWARE.getInt(WebView.class), null);
            } catch (Exception e){
            }
        }
        else {
        }
    }

    private int getDensityPixel(int paramInt) {
        DisplayMetrics localDisplayMetrics = this.getResources().getDisplayMetrics();
        return (int)(paramInt * localDisplayMetrics.density);
    }




    protected void endAnimation() {
//		if (bAnimation)
//			return;
        if (SuezXInterstitialAd.interstitialListener != null) {
            SuezXInterstitialAd.notifyAdDismissed();
        }
//    	if (InterstitialAd.endAnimationDuration <= 0)
//    	{
        SuezXInterstitialActivity.this.onDestroy();
//    	}
/*		int iCase = new Random().nextInt(5);
		AnimationSet animation = new AnimationSet(false);
		switch(iCase)
		{
		case 0: animation.addAnimation(new AlphaAnimation(1.0F, 0.0F));
				animation.addAnimation(new ScaleAnimation(1.2F, 0.0F, 1.2F, 0.0F, 1, 0.5F, 1, 0.5F));
			break;
		case 1:
			animation.addAnimation(new TranslateAnimation(2, 0.0F, 2, 0.0F, 2, 0.0F, 2, 1.0F));
			break;
		case 2:
			animation.addAnimation(new TranslateAnimation(2, 0.0F, 2, 0.0F, 2, 0.0F, 2, -1.0F));
			break;
		case 3:  animation.addAnimation(new TranslateAnimation(2, 0.0F, 2, -1.0F, 2, 0.0F, 2, 0.0F));
			break;
		case 4: animation.addAnimation(new RotateAnimation(720.0F,0.0F, 1, 0.5F, 1, 0.5F));
				animation.addAnimation(new ScaleAnimation(1.0F, 0.0F, 1.0F, 0.0F, 1, 0.5F, 1, 0.5F));
			break;
		default:  animation.addAnimation(new AlphaAnimation(1.0F, 0.0F));
				  animation.addAnimation(new ScaleAnimation(1.2F, 0.0F, 1.2F, 0.0F, 1, 0.5F, 1, 0.5F));
				break;
		}
		animation.setDuration(InterstitialAd.endAnimationDuration);
		animation.setAnimationListener(new AnimationListener() {

			@Override
			public void onAnimationStart(Animation animation) {
				// TODO Auto-generated method stub
				bAnimation = true;
			}

			@Override
			public void onAnimationRepeat(Animation animation) {
				// TODO Auto-generated method stub
			}

			@Override
			public void onAnimationEnd(Animation animation) {
				// TODO Auto-generated method stub
				bAnimation = false;
				InterstitialAdActivity.this.onDestroy();
			}
		});
		mWebView.startAnimation(animation);
		*/
    }

    /*	private void startAnimation(){
            if (bAnimation)
                return;
            if (InterstitialAd.startAnimationDuration <= 0)
                return;
            int iCase = new Random().nextInt(5);
            AnimationSet animation = new AnimationSet(false);
            switch(iCase)
            {
            case 0: animation.addAnimation(new AlphaAnimation(0.0F, 1.0F));
                    animation.addAnimation(new ScaleAnimation(0.0F, 1.0F, 0.0F, 1.0F, 1, 0.5F, 1, 0.5F));
                break;
            case 1: animation.addAnimation(new TranslateAnimation(2, 0.0F, 2, 0.0F, 2, 1.0F, 2, 0.0F));
                break;
            case 2:  animation.addAnimation(new TranslateAnimation(2, 0.0F, 2, 0.0F, 2, -1.0F, 2, 0.0F));
                break;
            case 3:  animation.addAnimation(new TranslateAnimation(2, -1.0F, 2, 0.0F, 2, 0.0F, 2, 0.0F));
                break;
            case 4: animation.addAnimation(new RotateAnimation(0.0F, 720.0F, 1, 0.5F, 1, 0.5F));
                    animation.addAnimation(new ScaleAnimation(0.0F, 1.0F, 0.0F, 1.0F, 1, 0.5F, 1, 0.5F));
                break;
            default :
                    animation.addAnimation(new AlphaAnimation(0.0F, 1.0F));
                    animation.addAnimation(new ScaleAnimation(0.0F, 1.0F, 0.0F, 1.0F, 1, 0.5F, 1, 0.5F));
                break;
            }
            animation.setDuration(InterstitialAd.startAnimationDuration);
            animation.setAnimationListener(new AnimationListener() {

                @Override
                public void onAnimationStart(Animation animation) {
                    // TODO Auto-generated method stub
                    bAnimation = true;
                }

                @Override
                public void onAnimationRepeat(Animation animation) {
                    // TODO Auto-generated method stub
                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    // TODO Auto-generated method stub
                    bAnimation = false;
                    //finish();
                }
            });
            mWebView.startAnimation(animation);
        }
    */


    public String getBrowser(String url) {
        PackageManager packageManager = getPackageManager();
        Intent browsableIntent = new Intent();
        browsableIntent.setAction("android.intent.action.VIEW");
        browsableIntent.addCategory("android.intent.category.BROWSABLE");
        browsableIntent.setData(Uri.parse(url));

        List<ResolveInfo> list = packageManager.queryIntentActivities(browsableIntent, 0);
        if (list.size() > 0) {
            for (ResolveInfo resolveInfo : list) {
                String pkgName = resolveInfo.activityInfo.applicationInfo.packageName;
                return pkgName;
            }
        }
        return "";
    }
}