package io.tpmn.suezx;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.util.Log;

import androidx.annotation.NonNull;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public final class SuezXInterstitialAd {

    private static final String TAG = SuezXInterstitialAd.class.getSimpleName();

    private static final String BASE_URL = "https://ad.tpmn.io";
//    private static final String BASE_URL = "https://adtest.tpmn.co.kr";

    private Map<String, Object> reqParams = null;

    private String publisherId = "";
    private String inventoryId = "";
    private String userAgent = "";
    private String userAgentEnc = "";
    private String gdpr = "0";
    private String gdprConsent = "0";
    private String yob = "";
    private String gender = "";

    @NonNull public static String response = "";

    public static boolean usesCache = true;
    public static long lastTimes = 0L;
    //check showing statement
    public static boolean isShown = false;
    //	public static int startAnimationDuration = 500;
//	public static int endAnimationDuration = 500;

    protected static SuezXInterstitialListener interstitialListener;
    public static SuezXInterstitialState state;

    private Activity activity;
    private static final Handler updateHandler = new Handler();

    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int SOCKET_TIMEOUT = 10000;

    public SuezXInterstitialAd(Activity activity) {
        this.activity = activity;
        state = SuezXInterstitialState.IDLE;
        usesCache = true;
        userAgent = SuezXUtils.getUserAgent(activity);
        userAgentEnc = SuezXUtils.getUserAgent(activity, true);
    }


    public interface SuezXInterstitialListener {
        void onInterstitialLoaded();
        void onInterstitialFailed(SuezXError suezXError);
        void onInterstitialShown();
        void onInterstitialClicked();
        void onInterstitialDismissed();
    }

    protected enum SuezXInterstitialState {
        IDLE, LOADING, LOADED, SHOWN
    }


    public void setPublisherId(String publisherId) {
        this.publisherId = publisherId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setGdpr(String gdpr) {
        this.gdpr = gdpr;
    }

    public void setGdprConsent(String gdprConsent) {
        this.gdprConsent = gdprConsent;
    }

    public void setYob(String yob) {
        if (yob != null)
            this.yob = yob;
    }

    public void setGender(String gender) {
        if (gender != null)
            this.gender = gender;
    }

    public void setUseCache(boolean usesCache) {
        SuezXInterstitialAd.usesCache = usesCache;
    }

    public void setInterstitialListener(SuezXInterstitialListener interstitialListener) {
        SuezXInterstitialAd.interstitialListener = interstitialListener;
    }

    public synchronized void loadAd() {
        Log.d(TAG, "loadAd");

        if (!isIdle()) return;

        state = SuezXInterstitialState.LOADING;

        new Thread(new Runnable() {
            @Override
            public void run() {
                final String reqUrl = createRequestUrl();
                Log.i(TAG, "reqUrl: " + reqUrl);

                if (SuezXUtils.NVL(publisherId) || SuezXUtils.NVL(inventoryId)) {
                    notifyAdFailed(SuezXError.INVALID_ID);
                    return;
                }

                response = getResponse(reqUrl);

                int responseSize = response.length();
                int maxLogSize = 4000;
                if (responseSize <= maxLogSize) {
                    Log.i(TAG, "response: " + response);
                }
                else {
                    Log.i(TAG, "response:");
                    for (int start = 0; start < responseSize; start += maxLogSize) {
                        int end = Math.min(start + maxLogSize, responseSize);
                        Log.i(TAG, response.substring(start, end));
                    }
                }
            }
        }).start();
    }

    @NonNull
    private String createRequestUrl() {
        Log.d(TAG, "createRequestUrl");

        if (reqParams == null)
            reqParams = SuezXUtils.getRequestParams(activity);

        String reqUrl = BASE_URL + "/appbanner.tpmn";
        reqUrl += "?pi=" + publisherId;
        reqUrl += "&ii=" + inventoryId;
        reqUrl += "&ua=" + userAgentEnc;
        reqUrl += "&cn=" + reqParams.get("cn");
        reqUrl += "&os=" + "android";
        reqUrl += "&osv=" + Build.VERSION.RELEASE;
        try {
            reqUrl += "&dn=" + URLEncoder.encode(Build.MODEL,"UTF-8");
        } catch(UnsupportedEncodingException e) {
            Log.e(TAG, e.toString());
        }
        reqUrl += "&udid=" + reqParams.get("udid");
        reqUrl += "&dnt=" + reqParams.get("dnt");
        reqUrl += "&v=" + BuildConfig.appversion;
        reqUrl += "&ct=" + reqParams.get("ct");
        reqUrl += "&bundle=" + reqParams.get("bundle");
        reqUrl += "&av=" + reqParams.get("av");
        reqUrl += "&mcc=" + reqParams.get("mcc");
        reqUrl += "&mnc=" + reqParams.get("mnc");
        reqUrl += "&locale=" + reqParams.get("locale");
        reqUrl += "&gdpr=" + gdpr;
        reqUrl += "&gdpr_consent=" + gdprConsent;
        reqUrl += "&mraid=" + 0; // TODO
        reqUrl += "&yob=" + yob;
        reqUrl += "&gender=" + gender;
        reqUrl += "&keywords=" + ""; // TODO

        return reqUrl;
    }

    @NonNull
    private String getResponse(@NonNull final String url) {
        @NonNull String response = "";

        HttpsURLConnection conn = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, null, new SecureRandom());

            conn = (HttpsURLConnection) new URL(url).openConnection();
            conn.setSSLSocketFactory(sc.getSocketFactory());
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(SuezXInterstitialAd.CONNECTION_TIMEOUT);
            conn.setReadTimeout(SuezXInterstitialAd.SOCKET_TIMEOUT);
            conn.setRequestProperty("User-Agent", userAgent);
            conn.connect();

            int responseCode = conn.getResponseCode();
            Log.i(TAG, "responseCode: " + responseCode);

            switch (responseCode) {
                // 200
                case HttpsURLConnection.HTTP_OK:
                    String str;
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((str = br.readLine()) != null) {
                        sb.append(str);
                    }
                    br.close();
                    response = sb.toString();
                    notifyAdLoaded();
                    break;
                // 204: No ad or invalid publisher/inventory ID
                case HttpURLConnection.HTTP_NO_CONTENT:
                    notifyAdFailed(SuezXError.NO_FILL);
                    break;
                // 404
                case HttpURLConnection.HTTP_NOT_FOUND:
                    notifyAdFailed(SuezXError.SERVER_ERROR);
                    break;
                // 500
                case HttpURLConnection.HTTP_INTERNAL_ERROR:
                    notifyAdFailed(SuezXError.SERVER_ERROR);
                    break;
                default:
                    notifyAdFailed(SuezXError.SERVER_ERROR); // TODO
            }
        } catch (Exception e) {
            notifyAdFailed(SuezXError.SERVER_ERROR); // TODO
        } finally {
            if (conn != null) conn.disconnect();
        }

        return response;
    }

    public synchronized void showAd() {
        Log.d(TAG, "showAd");

        if (!isLoaded()) {
            Log.d(TAG, "showAd - !isLoaded");

            notifyAdFailed(SuezXError.INTERSTITIAL_LOAD_ERROR);
            return;
        }

        updateHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    Log.d(TAG, "showAd - isLoaded - try start");

                    final Intent intent = new Intent(activity, SuezXInterstitialActivity.class);
                    intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT | Intent.FLAG_ACTIVITY_NEW_TASK);
                    //intent.setFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
                    activity.startActivity(intent);

                    notifyAdShown(); // TODO: Here or in SuezXInterstitialActivity.renderAd() like banner?

                    Log.d(TAG, "showAd - isLoaded try end");
                } catch (Exception e) {
                    Log.d(TAG, "showAd - isLoaded - catch " + e.toString());

                    notifyAdFailed(SuezXError.INTERSTITIAL_SHOW_ERROR);
                }
            }
        });
    }


    protected static void notifyAdLoaded() {
        state = SuezXInterstitialState.LOADED;
//        updateHandler.post(new Runnable() {
//            @Override
//            public void run() {
        if (interstitialListener != null) {
            interstitialListener.onInterstitialLoaded();
        }
//            }
//        });
    }

    protected static void notifyAdFailed(final SuezXError suezXError) {
        state = SuezXInterstitialState.IDLE;
//        updateHandler.post(new Runnable() {
//            @Override
//            public void run() {
        if (interstitialListener != null) {
            interstitialListener.onInterstitialFailed(suezXError);
        }
//            }
//        });
    }

    protected static void notifyAdShown() {
        state = SuezXInterstitialState.SHOWN;
//        updateHandler.post(new Runnable() {
//            @Override
//            public void run() {
        if (interstitialListener != null) {
            interstitialListener.onInterstitialShown();
        }
//            }
//        });
    }

    protected void notifyAdClicked() {
//        updateHandler.post(new Runnable() {
//            @Override
//            public void run() {
        if (interstitialListener != null) {
            interstitialListener.onInterstitialClicked();
        }
//            }
//        });
    }

    protected static void notifyAdDismissed() {
        state = SuezXInterstitialState.IDLE;
//        updateHandler.post(new Runnable() {
//            @Override
//            public void run() {
        if (interstitialListener != null) {
            interstitialListener.onInterstitialDismissed();
        }
//            }
//        });
    }


    private boolean isIdle() {
        return state == SuezXInterstitialState.IDLE;
    }

    private boolean isLoaded() {
        return state == SuezXInterstitialState.LOADED;
    }


//	public static int getStartAnimationDuration() {
//		return startAnimationDuration;
//	}
//
//	public static void setStartAnimationDuration(int startAnimationDuration) {
//		InterstitialAd.startAnimationDuration = startAnimationDuration;
//	}
//
//	public static int getEndAnimationDuration() {
//		return endAnimationDuration;
//	}
//
//	public static void setEndAnimationDuration(int endAnimationDuration) {
//		InterstitialAd.endAnimationDuration = endAnimationDuration;
//	}
}