package io.tpmn.suezx;

import android.util.Log;

public class SuezXLogger {
    public static final String TAG = "SuezX";
    private static LogTypes logTypes = LogTypes.Default;
    private static boolean logSwitch = false;

    public static enum LogTypes {
        None, Default, Detail;
        private LogTypes() {}
    }

    public static enum LogLevels {
        Verbose, Debug, Info, Warn, Error;
        private LogLevels() {}
    }

    public static void createLog(LogLevels logLevels, String tag, String msg, String sys_msg) {
        if(!isLogSwitch()) {
            return;
        }

        String finalMsg = "";
        if (msg == "" && sys_msg != "") finalMsg = sys_msg;
        if (sys_msg == "" && msg != "") finalMsg = msg;
        if (msg != "" && sys_msg != "") finalMsg = msg + " | " + sys_msg;

        switch(getLogTypes()) {
            case None:
                break;
            case Default:
                switch(logLevels) {
                    case Verbose:
                        Log.v(TAG,tag+": "+msg);
                        break;
                    case Debug:
                        Log.d(TAG,tag+": "+msg);
                        break;
                    case Info:
                        Log.i(TAG,tag+": "+msg);
                        break;
                    case Warn:
                        Log.w(TAG,tag+": "+msg);
                        break;
                    case Error:
                        Log.e(TAG,tag+": "+msg);
                        break;
                }
                break;
            case Detail:
                switch (logLevels) {
                    case Verbose:
                        Log.v(TAG,tag+": " + finalMsg);
                        break;
                    case Debug:
                        Log.d(TAG,tag+": " + finalMsg);
                        break;
                    case Info:
                        Log.i(TAG,tag+": " + finalMsg);
                        break;
                    case Warn:
                        Log.w(TAG,tag+": " + finalMsg);
                        break;
                    case Error:
                        Log.e(TAG,tag+": " + finalMsg);
                        break;
                }
                break;
        }
    }

    public static boolean isLogSwitch() {
        return logSwitch;
    }

    public static void setLogSwitch(boolean logSwitch) {
        SuezXLogger.logSwitch = logSwitch;
    }

    public static LogTypes getLogTypes() {
        return logTypes;
    }

    public static void setLogTypes(LogTypes logTypes) {
        SuezXLogger.logTypes = logTypes;
    }
}
