package io.tpmn.suezx;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.webkit.WebView;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class SuezXUtils {

    protected static final String WEBVIEW_NAME = "tpmn_android";

    public static String getUserAgent(Context context) {
        return getUserAgent(context, false);
    }

    public static String getUserAgent(Context context, boolean encoded) {
        String userAgent = new WebView(context).getSettings().getUserAgentString();

        if (!encoded)
            return userAgent;

        String userAgentEnc = "";
        try {
            userAgentEnc = URLEncoder.encode(userAgent, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            Log.e("UserAgent Error", e.toString());
        }
        return userAgentEnc;
    }

    public static Map<String, Object> getRequestParams(Context context) {
        Map<String, Object> params = new HashMap<>();
        TelephonyManager teleMgr = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);

        String operatorName = teleMgr.getNetworkOperatorName();
        String operatorNameEnc = "";
        try {
            operatorNameEnc = URLEncoder.encode(operatorName, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            Log.e("Operator Network Error", e.toString());
        }
        params.put("cn", operatorNameEnc);

        String operator = teleMgr.getNetworkOperator();
        String mcc = "", mnc = "";
        if (operator != null && !operator.isEmpty()) {
            try {
                mcc = operator.substring(0, 3);
                mnc = operator.substring(3, 5);
            } catch (NumberFormatException e) {
                Log.e("TelephonyManager Error", e.toString());
            }
        }
        params.put("mcc", mcc);
        params.put("mnc", mnc);

        String adId = "";
        int doNotTrack = 0;
        try {
            AdvertisingIdClient.Info adIdInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
            adId = adIdInfo.getId();
            if (adIdInfo.isLimitAdTrackingEnabled()) doNotTrack = 1;
        } catch (Exception e) {
            Log.e("AdId Error", e.toString());
        }
        params.put("udid", adId);
        params.put("dnt", doNotTrack);

        int connectType = 0;
        ConnectivityManager connMgr = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo(); // deprecated in API 29
        if (networkInfo != null && networkInfo.isConnected()) { // deprecated in API 29 -> ConnectivityManager.NetworkCallback
            switch (networkInfo.getType()) { // deprecated in API 28 -> NetworkCapabilities.hasTransport()
                case ConnectivityManager.TYPE_ETHERNET: // deprecated in API 28 -> NetworkCapabilities.hasTransport()
                    connectType = 1;
                    break;
                case ConnectivityManager.TYPE_WIFI: // deprecated in API 28 -> NetworkCapabilities.hasTransport()
                    connectType = 2;
                    break;
                case ConnectivityManager.TYPE_MOBILE: // deprecated in API 28 -> NetworkCapabilities.hasTransport()
                    switch(networkInfo.getSubtype()) { // deprecated in API 29 -> TelephonyManager.getDataNetworkType()
                        case TelephonyManager.NETWORK_TYPE_IDEN:
                            connectType = 4;
                            break;
                        case TelephonyManager.NETWORK_TYPE_HSPAP:
                            connectType = 5;
                            break;
                        case TelephonyManager.NETWORK_TYPE_LTE:
                            connectType = 6;
                            break;
                        case TelephonyManager.NETWORK_TYPE_NR:
                            connectType = 7;
                            break;
                        default:
                            connectType = 3;
                            break;
                    }
            }
        }
        params.put("ct", connectType);

/*        // TODO: 여기부터...
        // API >= 21
        NetworkRequest networkRequest = new NetworkRequest.Builder()
                .addTransportType(NetworkCapabilities.TRANSPORT_ETHERNET)
                .addTransportType(NetworkCapabilities.TRANSPORT_WIFI)
                .addTransportType(NetworkCapabilities.TRANSPORT_CELLULAR)
                .build();
        // API >= 21
        ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback() {
            @Override
            public void onAvailable(@NonNull Network network) {
                super.onAvailable(network);
            }
            @Override
            public void onLost(@NonNull Network network) {
                super.onLost(network);
            }
        };
        connMgr.registerDefaultNetworkCallback(networkCallback);
        connMgr.registerNetworkCallback(networkRequest, networkCallback);
        connMgr.unregisterNetworkCallback(networkCallback);
        // TODO: 여기까지. 연결여부 말고 연결상태 확인할 때 필요한가?
        Network network = connMgr.getActiveNetwork(); // API >= 23
        NetworkCapabilities caps = connMgr.getNetworkCapabilities(network); // API >= 21
        if (caps != null) {
            if (caps.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET)) { // API >= 21
                Log.d("SuezXUtils", "ETHERNET");
                connectType = 1;
            } else if (caps.hasTransport(NetworkCapabilities.TRANSPORT_WIFI)) {
                Log.d("SuezXUtils", "WIFI");
                connectType = 2;
            } else if (caps.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR)) {
                Log.d("SuezXUtils", "CELLULAR");
                connectType = 3;
            } else {
                Log.d("SuezXUtils", "ELSE");
            }
        }
        switch (teleMgr.getDataNetworkType()) { // API >= 24
            case TelephonyManager.NETWORK_TYPE_IDEN:
                Log.d("SuezXUtils", "IDEN");
                connectType = 4;
                break;
            case TelephonyManager.NETWORK_TYPE_HSPAP:
                Log.d("SuezXUtils", "HSPAP");
                connectType = 5;
                break;
            case TelephonyManager.NETWORK_TYPE_LTE:
                Log.d("SuezXUtils", "LTE");
                connectType = 6;
                break;
            case TelephonyManager.NETWORK_TYPE_NR:
                Log.d("SuezXUtils", "NR");
                connectType = 7;
                break;
            default:
                Log.d("SuezXUtils", "DEFAULT");
        }
        params.put("ct", connectType);*/

        String appPackageName = "", appVersionName = "";
        try {
            appPackageName = context.getPackageName();
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(appPackageName, 0);
            appVersionName = pInfo.versionName; // TODO: Deprecated
//            int appVersionCode = (int) PackageInfoCompat.getLongVersionCode(pInfo);
//            int appVersionCode = pInfo.appVersionCode;
        } catch (Exception e){
            Log.e("Package Error", e.toString());
        }
        params.put("bundle", appPackageName);
        params.put("av", appVersionName);

        String language = context.getResources().getConfiguration().locale.getLanguage();
        params.put("locale", language);

        return params;
    }



    public static String getConnectType(Context paramContext) {
        ConnectivityManager connMgr = (ConnectivityManager) paramContext.getSystemService(Context.CONNECTIVITY_SERVICE);

        String result = "3G";
        try{
            ConnectivityManager cManager =(ConnectivityManager)paramContext.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo activeNetwork = cManager.getActiveNetworkInfo();

            if (null != activeNetwork){
                if (activeNetwork.getType() == ConnectivityManager.TYPE_WIFI)
                    return "WIFI";
                else if (activeNetwork.getType() == ConnectivityManager.TYPE_MOBILE)
                {
                    int networkType = activeNetwork.getSubtype();
                    switch(networkType)
                    {
                        case TelephonyManager.NETWORK_TYPE_GPRS:
                        case TelephonyManager.NETWORK_TYPE_EDGE:
                        case TelephonyManager.NETWORK_TYPE_CDMA:
                        case TelephonyManager.NETWORK_TYPE_1xRTT:
                        case 11: //api<8 : replace by 11
                            return "2G";
                        case TelephonyManager.NETWORK_TYPE_UMTS:
                        case TelephonyManager.NETWORK_TYPE_EVDO_0:
                        case TelephonyManager.NETWORK_TYPE_EVDO_A:
                        case TelephonyManager.NETWORK_TYPE_HSDPA:
                        case TelephonyManager.NETWORK_TYPE_HSUPA:
                        case TelephonyManager.NETWORK_TYPE_HSPA:
                        case 14: //api<9 : replace by 14
                        case 12:  //api<11 : replace by 12
                        case 15:  //api<13 : replace by 15
                            return "3G";
                        case 13:    //api<11 : replace by 13
                            return "LTE";
                        default:
                            return result;
                    }
                }else
                {
                    return result;
                }
            }else{
                return result;
            }
        }catch(Exception e){return result;}
    }



    public static boolean checkSelfPermission(String paramString, Context context) {
        boolean b = false;
        try {
            b = context.checkCallingOrSelfPermission(paramString) == PackageManager.PERMISSION_GRANTED;
        } catch (RuntimeException localRuntimeException) {
        }
        return b;
    }

//	  public static Map<String, Object> getParams(Context paramContext)
//	  {
//	    HashMap localHashMap = new HashMap();
//	    try {
//	      Method localMethod1 = Reflection.a("com.google.android.gms.common.GooglePlayServicesUtil", "isGooglePlayServicesAvailable", new Class[] { Context.class });
//
//	      if (localMethod1 == null) {
//	        throw new NullPointerException("GooglePlayServicesNotAvailable");
//	      }
//
//	      Object localObject1 = Reflection.getObject(null, localMethod1, new Object[] { paramContext });
//	      if ((!(localObject1 instanceof Integer)))
//	      {
//	        throw new NullPointerException("connectionResult != CONNECTION_RESULT_SUCCESS ");
//	      }else if ((((Integer)localObject1).intValue() != 0))
//	      {
//	    	  throw new NullPointerException("connectionResult != CONNECTION_RESULT_SUCCESS "+((Integer)localObject1).intValue());
//	      }
//
//	      Method localMethod2 = Reflection.a("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", new Class[] { Context.class });
//
//	      if (localMethod2 == null) {
//	        throw new NullPointerException("getAdvertisingIdInfo == null");
//	      }
//
//	      Object localObject2 = Reflection.getObject(null, localMethod2, new Object[] { paramContext });
//	      if (localObject2 == null) {
//	        throw new NullPointerException("advertisingInfo == null");
//	      }
//
//	      Method localMethod3 = Reflection.a(localObject2.getClass(), "getId", new Class[0]);
//	      Method localMethod4 = Reflection.a(localObject2.getClass(), "isLimitAdTrackingEnabled", new Class[0]);
//	      if ((localMethod3 == null) || (localMethod4 == null)) {
//	        throw new NullPointerException("getId == null || isLimitAdTrackingEnabled == null");
//	      }
//
//	      localHashMap.put("androidId", (String)Reflection.getObject(localObject2, localMethod3, new Object[0]));
//	      localHashMap.put("limitTracking", (Boolean)Reflection.getObject(localObject2, localMethod4, new Object[0]));
//	    }
//	    catch (Exception localException) {
//	      localHashMap.put("androidId","");
//	      localHashMap.put("limitTracking", Boolean.valueOf(false));
//	    }
//
//	    return (Map<String, Object>)localHashMap;
//	  }




    public static boolean NVL(String param) {
        if (param == null || "".equals(param))
            return true;
        else
            return false;
    }

    /**
     *
     * @param value
     * @return
     */
    public static String nvl(String value) {
        return nvl(value, "");
    }

    /**
     *
     * @param value
     * @param defaultValue
     * @return
     */
    public static String nvl(String value, String defaultValue) {
        if (value == null || value.equals(""))
            return defaultValue;
        else
            return value;
    }

    public static boolean isWifiConnect(Context paramContext){
        try{
            ConnectivityManager cManager =(ConnectivityManager)paramContext.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo activeNetwork = cManager.getActiveNetworkInfo();

            if (null != activeNetwork){
                if (activeNetwork.getType() == ConnectivityManager.TYPE_WIFI)
                    return true;
                else
                    return false;
            }else{
                return false;
            }
        }catch(Exception e){return false;}

    }



    protected static SuezXCreative parseJson (String str) {
        SuezXCreative creative = new SuezXCreative();
        try {
            JSONObject jObj = new JSONObject(str);
            int adHeight = jObj.getInt("adHeight");
            int adWidth = jObj.getInt("adWidth");
            String html = jObj.getString("html");

            creative.setAdHeight(adHeight);
            creative.setAdWidth(adWidth);
            creative.setHtml(html);

        } catch (JSONException e) {
            SuezXLogger.createLog(SuezXLogger.LogLevels.Debug,"suezXJsonParser","Parsing error",e.toString());
        }
        return creative;
    }
}