/*
 * Decompiled with CFR 0.152.
 */
package io.tpmn.suezx;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import io.tpmn.suezx.SuezXBannerController;
import io.tpmn.suezx.SuezXBannerWebInterface;
import io.tpmn.suezx.SuezXError;
import io.tpmn.suezx.SuezXUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class SuezXBannerAd
extends RelativeLayout {
    private static final String TAG = SuezXBannerAd.class.getSimpleName();
    public static final String BASE_URL = "https://ad.tpmn.io";
    private Map<String, Object> reqParams = null;
    private String publisherId = "";
    private String inventoryId = "";
    private String userAgent = "";
    private String userAgentEnc = "";
    private String userId = "";
    private String gdpr = "0";
    private String gdprConsent = "0";
    private String yob = "";
    private String gender = "";
    private int adHeight = 50;
    private int refreshInterval = 30;
    private boolean autoRefresh = true;
    private boolean isAttached = false;
    private boolean isVisible = false;
    private boolean usesCache = false;
    private SuezXBannerListener bannerListener;
    private SuezXBannerController bannerController;
    private WebView bannerWebView;
    private final Handler updateHandler = new Handler();
    private static Method mWebView_SetLayerType;
    private static Field mWebView_LAYER_TYPE_SOFTWARE;
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int SOCKET_TIMEOUT = 10000;

    public SuezXBannerAd(Context context) {
        this(context, null, 0);
    }

    public SuezXBannerAd(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuezXBannerAd(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            this.setParams(context, attrs);
        }
        this.userAgent = SuezXUtils.getUserAgent(this.getContext());
        this.userAgentEnc = SuezXUtils.getUserAgent(this.getContext(), true);
        this.isVisible = this.getVisibility() == 0;
    }

    public void setPublisherId(String publisherId) {
        this.publisherId = publisherId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setGdpr(String gdpr) {
        this.gdpr = gdpr;
    }

    public void setGdprConsent(String gdprConsent) {
        this.gdprConsent = gdprConsent;
    }

    public void setYob(String yob) {
        if (yob != null) {
            this.yob = yob;
        }
    }

    public void setGender(String gender) {
        if (gender != null) {
            this.gender = gender;
        }
    }

    public void setBannerListener(SuezXBannerListener bannerListener) {
        this.bannerListener = bannerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdHeight(int adHeight) {
        this.adHeight = adHeight;
        SuezXBannerAd suezXBannerAd = this;
        synchronized (suezXBannerAd) {
            try {
                if (this.bannerWebView != null) {
                    FrameLayout.LayoutParams webViewParams = new FrameLayout.LayoutParams(-1, this.getDensityPixel(this.adHeight));
                    webViewParams.gravity = 17;
                    this.bannerWebView.setLayoutParams((ViewGroup.LayoutParams)webViewParams);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setUseCache(boolean usesCache) {
        this.usesCache = usesCache;
        if (this.bannerWebView != null) {
            if (usesCache) {
                this.bannerWebView.getSettings().setCacheMode(-1);
                this.bannerWebView.clearCache(true);
                this.bannerWebView.setDrawingCacheEnabled(true);
            } else {
                this.bannerWebView.getSettings().setCacheMode(2);
                this.bannerWebView.clearCache(true);
                this.bannerWebView.setDrawingCacheEnabled(false);
            }
        }
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval < 20 ? 20 : (refreshInterval > 120 ? 120 : refreshInterval);
    }

    public void loadAd() {
        Log.d((String)TAG, (String)"loadAd");
        if (!(this.isAttached || this.bannerController != null && this.bannerWebView != null)) {
            this.initialize();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                int maxLogSize;
                String reqUrl = SuezXBannerAd.this.createRequestUrl();
                Log.i((String)TAG, (String)("reqUrl: " + reqUrl));
                if (SuezXUtils.NVL(SuezXBannerAd.this.publisherId) || SuezXUtils.NVL(SuezXBannerAd.this.inventoryId)) {
                    SuezXBannerAd.this.notifyAdFailed(SuezXError.INVALID_ID);
                    return;
                }
                String response = SuezXBannerAd.this.getResponse(reqUrl);
                int responseSize = response.length();
                if (responseSize <= (maxLogSize = 4000)) {
                    Log.i((String)TAG, (String)("response: " + response));
                } else {
                    Log.i((String)TAG, (String)"response:");
                    for (int start = 0; start < responseSize; start += maxLogSize) {
                        int end = Math.min(start + maxLogSize, responseSize);
                        Log.i((String)TAG, (String)response.substring(start, end));
                    }
                }
                SuezXBannerAd.this.renderAd(response);
            }
        }).start();
    }

    private synchronized void initialize() {
        Log.d((String)TAG, (String)"initialize");
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        if (!this.checkPermission()) {
            this.notifyAdFailed(SuezXError.PERMISSION_DENIED);
            AlertDialog.Builder localBuilder = new AlertDialog.Builder(this.getContext());
            localBuilder.setIcon(17301543).setTitle((CharSequence)"Tpmn Android SDK").setMessage((CharSequence)"Ensure that you add the INTERNET, ACCESS_NETWORK_STATE and ACCESS_WIFI_STATE permissions in your AndroidManifest.xml").setCancelable(false).show();
            return;
        }
        if (this.bannerWebView == null) {
            this.bannerWebView = this.createWebView(this);
            FrameLayout.LayoutParams webViewParams = new FrameLayout.LayoutParams(-1, this.getDensityPixel(this.adHeight));
            webViewParams.gravity = 17;
            this.addView((View)this.bannerWebView, (ViewGroup.LayoutParams)webViewParams);
        }
        if (this.bannerController == null) {
            this.bannerController = new SuezXBannerController(this);
            this.bannerController.viewAd(true);
        }
    }

    private WebView createWebView(SuezXBannerAd suezXBannerAd) {
        Log.d((String)TAG, (String)"createWebView");
        WebView webView = new WebView(this.getContext()){

            public void draw(Canvas canvas) {
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    super.draw(canvas);
                }
            }
        };
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        if (0 != (this.getContext().getApplicationInfo().flags &= 2)) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        webSettings.setUserAgentString(this.userAgentEnc);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setSupportZoom(false);
        webSettings.setAllowFileAccess(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (this.usesCache) {
            webView.getSettings().setCacheMode(-1);
            webView.clearCache(true);
            webView.setDrawingCacheEnabled(true);
        } else {
            webView.getSettings().setCacheMode(2);
            webView.clearCache(true);
            webView.setDrawingCacheEnabled(false);
        }
        webView.addJavascriptInterface((Object)new SuezXBannerWebInterface(suezXBannerAd), "tpmn_android");
        webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.d((String)TAG, (String)"WebViewClient - shouldOverrideUrlLoading (API < 24)");
                if (url.startsWith("http") || url.startsWith("market")) {
                    Log.d((String)TAG, (String)"if");
                    SuezXBannerAd.this.doOpenUrl(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            @TargetApi(value=24)
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                Log.d((String)TAG, (String)"WebViewClient - shouldOverrideUrlLoading (API >= 24)");
                String url = request.getUrl().toString();
                if (url.startsWith("http") || url.startsWith("market")) {
                    Log.d((String)TAG, (String)"if");
                    SuezXBannerAd.this.doOpenUrl(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, request);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                SuezXBannerAd.this.notifyAdFailed(SuezXError.NETWORK_ERROR);
            }
        });
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
                WebView newWebView = new WebView(view.getContext());
                newWebView.setWebViewClient(new WebViewClient(){

                    public boolean shouldOverrideUrlLoading(WebView view, String url) {
                        Log.d((String)TAG, (String)"WebChromeClient - shouldOverrideUrlLoading (API < 24)");
                        if (url.startsWith("http") || url.startsWith("market")) {
                            Log.d((String)TAG, (String)"if");
                            SuezXBannerAd.this.doOpenUrl(url);
                            return true;
                        }
                        return super.shouldOverrideUrlLoading(view, url);
                    }

                    @TargetApi(value=24)
                    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                        Log.d((String)TAG, (String)"WebChromeClient - shouldOverrideUrlLoading (API >= 24)");
                        String url = request.getUrl().toString();
                        if (url.startsWith("http") || url.startsWith("market")) {
                            Log.d((String)TAG, (String)"if");
                            SuezXBannerAd.this.doOpenUrl(url);
                            return true;
                        }
                        return super.shouldOverrideUrlLoading(view, request);
                    }
                });
                newWebView.setWebChromeClient(new WebChromeClient(){

                    public void onConsoleMessage(String message, int lineNumber, String sourceID) {
                    }
                });
                WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
                transport.setWebView(newWebView);
                resultMsg.sendToTarget();
                return true;
            }

            public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            }
        });
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        webView.setBackgroundColor(0);
        return webView;
    }

    private void doOpenUrl(@NonNull String url) {
        Log.d((String)TAG, (String)("doOpenUrl with " + url));
        this.notifyAdClicked();
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            intent.addCategory("android.intent.category.BROWSABLE");
            PackageManager pkgMgr = this.getContext().getPackageManager();
            List activities = pkgMgr.queryIntentActivities(intent, 65536);
            String pkgName = "";
            Log.d((String)TAG, (String)("size: " + activities.size()));
            if (activities.size() > 0) {
                pkgName = ((ResolveInfo)activities.get((int)0)).activityInfo.applicationInfo.packageName;
                for (ResolveInfo a : activities) {
                    Log.d((String)TAG, (String)("doOpenUrl - " + a.activityInfo.applicationInfo.packageName));
                }
            }
            Log.d((String)TAG, (String)("pkgName: " + pkgName));
            if (!pkgName.equals("")) {
                intent.setPackage(pkgName);
            }
            this.getContext().startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    private String createRequestUrl() {
        Log.d((String)TAG, (String)"createRequestUrl");
        if (this.reqParams == null) {
            this.reqParams = SuezXUtils.getRequestParams(this.getContext());
        }
        String reqUrl = "https://ad.tpmn.io/appbanner.tpmn";
        reqUrl = reqUrl + "?pi=" + this.publisherId;
        reqUrl = reqUrl + "&ii=" + this.inventoryId;
        reqUrl = reqUrl + "&ua=" + this.userAgentEnc;
        reqUrl = reqUrl + "&cn=" + this.reqParams.get("cn");
        reqUrl = reqUrl + "&os=android";
        reqUrl = reqUrl + "&osv=" + Build.VERSION.RELEASE;
        try {
            reqUrl = reqUrl + "&dn=" + URLEncoder.encode(Build.MODEL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        reqUrl = reqUrl + "&udid=" + this.reqParams.get("udid");
        reqUrl = reqUrl + "&dnt=" + this.reqParams.get("dnt");
        reqUrl = reqUrl + "&v=2.1.1";
        reqUrl = reqUrl + "&ct=" + this.reqParams.get("ct");
        reqUrl = reqUrl + "&bundle=" + this.reqParams.get("bundle");
        reqUrl = reqUrl + "&av=" + this.reqParams.get("av");
        reqUrl = reqUrl + "&mcc=" + this.reqParams.get("mcc");
        reqUrl = reqUrl + "&mnc=" + this.reqParams.get("mnc");
        reqUrl = reqUrl + "&locale=" + this.reqParams.get("locale");
        reqUrl = reqUrl + "&gdpr=" + this.gdpr;
        reqUrl = reqUrl + "&gdpr_consent=" + this.gdprConsent;
        reqUrl = reqUrl + "&mraid=0";
        reqUrl = reqUrl + "&yob=" + this.yob;
        reqUrl = reqUrl + "&gender=" + this.gender;
        reqUrl = reqUrl + "&keywords=";
        return reqUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    private String getResponse(@NonNull String url) {
        String response = "";
        HttpURLConnection conn = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, null, new SecureRandom());
            conn = (HttpsURLConnection)new URL(url).openConnection();
            ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", this.userAgent);
            conn.connect();
            int responseCode = conn.getResponseCode();
            Log.i((String)TAG, (String)("responseCode: " + responseCode));
            switch (responseCode) {
                case 200: {
                    String str;
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((str = br.readLine()) != null) {
                        sb.append(str);
                    }
                    br.close();
                    response = sb.toString();
                    return response;
                }
                case 204: {
                    this.notifyAdFailed(SuezXError.NO_FILL);
                    return response;
                }
                case 404: {
                    this.notifyAdFailed(SuezXError.SERVER_ERROR);
                    return response;
                }
                case 500: {
                    this.notifyAdFailed(SuezXError.SERVER_ERROR);
                    return response;
                }
                default: {
                    this.notifyAdFailed(SuezXError.SERVER_ERROR);
                    return response;
                }
            }
        }
        catch (Exception e) {
            this.notifyAdFailed(SuezXError.UNSPECIFIED);
            return response;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void renderAd(final @NonNull String response) {
        Log.d((String)TAG, (String)"renderAd");
        if (response.equals("")) {
            return;
        }
        if (!response.startsWith("{") && !response.startsWith("<")) {
            this.notifyAdFailed(SuezXError.SERVER_ERROR);
            return;
        }
        this.updateHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (response.startsWith("{")) {
                        SuezXBannerAd.this.bannerWebView.loadDataWithBaseURL(SuezXBannerAd.BASE_URL, SuezXUtils.parseJson(response).getHtml(), "text/html", "utf-8", null);
                    } else {
                        SuezXBannerAd.this.bannerWebView.loadDataWithBaseURL(SuezXBannerAd.BASE_URL, response, "text/html", "utf-8", null);
                    }
                    SuezXBannerAd.this.notifyAdLoaded();
                }
                catch (Exception e) {
                    SuezXBannerAd.this.notifyAdFailed(SuezXError.INTERNAL_ERROR);
                }
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttached = true;
        if (this.bannerController == null || this.bannerWebView == null) {
            this.initialize();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isAttached = false;
        if (this.bannerController != null) {
            this.bannerController.viewAd(false);
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0 && this.bannerController != null) {
            this.bannerController.viewAd(true);
        }
    }

    private int getDensityPixel(int paramInt) {
        return (int)((float)paramInt * this.getResources().getDisplayMetrics().density);
    }

    private static void setLayer(WebView webView) {
        if (mWebView_SetLayerType != null && mWebView_LAYER_TYPE_SOFTWARE != null) {
            try {
                mWebView_SetLayerType.invoke((Object)webView, mWebView_LAYER_TYPE_SOFTWARE.getInt(WebView.class), null);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void notifyAdLoaded() {
        if (this.bannerListener != null) {
            this.bannerListener.onBannerLoaded();
        }
    }

    private void notifyAdFailed(SuezXError suezXError) {
        if (this.bannerListener != null) {
            this.bannerListener.onBannerFailed(suezXError);
        }
    }

    private void notifyAdClicked() {
        if (this.bannerListener != null) {
            this.bannerListener.onBannerClicked();
        }
    }

    private void notifyAdClosed() {
        if (this.bannerListener != null) {
            this.bannerListener.onBannerClosed();
        }
    }

    private boolean checkPermission() {
        boolean b = true;
        if (!SuezXUtils.checkSelfPermission("android.permission.INTERNET", this.getContext())) {
            b = false;
        }
        if (!SuezXUtils.checkSelfPermission("android.permission.ACCESS_NETWORK_STATE", this.getContext())) {
            b = false;
        }
        if (!SuezXUtils.checkSelfPermission("android.permission.ACCESS_WIFI_STATE", this.getContext())) {
            b = false;
        }
        return b;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void pause() {
        if (this.bannerController != null) {
            this.bannerController.viewAd(false);
        }
    }

    public void resume() {
        if (this.bannerController != null) {
            this.bannerController.viewAd(true);
        }
    }

    public void destroy() {
        try {
            if (this.bannerController != null) {
                this.bannerController.closeAd();
                this.bannerController = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void viewClose() {
        if (this.bannerController == null) {
            return;
        }
        try {
            if (this.bannerController != null) {
                this.bannerController.closeAd();
                this.bannerController = null;
            }
            this.setVisibility(8);
            this.notifyAdClosed();
            this.removeAllViews();
            this.bannerWebView.destroy();
            this.destroy();
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    public void close() {
        try {
            this.destroy();
            this.setVisibility(8);
            this.notifyAdClosed();
            this.removeAllViews();
            this.bannerWebView.destroy();
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        boolean bl = this.isVisible = visibility == 0;
        if (this.bannerController != null) {
            this.bannerController.viewAd(this.isVisible);
        }
    }

    public boolean isInForeground() {
        return this.isVisible;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPackagename() {
        String pName = "";
        List packs = this.getContext().getPackageManager().getInstalledPackages(0);
        for (int i = 0; i < packs.size(); ++i) {
            pName = ((PackageInfo)packs.get((int)i)).packageName;
            if (!pName.contains("browser") && !pName.equals("com.android.chrome")) continue;
            return pName;
        }
        return "";
    }

    private void setParams(Context context, AttributeSet attrs) {
        if (context == null || attrs == null) {
            return;
        }
        this.setRefreshInterval(attrs.getAttributeIntValue(null, "refreshInterval", 60));
        String inventoryId = attrs.getAttributeValue(null, "inventoryId");
        String publisherId = attrs.getAttributeValue(null, "publisherId");
        String userId = attrs.getAttributeValue(null, "userId");
        this.setAdHeight(attrs.getAttributeIntValue(null, "adHeight", 50));
        if (inventoryId != null && !inventoryId.trim().equals("")) {
            this.setInventoryId(inventoryId);
        }
        if (publisherId != null && !publisherId.trim().equals("")) {
            this.setPublisherId(publisherId);
        }
        if (userId != null && !userId.trim().equals("")) {
            this.setUserId(userId);
        }
        this.setUseCache(attrs.getAttributeBooleanValue(null, "useCache", true));
    }

    public static interface SuezXBannerListener {
        public void onBannerLoaded();

        public void onBannerFailed(SuezXError var1);

        public void onBannerClicked();

        public void onBannerClosed();
    }
}

