/*
 * Decompiled with CFR 0.152.
 */
package io.tpmn.suezx;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import io.tpmn.suezx.SuezXError;
import io.tpmn.suezx.SuezXInterstitialAd;
import io.tpmn.suezx.SuezXInterstitialWebInterface;
import io.tpmn.suezx.SuezXUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public class SuezXInterstitialActivity
extends Activity {
    private static final String TAG = SuezXInterstitialActivity.class.getSimpleName();
    private static final String BASE_URL = "https://ad.tpmn.io";
    private boolean bDebug = false;
    private WebView interstitialWebView;
    private RelativeLayout mLayout;
    private static Method mWebView_SetLayerType;
    private static Field mWebView_LAYER_TYPE_SOFTWARE;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(1);
        this.requestWindowFeature(1);
        this.mLayout = new RelativeLayout((Context)this);
        this.mLayout.setBackgroundColor(-16777216);
        this.setContentView((View)this.mLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.interstitialWebView = this.createWebView((Context)this);
        this.interstitialWebView.setVisibility(4);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -1);
        layoutParams.addRule(13);
        this.mLayout.addView((View)this.interstitialWebView, (ViewGroup.LayoutParams)layoutParams);
        this.renderAd();
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.interstitialWebView != null) {
                ViewGroup parent = (ViewGroup)this.interstitialWebView.getParent();
                if (parent != null) {
                    parent.removeView((View)this.interstitialWebView);
                }
                this.interstitialWebView.removeAllViews();
                this.interstitialWebView.destroy();
            }
            SuezXInterstitialAd.state = SuezXInterstitialAd.SuezXInterstitialState.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.finish();
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.endAnimation();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private WebView createWebView(Context context) {
        WebView webView = new WebView(context){

            public void draw(Canvas canvas) {
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    super.draw(canvas);
                }
            }
        };
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        if (0 != (this.getApplicationInfo().flags &= 2)) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setSupportZoom(false);
        webSettings.setAllowFileAccess(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (SuezXInterstitialAd.usesCache) {
            webSettings.setCacheMode(-1);
            webView.setDrawingCacheEnabled(true);
            webSettings.setAppCacheEnabled(true);
        } else {
            webSettings.setCacheMode(2);
            webView.clearCache(true);
            webView.setDrawingCacheEnabled(false);
            webSettings.setAppCacheEnabled(false);
        }
        webView.addJavascriptInterface((Object)new SuezXInterstitialWebInterface(this), "tpmn_android");
        webView.setBackgroundColor(-16777216);
        webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.d((String)TAG, (String)"WebViewClient - shouldOverrideUrlLoading (API < 24)");
                if (url.startsWith("http") || url.startsWith("market")) {
                    Log.d((String)TAG, (String)"if");
                    SuezXInterstitialActivity.this.doOpenUrl(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            @TargetApi(value=24)
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                Log.d((String)TAG, (String)"WebViewClient - shouldOverrideUrlLoading (API >= 24)");
                String url = request.getUrl().toString();
                if (url.startsWith("http") || url.startsWith("market")) {
                    Log.d((String)TAG, (String)"if");
                    SuezXInterstitialActivity.this.doOpenUrl(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, request);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                if (SuezXInterstitialAd.interstitialListener != null) {
                    SuezXInterstitialAd.interstitialListener.onInterstitialFailed(SuezXError.NETWORK_ERROR);
                }
                SuezXInterstitialActivity.this.onDestroy();
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                view.setVisibility(0);
            }
        });
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
                WebView newWebView = new WebView(view.getContext());
                newWebView.setWebViewClient(new WebViewClient(){

                    public boolean shouldOverrideUrlLoading(WebView view, String url) {
                        Log.d((String)TAG, (String)"WebChromeClient - shouldOverrideUrlLoading (API < 24)");
                        if (url.startsWith("http") || url.startsWith("market")) {
                            Log.d((String)TAG, (String)"if");
                            SuezXInterstitialActivity.this.doOpenUrl(url);
                            return true;
                        }
                        return super.shouldOverrideUrlLoading(view, url);
                    }

                    @TargetApi(value=24)
                    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                        Log.d((String)TAG, (String)"WebChromeClient - shouldOverrideUrlLoading (API >= 24)");
                        String url = request.getUrl().toString();
                        if (url.startsWith("http") || url.startsWith("market")) {
                            Log.d((String)TAG, (String)"if");
                            SuezXInterstitialActivity.this.doOpenUrl(url);
                            return true;
                        }
                        return super.shouldOverrideUrlLoading(view, request);
                    }
                });
                newWebView.setWebChromeClient(new WebChromeClient(){

                    public void onConsoleMessage(String message, int lineNumber, String sourceID) {
                    }
                });
                WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
                transport.setWebView(newWebView);
                resultMsg.sendToTarget();
                return true;
            }

            public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            }
        });
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        return webView;
    }

    private void doOpenUrl(String url) {
        if (SuezXInterstitialAd.interstitialListener != null) {
            SuezXInterstitialAd.interstitialListener.onInterstitialClicked();
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            String pName = "";
            pName = this.getBrowser(url);
            if (!pName.equals("")) {
                intent.setPackage(pName);
            }
            this.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderAd() {
        Log.d((String)TAG, (String)"renderAd");
        if (SuezXInterstitialAd.response.equals("")) {
            return;
        }
        if (!SuezXInterstitialAd.response.startsWith("{") && !SuezXInterstitialAd.response.startsWith("<")) {
            SuezXInterstitialAd.notifyAdFailed(SuezXError.SERVER_ERROR);
            return;
        }
        try {
            if (SuezXInterstitialAd.response.startsWith("{")) {
                this.interstitialWebView.loadDataWithBaseURL(BASE_URL, SuezXUtils.parseJson(SuezXInterstitialAd.response).getHtml(), "text/html", "utf-8", null);
            } else {
                this.interstitialWebView.loadDataWithBaseURL(BASE_URL, SuezXInterstitialAd.response, "text/html", "utf-8", null);
            }
        }
        catch (Exception e) {
            SuezXInterstitialAd.notifyAdFailed(SuezXError.INTERNAL_ERROR);
        }
    }

    private static void setLayer(WebView webView) {
        if (mWebView_SetLayerType != null && mWebView_LAYER_TYPE_SOFTWARE != null) {
            try {
                mWebView_SetLayerType.invoke((Object)webView, mWebView_LAYER_TYPE_SOFTWARE.getInt(WebView.class), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getDensityPixel(int paramInt) {
        DisplayMetrics localDisplayMetrics = this.getResources().getDisplayMetrics();
        return (int)((float)paramInt * localDisplayMetrics.density);
    }

    protected void endAnimation() {
        if (SuezXInterstitialAd.interstitialListener != null) {
            SuezXInterstitialAd.notifyAdDismissed();
        }
        this.onDestroy();
    }

    public String getBrowser(String url) {
        Iterator iterator;
        PackageManager packageManager = this.getPackageManager();
        Intent browsableIntent = new Intent();
        browsableIntent.setAction("android.intent.action.VIEW");
        browsableIntent.addCategory("android.intent.category.BROWSABLE");
        browsableIntent.setData(Uri.parse((String)url));
        List list = packageManager.queryIntentActivities(browsableIntent, 0);
        if (list.size() > 0 && (iterator = list.iterator()).hasNext()) {
            ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
            String pkgName = resolveInfo.activityInfo.applicationInfo.packageName;
            return pkgName;
        }
        return "";
    }
}

