/*
 * Decompiled with CFR 0.152.
 */
package io.tpmn.suezx;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import io.tpmn.suezx.SuezXError;
import io.tpmn.suezx.SuezXInterstitialActivity;
import io.tpmn.suezx.SuezXUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public final class SuezXInterstitialAd {
    private static final String TAG = SuezXInterstitialAd.class.getSimpleName();
    private static final String BASE_URL = "https://ad.tpmn.io";
    private Map<String, Object> reqParams = null;
    private String publisherId = "";
    private String inventoryId = "";
    private String userAgent = "";
    private String userAgentEnc = "";
    private String gdpr = "0";
    private String gdprConsent = "0";
    private String yob = "";
    private String gender = "";
    @NonNull
    public static String response = "";
    public static boolean usesCache = true;
    public static long lastTimes = 0L;
    public static boolean isShown = false;
    protected static SuezXInterstitialListener interstitialListener;
    public static SuezXInterstitialState state;
    private Activity activity;
    private static final Handler updateHandler;
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int SOCKET_TIMEOUT = 10000;

    public SuezXInterstitialAd(Activity activity) {
        this.activity = activity;
        state = SuezXInterstitialState.IDLE;
        usesCache = true;
        this.userAgent = SuezXUtils.getUserAgent((Context)activity);
        this.userAgentEnc = SuezXUtils.getUserAgent((Context)activity, true);
    }

    public void setPublisherId(String publisherId) {
        this.publisherId = publisherId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setGdpr(String gdpr) {
        this.gdpr = gdpr;
    }

    public void setGdprConsent(String gdprConsent) {
        this.gdprConsent = gdprConsent;
    }

    public void setYob(String yob) {
        if (yob != null) {
            this.yob = yob;
        }
    }

    public void setGender(String gender) {
        if (gender != null) {
            this.gender = gender;
        }
    }

    public void setUseCache(boolean usesCache) {
        SuezXInterstitialAd.usesCache = usesCache;
    }

    public void setInterstitialListener(SuezXInterstitialListener interstitialListener) {
        SuezXInterstitialAd.interstitialListener = interstitialListener;
    }

    public synchronized void loadAd() {
        Log.d((String)TAG, (String)"loadAd");
        if (!this.isIdle()) {
            return;
        }
        state = SuezXInterstitialState.LOADING;
        new Thread(new Runnable(){

            @Override
            public void run() {
                int maxLogSize;
                String reqUrl = SuezXInterstitialAd.this.createRequestUrl();
                Log.i((String)TAG, (String)("reqUrl: " + reqUrl));
                if (SuezXUtils.NVL(SuezXInterstitialAd.this.publisherId) || SuezXUtils.NVL(SuezXInterstitialAd.this.inventoryId)) {
                    SuezXInterstitialAd.notifyAdFailed(SuezXError.INVALID_ID);
                    return;
                }
                response = SuezXInterstitialAd.this.getResponse(reqUrl);
                int responseSize = response.length();
                if (responseSize <= (maxLogSize = 4000)) {
                    Log.i((String)TAG, (String)("response: " + response));
                } else {
                    Log.i((String)TAG, (String)"response:");
                    for (int start = 0; start < responseSize; start += maxLogSize) {
                        int end = Math.min(start + maxLogSize, responseSize);
                        Log.i((String)TAG, (String)response.substring(start, end));
                    }
                }
            }
        }).start();
    }

    @NonNull
    private String createRequestUrl() {
        Log.d((String)TAG, (String)"createRequestUrl");
        if (this.reqParams == null) {
            this.reqParams = SuezXUtils.getRequestParams((Context)this.activity);
        }
        String reqUrl = "https://ad.tpmn.io/appbanner.tpmn";
        reqUrl = reqUrl + "?pi=" + this.publisherId;
        reqUrl = reqUrl + "&ii=" + this.inventoryId;
        reqUrl = reqUrl + "&ua=" + this.userAgentEnc;
        reqUrl = reqUrl + "&cn=" + this.reqParams.get("cn");
        reqUrl = reqUrl + "&os=android";
        reqUrl = reqUrl + "&osv=" + Build.VERSION.RELEASE;
        try {
            reqUrl = reqUrl + "&dn=" + URLEncoder.encode(Build.MODEL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        reqUrl = reqUrl + "&udid=" + this.reqParams.get("udid");
        reqUrl = reqUrl + "&dnt=" + this.reqParams.get("dnt");
        reqUrl = reqUrl + "&v=2.1.1";
        reqUrl = reqUrl + "&ct=" + this.reqParams.get("ct");
        reqUrl = reqUrl + "&bundle=" + this.reqParams.get("bundle");
        reqUrl = reqUrl + "&av=" + this.reqParams.get("av");
        reqUrl = reqUrl + "&mcc=" + this.reqParams.get("mcc");
        reqUrl = reqUrl + "&mnc=" + this.reqParams.get("mnc");
        reqUrl = reqUrl + "&locale=" + this.reqParams.get("locale");
        reqUrl = reqUrl + "&gdpr=" + this.gdpr;
        reqUrl = reqUrl + "&gdpr_consent=" + this.gdprConsent;
        reqUrl = reqUrl + "&mraid=0";
        reqUrl = reqUrl + "&yob=" + this.yob;
        reqUrl = reqUrl + "&gender=" + this.gender;
        reqUrl = reqUrl + "&keywords=";
        return reqUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    private String getResponse(@NonNull String url) {
        String response = "";
        HttpURLConnection conn = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, null, new SecureRandom());
            conn = (HttpsURLConnection)new URL(url).openConnection();
            ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", this.userAgent);
            conn.connect();
            int responseCode = conn.getResponseCode();
            Log.i((String)TAG, (String)("responseCode: " + responseCode));
            switch (responseCode) {
                case 200: {
                    String str;
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((str = br.readLine()) != null) {
                        sb.append(str);
                    }
                    br.close();
                    response = sb.toString();
                    SuezXInterstitialAd.notifyAdLoaded();
                    return response;
                }
                case 204: {
                    SuezXInterstitialAd.notifyAdFailed(SuezXError.NO_FILL);
                    return response;
                }
                case 404: {
                    SuezXInterstitialAd.notifyAdFailed(SuezXError.SERVER_ERROR);
                    return response;
                }
                case 500: {
                    SuezXInterstitialAd.notifyAdFailed(SuezXError.SERVER_ERROR);
                    return response;
                }
                default: {
                    SuezXInterstitialAd.notifyAdFailed(SuezXError.SERVER_ERROR);
                    return response;
                }
            }
        }
        catch (Exception e) {
            SuezXInterstitialAd.notifyAdFailed(SuezXError.SERVER_ERROR);
            return response;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public synchronized void showAd() {
        Log.d((String)TAG, (String)"showAd");
        if (!this.isLoaded()) {
            Log.d((String)TAG, (String)"showAd - !isLoaded");
            SuezXInterstitialAd.notifyAdFailed(SuezXError.INTERSTITIAL_LOAD_ERROR);
            return;
        }
        updateHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Log.d((String)TAG, (String)"showAd - isLoaded - try start");
                    Intent intent = new Intent((Context)SuezXInterstitialAd.this.activity, SuezXInterstitialActivity.class);
                    intent.setFlags(0x10020000);
                    SuezXInterstitialAd.this.activity.startActivity(intent);
                    SuezXInterstitialAd.notifyAdShown();
                    Log.d((String)TAG, (String)"showAd - isLoaded try end");
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)("showAd - isLoaded - catch " + e.toString()));
                    SuezXInterstitialAd.notifyAdFailed(SuezXError.INTERSTITIAL_SHOW_ERROR);
                }
            }
        });
    }

    protected static void notifyAdLoaded() {
        state = SuezXInterstitialState.LOADED;
        if (interstitialListener != null) {
            interstitialListener.onInterstitialLoaded();
        }
    }

    protected static void notifyAdFailed(SuezXError suezXError) {
        state = SuezXInterstitialState.IDLE;
        if (interstitialListener != null) {
            interstitialListener.onInterstitialFailed(suezXError);
        }
    }

    protected static void notifyAdShown() {
        state = SuezXInterstitialState.SHOWN;
        if (interstitialListener != null) {
            interstitialListener.onInterstitialShown();
        }
    }

    protected void notifyAdClicked() {
        if (interstitialListener != null) {
            interstitialListener.onInterstitialClicked();
        }
    }

    protected static void notifyAdDismissed() {
        state = SuezXInterstitialState.IDLE;
        if (interstitialListener != null) {
            interstitialListener.onInterstitialDismissed();
        }
    }

    private boolean isIdle() {
        return state == SuezXInterstitialState.IDLE;
    }

    private boolean isLoaded() {
        return state == SuezXInterstitialState.LOADED;
    }

    static {
        updateHandler = new Handler();
    }

    protected static enum SuezXInterstitialState {
        IDLE,
        LOADING,
        LOADED,
        SHOWN;

    }

    public static interface SuezXInterstitialListener {
        public void onInterstitialLoaded();

        public void onInterstitialFailed(SuezXError var1);

        public void onInterstitialShown();

        public void onInterstitialClicked();

        public void onInterstitialDismissed();
    }
}

