/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;

public enum InputEncoding {
    UTF_8(StandardCharsets.UTF_8),
    UTF_16(ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? StandardCharsets.UTF_16BE : StandardCharsets.UTF_16LE);

    private final @NonNull Charset charset;

    private InputEncoding(Charset charset) {
        this.charset = charset;
    }

    Charset charset() {
        return this.charset;
    }

    static @NonNull InputEncoding valueOf(@NonNull Charset charset) throws IllegalArgumentException {
        if (charset.equals(StandardCharsets.UTF_8)) {
            return UTF_8;
        }
        if (charset.equals(StandardCharsets.UTF_16BE) || charset.equals(StandardCharsets.UTF_16LE) || charset.equals(StandardCharsets.UTF_16)) {
            return UTF_16;
        }
        throw new IllegalArgumentException("Invalid character set: %s".formatted(charset));
    }
}

