/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.LookaheadIterator;
import io.github.treesitter.jtreesitter.Query;
import io.github.treesitter.jtreesitter.QueryError;
import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TreeSitter;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.ref.Cleaner;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Language {
    @Unsigned
    public static final int LANGUAGE_VERSION = TreeSitter.TREE_SITTER_LANGUAGE_VERSION();
    @Unsigned
    public static final int MIN_COMPATIBLE_LANGUAGE_VERSION = TreeSitter.TREE_SITTER_MIN_COMPATIBLE_LANGUAGE_VERSION();
    private static final ValueLayout VOID_PTR = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    private static final FunctionDescriptor FUNC_DESC = FunctionDescriptor.of(VOID_PTR, new MemoryLayout[0]);
    private static final Linker LINKER = Linker.nativeLinker();
    private static final Cleaner CLEANER = Cleaner.create();
    private final MemorySegment self;
    @Unsigned
    private final int version;

    public Language(MemorySegment self) throws IllegalArgumentException {
        this.self = self.asReadOnly();
        this.version = TreeSitter.ts_language_version(this.self);
        CLEANER.register(self, new Cleanup(this.self));
        if (this.version < MIN_COMPATIBLE_LANGUAGE_VERSION || this.version > LANGUAGE_VERSION) {
            throw new IllegalArgumentException(String.format("Incompatible language version %d. Must be between %d and %d.", this.version, MIN_COMPATIBLE_LANGUAGE_VERSION, LANGUAGE_VERSION));
        }
    }

    private static UnsatisfiedLinkError unresolved(String name) {
        return new UnsatisfiedLinkError("Unresolved symbol: %s".formatted(name));
    }

    public static Language load(SymbolLookup symbols, String language) throws RuntimeException {
        MemorySegment address = symbols.find(language).orElseThrow(() -> Language.unresolved(language));
        try {
            MethodHandle function = LINKER.downcallHandle(address, FUNC_DESC, new Linker.Option[0]);
            return new Language(function.invokeExact());
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to load %s".formatted(language), e);
        }
    }

    MemorySegment segment() {
        return this.self;
    }

    @Unsigned
    public int getVersion() {
        return this.version;
    }

    @Unsigned
    public int getSymbolCount() {
        return TreeSitter.ts_language_symbol_count(this.self);
    }

    @Unsigned
    public int getStateCount() {
        return TreeSitter.ts_language_state_count(this.self);
    }

    @Unsigned
    public int getFieldCount() {
        return TreeSitter.ts_language_field_count(this.self);
    }

    public @Nullable String getSymbolName(@Unsigned short symbol) {
        MemorySegment name = TreeSitter.ts_language_symbol_name(this.self, symbol);
        return name.equals(MemorySegment.NULL) ? null : name.getString(0L);
    }

    @Unsigned
    public short getSymbolForName(String name, boolean isNamed) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment segment = arena.allocateFrom(name);
            short s = TreeSitter.ts_language_symbol_for_name(this.self, segment, name.length(), isNamed);
            return s;
        }
    }

    public boolean isNamed(@Unsigned short symbol) {
        return TreeSitter.ts_language_symbol_type(this.self, symbol) == TreeSitter.TSSymbolTypeRegular();
    }

    public boolean isVisible(@Unsigned short symbol) {
        return TreeSitter.ts_language_symbol_type(this.self, symbol) <= TreeSitter.TSSymbolTypeAnonymous();
    }

    public @Nullable String getFieldNameForId(@Unsigned short id) {
        MemorySegment name = TreeSitter.ts_language_field_name_for_id(this.self, id);
        return name.equals(MemorySegment.NULL) ? null : name.getString(0L);
    }

    @Unsigned
    public short getFieldIdForName(String name) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment segment = arena.allocateFrom(name);
            short s = TreeSitter.ts_language_field_id_for_name(this.self, segment, name.length());
            return s;
        }
    }

    @Unsigned
    public short nextState(@Unsigned short state, @Unsigned short symbol) {
        return TreeSitter.ts_language_next_state(this.self, state, symbol);
    }

    public LookaheadIterator lookaheadIterator(@Unsigned short state) throws IllegalArgumentException {
        return new LookaheadIterator(this.self, state);
    }

    public Query query(String source) throws QueryError {
        return new Query(this, source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Language)) {
            return false;
        }
        Language other = (Language)o;
        return this.self.equals(other.self);
    }

    public int hashCode() {
        return Long.hashCode(this.self.address());
    }

    public String toString() {
        return "Language{id=0x%x, version=%d}".formatted(this.self.address(), this.version);
    }

    private static final class Cleanup
    implements Runnable {
        MemorySegment segment;

        private Cleanup(MemorySegment segment) {
            this.segment = segment;
        }

        @Override
        public void run() {
            TreeSitter.ts_language_delete(this.segment);
        }
    }
}

