/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.Language;
import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TreeSitter;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class LookaheadIterator
implements AutoCloseable,
Iterator<Symbol> {
    private final Arena arena;
    private final MemorySegment self;
    private final short state;
    private boolean iterFirst = true;
    private boolean hasNext = false;

    LookaheadIterator(MemorySegment language, @Unsigned short state) throws IllegalArgumentException {
        MemorySegment iterator = TreeSitter.ts_lookahead_iterator_new(language, state);
        if (iterator == null) {
            throw new IllegalArgumentException("State %d is not valid for %s".formatted(Short.toUnsignedInt(state), this));
        }
        this.state = state;
        this.arena = Arena.ofShared();
        this.self = iterator.reinterpret(this.arena, TreeSitter::ts_lookahead_iterator_delete);
    }

    public Language getLanguage() {
        return new Language(TreeSitter.ts_lookahead_iterator_language(this.self));
    }

    @Unsigned
    public short getCurrentSymbol() {
        return TreeSitter.ts_lookahead_iterator_current_symbol(this.self);
    }

    public String getCurrentSymbolName() {
        return TreeSitter.ts_lookahead_iterator_current_symbol_name(this.self).getString(0L);
    }

    public boolean reset(@Unsigned short state) {
        return TreeSitter.ts_lookahead_iterator_reset_state(this.self, state);
    }

    public boolean reset(@Unsigned short state, Language language) {
        return TreeSitter.ts_lookahead_iterator_reset(this.self, language.segment(), state);
    }

    @Override
    public boolean hasNext() {
        if (this.iterFirst) {
            this.iterFirst = false;
            this.hasNext = TreeSitter.ts_lookahead_iterator_next(this.self);
            TreeSitter.ts_lookahead_iterator_reset_state(this.self, this.state);
        }
        return this.hasNext;
    }

    @Override
    public Symbol next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = TreeSitter.ts_lookahead_iterator_next(this.self);
        return new Symbol(this.getCurrentSymbol(), this.getCurrentSymbolName());
    }

    @Unsigned
    public Stream<Short> symbols() {
        TreeSitter.ts_lookahead_iterator_reset_state(this.self, this.state);
        return StreamSupport.stream(new IdIterator(this.self), false);
    }

    public Stream<String> names() {
        TreeSitter.ts_lookahead_iterator_reset_state(this.self, this.state);
        return StreamSupport.stream(new NameIterator(this.self), false);
    }

    @Override
    public void close() throws RuntimeException {
        this.arena.close();
    }

    @Override
    public void remove() {
        Iterator.super.remove();
    }

    public record Symbol(@Unsigned short id, String name) {
    }

    private static final class IdIterator
    extends Spliterators.AbstractSpliterator<Short> {
        private final MemorySegment iterator;

        private IdIterator(MemorySegment iterator) {
            super(Long.MAX_VALUE, 1044);
            this.iterator = iterator;
        }

        @Override
        public Comparator<? super Short> getComparator() {
            return Short::compareUnsigned;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Short> action) {
            boolean result = TreeSitter.ts_lookahead_iterator_next(this.iterator);
            if (result) {
                short symbol = TreeSitter.ts_lookahead_iterator_current_symbol(this.iterator);
                action.accept((Short)symbol);
            }
            return result;
        }
    }

    private static final class NameIterator
    extends Spliterators.AbstractSpliterator<String> {
        private final MemorySegment iterator;

        private NameIterator(MemorySegment iterator) {
            super(Long.MAX_VALUE, 1280);
            this.iterator = iterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            boolean result = TreeSitter.ts_lookahead_iterator_next(this.iterator);
            if (result) {
                MemorySegment name = TreeSitter.ts_lookahead_iterator_current_symbol_name(this.iterator);
                action.accept(name.getString(0L));
            }
            return result;
        }
    }
}

