/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.InputEdit;
import io.github.treesitter.jtreesitter.Point;
import io.github.treesitter.jtreesitter.Range;
import io.github.treesitter.jtreesitter.Tree;
import io.github.treesitter.jtreesitter.TreeCursor;
import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TSNode;
import io.github.treesitter.jtreesitter.internal.TreeSitter;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Node {
    private final MemorySegment self;
    private final Tree tree;
    private @Nullable List<Node> children;
    private final Arena arena = Arena.ofAuto();

    Node(MemorySegment self, Tree tree) {
        this.self = self;
        this.tree = tree;
    }

    private Optional<Node> optional(MemorySegment node) {
        return TreeSitter.ts_node_is_null(node) ? Optional.empty() : Optional.of(new Node(node, this.tree));
    }

    MemorySegment copy(Arena arena) {
        return this.self.reinterpret(arena, null);
    }

    public Tree getTree() {
        return this.tree;
    }

    @Unsigned
    public long getId() {
        return TSNode.id(this.self).address();
    }

    @Unsigned
    public short getSymbol() {
        return TreeSitter.ts_node_symbol(this.self);
    }

    @Unsigned
    public short getGrammarSymbol() {
        return TreeSitter.ts_node_grammar_symbol(this.self);
    }

    public String getType() {
        return TreeSitter.ts_node_type(this.self).getString(0L);
    }

    public String getGrammarType() {
        return TreeSitter.ts_node_grammar_type(this.self).getString(0L);
    }

    public boolean isNamed() {
        return TreeSitter.ts_node_is_named(this.self);
    }

    public boolean isExtra() {
        return TreeSitter.ts_node_is_extra(this.self);
    }

    public boolean isError() {
        return TreeSitter.ts_node_is_error(this.self);
    }

    public boolean isMissing() {
        return TreeSitter.ts_node_is_missing(this.self);
    }

    public boolean hasChanges() {
        return TreeSitter.ts_node_has_changes(this.self);
    }

    public boolean hasError() {
        return TreeSitter.ts_node_has_error(this.self);
    }

    @Unsigned
    public short getParseState() {
        return TreeSitter.ts_node_parse_state(this.self);
    }

    @Unsigned
    public short getNextParseState() {
        return TreeSitter.ts_node_next_parse_state(this.self);
    }

    @Unsigned
    public int getStartByte() {
        return TreeSitter.ts_node_start_byte(this.self);
    }

    @Unsigned
    public int getEndByte() {
        return TreeSitter.ts_node_end_byte(this.self);
    }

    public Range getRange() {
        return new Range(this.getStartPoint(), this.getEndPoint(), this.getStartByte(), this.getEndByte());
    }

    public Point getStartPoint() {
        return Point.from(TreeSitter.ts_node_start_point(this.arena, this.self));
    }

    public Point getEndPoint() {
        return Point.from(TreeSitter.ts_node_end_point(this.arena, this.self));
    }

    @Unsigned
    public int getChildCount() {
        return TreeSitter.ts_node_child_count(this.self);
    }

    @Unsigned
    public int getNamedChildCount() {
        return TreeSitter.ts_node_named_child_count(this.self);
    }

    @Unsigned
    public int getDescendantCount() {
        return TreeSitter.ts_node_descendant_count(this.self);
    }

    public Optional<Node> getParent() {
        return this.optional(TreeSitter.ts_node_parent(this.arena, this.self));
    }

    public Optional<Node> getNextSibling() {
        return this.optional(TreeSitter.ts_node_next_sibling(this.arena, this.self));
    }

    public Optional<Node> getPrevSibling() {
        return this.optional(TreeSitter.ts_node_prev_sibling(this.arena, this.self));
    }

    public Optional<Node> getNextNamedSibling() {
        return this.optional(TreeSitter.ts_node_next_named_sibling(this.arena, this.self));
    }

    public Optional<Node> getPrevNamedSibling() {
        return this.optional(TreeSitter.ts_node_prev_named_sibling(this.arena, this.self));
    }

    public Optional<Node> getChild(@Unsigned int index) throws IndexOutOfBoundsException {
        if (index >= this.getChildCount()) {
            throw new IndexOutOfBoundsException("Child index %s is out of bounds".formatted(Integer.toUnsignedString(index)));
        }
        return this.optional(TreeSitter.ts_node_child(this.arena, this.self, index));
    }

    public Optional<Node> getNamedChild(@Unsigned int index) throws IndexOutOfBoundsException {
        if (index >= this.getNamedChildCount()) {
            throw new IndexOutOfBoundsException("Child index %s is out of bounds".formatted(Integer.toUnsignedString(index)));
        }
        return this.optional(TreeSitter.ts_node_named_child(this.arena, this.self, index));
    }

    public Optional<Node> getChildByFieldId(@Unsigned short id) {
        return this.optional(TreeSitter.ts_node_child_by_field_id(this.arena, this.self, id));
    }

    public Optional<Node> getChildByFieldName(String name) {
        MemorySegment segment = this.arena.allocateFrom(name);
        return this.optional(TreeSitter.ts_node_child_by_field_name(this.arena, this.self, segment, name.length()));
    }

    public List<Node> getChildren() {
        if (this.children == null) {
            int length = this.getChildCount();
            if (length == 0) {
                return Collections.emptyList();
            }
            ArrayList<Node> children = new ArrayList<Node>(length);
            MemorySegment cursor = TreeSitter.ts_tree_cursor_new(this.arena, this.self);
            TreeSitter.ts_tree_cursor_goto_first_child(cursor);
            for (int i = 0; i < length; ++i) {
                MemorySegment node = TreeSitter.ts_tree_cursor_current_node(this.arena, cursor);
                children.add(new Node(node, this.tree));
                TreeSitter.ts_tree_cursor_goto_next_sibling(cursor);
            }
            TreeSitter.ts_tree_cursor_delete(cursor);
            this.children = Collections.unmodifiableList(children);
        }
        return this.children;
    }

    public List<Node> getNamedChildren() {
        return this.getChildren().stream().filter(Node::isNamed).toList();
    }

    public List<Node> getChildrenByFieldId(@Unsigned short id) {
        if (id == 0) {
            return Collections.emptyList();
        }
        int length = this.getChildCount();
        ArrayList<Node> children = new ArrayList<Node>(length);
        MemorySegment cursor = TreeSitter.ts_tree_cursor_new(this.arena, this.self);
        boolean ok = TreeSitter.ts_tree_cursor_goto_first_child(cursor);
        while (ok) {
            if (TreeSitter.ts_tree_cursor_current_field_id(cursor) == id) {
                MemorySegment node = TreeSitter.ts_tree_cursor_current_node(this.arena, cursor);
                children.add(new Node(node, this.tree));
            }
            ok = TreeSitter.ts_tree_cursor_goto_next_sibling(cursor);
        }
        TreeSitter.ts_tree_cursor_delete(cursor);
        children.trimToSize();
        return children;
    }

    public List<Node> getChildrenByFieldName(String name) {
        return this.getChildrenByFieldId(this.tree.getLanguage().getFieldIdForName(name));
    }

    public @Nullable String getFieldNameForChild(@Unsigned int index) throws IndexOutOfBoundsException {
        if (index >= this.getChildCount()) {
            throw new IndexOutOfBoundsException("Child index %s is out of bounds".formatted(Integer.toUnsignedString(index)));
        }
        MemorySegment segment = TreeSitter.ts_node_field_name_for_child(this.self, index);
        return segment.equals(MemorySegment.NULL) ? null : segment.getString(0L);
    }

    public Optional<Node> getDescendant(@Unsigned int start, @Unsigned int end) throws IllegalArgumentException {
        if (Integer.compareUnsigned(start, end) > 0) {
            throw new IllegalArgumentException(String.format("Start byte %s exceeds end byte %s", Integer.toUnsignedString(start), Integer.toUnsignedString(end)));
        }
        return this.optional(TreeSitter.ts_node_descendant_for_byte_range(this.arena, this.self, start, end));
    }

    public Optional<Node> getDescendant(Point start, Point end) throws IllegalArgumentException {
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Start point %s exceeds end point %s".formatted(start, end));
        }
        MemorySegment startPoint = start.into(this.arena);
        MemorySegment endPoint = end.into(this.arena);
        return this.optional(TreeSitter.ts_node_descendant_for_point_range(this.arena, this.self, startPoint, endPoint));
    }

    public Optional<Node> getNamedDescendant(@Unsigned int start, @Unsigned int end) throws IllegalArgumentException {
        if (Integer.compareUnsigned(start, end) > 0) {
            throw new IllegalArgumentException(String.format("Start byte %s exceeds end byte %s", Integer.toUnsignedString(start), Integer.toUnsignedString(end)));
        }
        return this.optional(TreeSitter.ts_node_named_descendant_for_byte_range(this.arena, this.self, start, end));
    }

    public Optional<Node> getNamedDescendant(Point start, Point end) {
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Start point %s exceeds end point %s".formatted(start, end));
        }
        MemorySegment startPoint = start.into(this.arena);
        MemorySegment endPoint = end.into(this.arena);
        return this.optional(TreeSitter.ts_node_named_descendant_for_point_range(this.arena, this.self, startPoint, endPoint));
    }

    public Optional<Node> getChildContainingDescendant(Node descendant) {
        return this.optional(TreeSitter.ts_node_child_containing_descendant(this.arena, this.self, descendant.self));
    }

    public @Nullable String getText() {
        String text = this.tree.getText();
        if (text == null) {
            return null;
        }
        int endByte = Math.min(this.getEndByte(), text.length());
        return text.substring(this.getStartByte(), endByte);
    }

    public void edit(InputEdit edit) {
        TreeSitter.ts_node_edit(this.self, edit.into(this.arena));
        this.children = null;
    }

    public TreeCursor walk() {
        return new TreeCursor(this, this.tree);
    }

    public String toSexp() {
        MemorySegment string = TreeSitter.ts_node_string(this.self);
        String result = string.getString(0L);
        TreeSitter.free(string);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        return TreeSitter.ts_node_eq(this.self, other.self);
    }

    public int hashCode() {
        return Long.hashCode(this.getId());
    }

    public String toString() {
        return String.format("Node{type=%s, startByte=%s, endByte=%s}", this.getType(), Integer.toUnsignedString(this.getStartByte()), Integer.toUnsignedString(this.getEndByte()));
    }
}

