/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.InputEncoding;
import io.github.treesitter.jtreesitter.Language;
import io.github.treesitter.jtreesitter.Logger;
import io.github.treesitter.jtreesitter.ParseCallback;
import io.github.treesitter.jtreesitter.Point;
import io.github.treesitter.jtreesitter.Range;
import io.github.treesitter.jtreesitter.Tree;
import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TSInput;
import io.github.treesitter.jtreesitter.internal.TSLogger;
import io.github.treesitter.jtreesitter.internal.TSPoint;
import io.github.treesitter.jtreesitter.internal.TSRange;
import io.github.treesitter.jtreesitter.internal.TreeSitter;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SequenceLayout;
import java.lang.invoke.VarHandle;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Parser
implements AutoCloseable {
    final MemorySegment self;
    private final Arena arena;
    private @Nullable Language language;
    private List<Range> includedRanges = Collections.singletonList(Range.DEFAULT);

    public Parser() {
        this.arena = Arena.ofShared();
        this.self = TreeSitter.ts_parser_new().reinterpret(this.arena, TreeSitter::ts_parser_delete);
    }

    public Parser(Language language) {
        this();
        TreeSitter.ts_parser_set_language(this.self, language.segment());
        this.language = language;
    }

    public @Nullable Language getLanguage() {
        return this.language;
    }

    public Parser setLanguage(Language language) {
        TreeSitter.ts_parser_set_language(this.self, language.segment());
        this.language = language;
        return this;
    }

    @Unsigned
    public long getTimeoutMicros() {
        return TreeSitter.ts_parser_timeout_micros(this.self);
    }

    public Parser setTimeoutMicros(@Unsigned long timeoutMicros) {
        TreeSitter.ts_parser_set_timeout_micros(this.self, timeoutMicros);
        return this;
    }

    public Parser setLogger(@Nullable Logger logger) {
        if (logger == null) {
            TreeSitter.ts_parser_set_logger(this.self, TSLogger.allocate(this.arena));
        } else {
            MemorySegment segment = TSLogger.allocate(this.arena);
            TSLogger.payload(segment, MemorySegment.NULL);
            MemorySegment log2 = TSLogger.log.allocate((p, type, message) -> {
                Logger.Type logType = Logger.Type.values()[type];
                logger.accept(logType, message.getString(0L));
            }, this.arena);
            TSLogger.log(segment, log2);
            TreeSitter.ts_parser_set_logger(this.self, segment);
        }
        return this;
    }

    public synchronized Parser setCancellationFlag(CancellationFlag cancellationFlag) {
        TreeSitter.ts_parser_set_cancellation_flag(this.self, cancellationFlag.segment);
        return this;
    }

    public List<Range> getIncludedRanges() {
        return this.includedRanges;
    }

    public Parser setIncludedRanges(List<Range> includedRanges) {
        int size = includedRanges.size();
        if (size > 0) {
            try (Arena arena = Arena.ofConfined();){
                SequenceLayout layout = MemoryLayout.sequenceLayout(size, TSRange.layout());
                MemorySegment ranges = arena.allocate(layout);
                VarHandle startRow = layout.varHandle(MemoryLayout.PathElement.sequenceElement(), MemoryLayout.PathElement.groupElement("start_point"), MemoryLayout.PathElement.groupElement("row"));
                VarHandle startColumn = layout.varHandle(MemoryLayout.PathElement.sequenceElement(), MemoryLayout.PathElement.groupElement("start_point"), MemoryLayout.PathElement.groupElement("column"));
                VarHandle endRow = layout.varHandle(MemoryLayout.PathElement.sequenceElement(), MemoryLayout.PathElement.groupElement("end_point"), MemoryLayout.PathElement.groupElement("row"));
                VarHandle endColumn = layout.varHandle(MemoryLayout.PathElement.sequenceElement(), MemoryLayout.PathElement.groupElement("end_point"), MemoryLayout.PathElement.groupElement("column"));
                VarHandle startByte = layout.varHandle(MemoryLayout.PathElement.sequenceElement(), MemoryLayout.PathElement.groupElement("start_byte"));
                VarHandle endByte = layout.varHandle(MemoryLayout.PathElement.sequenceElement(), MemoryLayout.PathElement.groupElement("end_byte"));
                for (int i = 0; i < size; ++i) {
                    MemorySegment range = includedRanges.get(i).into(arena);
                    MemorySegment startPoint = TSRange.start_point(range);
                    MemorySegment endPoint = TSRange.end_point(range);
                    startByte.set(ranges, 0L, i, TSRange.start_byte(range));
                    endByte.set(ranges, 0L, i, TSRange.end_byte(range));
                    startRow.set(ranges, 0L, i, TSPoint.row(startPoint));
                    startColumn.set(ranges, 0L, i, TSPoint.column(startPoint));
                    endRow.set(ranges, 0L, i, TSPoint.row(endPoint));
                    endColumn.set(ranges, 0L, i, TSPoint.column(endPoint));
                }
                if (!TreeSitter.ts_parser_set_included_ranges(this.self, ranges, size)) {
                    throw new IllegalArgumentException("Included ranges must be in ascending order and must not overlap");
                }
            }
            this.includedRanges = List.copyOf(includedRanges);
        } else {
            TreeSitter.ts_parser_set_included_ranges(this.self, MemorySegment.NULL, 0);
            this.includedRanges = Collections.singletonList(Range.DEFAULT);
        }
        return this;
    }

    public Optional<Tree> parse(String source) throws IllegalStateException {
        return this.parse(source, InputEncoding.UTF_8);
    }

    public Optional<Tree> parse(String source, InputEncoding encoding) throws IllegalStateException {
        return this.parse(source, encoding, null);
    }

    public Optional<Tree> parse(String source, Tree oldTree) throws IllegalStateException {
        return this.parse(source, InputEncoding.UTF_8, oldTree);
    }

    public Optional<Tree> parse(String source, InputEncoding encoding, @Nullable Tree oldTree) throws IllegalStateException {
        if (this.language == null) {
            throw new IllegalStateException("The parser has no language assigned");
        }
        try (Arena alloc = Arena.ofConfined();){
            byte[] bytes = source.getBytes(encoding.charset());
            MemorySegment string = alloc.allocateFrom(TreeSitter.C_CHAR, bytes);
            MemorySegment old = oldTree == null ? MemorySegment.NULL : oldTree.segment();
            MemorySegment tree = TreeSitter.ts_parser_parse_string_encoding(this.self, old, string, bytes.length, encoding.ordinal());
            if (tree.equals(MemorySegment.NULL)) {
                Optional<Tree> optional = Optional.empty();
                return optional;
            }
            Optional<Tree> optional = Optional.of(new Tree(tree, this.language, source));
            return optional;
        }
    }

    public Optional<Tree> parse(ParseCallback callback, InputEncoding encoding) throws IllegalStateException {
        return this.parse(callback, encoding, null);
    }

    public Optional<Tree> parse(ParseCallback callback, InputEncoding encoding, @Nullable Tree oldTree) throws IllegalStateException {
        if (this.language == null) {
            throw new IllegalStateException("The parser has no language assigned");
        }
        MemorySegment input = TSInput.allocate(this.arena);
        TSInput.payload(input, MemorySegment.NULL);
        TSInput.encoding(input, encoding.ordinal());
        MemorySegment read2 = TSInput.read.allocate((payload, index, point, bytes) -> {
            String result = callback.apply(index, Point.from(point));
            if (result == null) {
                bytes.set(TreeSitter.C_INT, 0L, 0);
                return MemorySegment.NULL;
            }
            byte[] buffer = result.getBytes(encoding.charset());
            bytes.set(TreeSitter.C_INT, 0L, buffer.length);
            return this.arena.allocateFrom(TreeSitter.C_CHAR, buffer);
        }, this.arena);
        TSInput.read(input, read2);
        MemorySegment old = oldTree == null ? MemorySegment.NULL : oldTree.segment();
        MemorySegment tree = TreeSitter.ts_parser_parse(this.self, old, input);
        if (tree.equals(MemorySegment.NULL)) {
            return Optional.empty();
        }
        return Optional.of(new Tree(tree, this.language, null));
    }

    public void reset() {
        TreeSitter.ts_parser_reset(this.self);
    }

    @Override
    public void close() throws RuntimeException {
        this.arena.close();
    }

    public String toString() {
        return "Parser{language=%s}".formatted(this.language);
    }

    public static class CancellationFlag {
        private final Arena arena = Arena.ofAuto();
        private final MemorySegment segment = this.arena.allocate(TreeSitter.C_LONG);
        private final AtomicLong value = new AtomicLong();

        public long get() {
            return this.value.get();
        }

        public void set(long value) {
            this.segment.set(TreeSitter.C_LONG, 0L, this.value.updateAndGet(o -> value));
        }
    }
}

