/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TSPoint;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;

public record Point(@Unsigned int row, @Unsigned int column) implements Comparable<Point>
{
    public static final Point MIN = new Point(0, 0);
    public static final Point MAX = new Point(-1, -1);

    static Point from(MemorySegment point) {
        return new Point(TSPoint.row(point), TSPoint.column(point));
    }

    MemorySegment into(SegmentAllocator allocator) {
        MemorySegment point = TSPoint.allocate(allocator);
        TSPoint.row(point, this.row);
        TSPoint.column(point, this.column);
        return point;
    }

    @Override
    public int compareTo(Point other) {
        int rowDiff = Integer.compareUnsigned(this.row, other.row);
        if (rowDiff != 0) {
            return rowDiff;
        }
        return Integer.compareUnsigned(this.column, other.column);
    }

    @Override
    public String toString() {
        return "Point[row=%s, column=%s]".formatted(Integer.toUnsignedString(this.row), Integer.toUnsignedString(this.column));
    }
}

