/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.Language;
import io.github.treesitter.jtreesitter.Node;
import io.github.treesitter.jtreesitter.Point;
import io.github.treesitter.jtreesitter.QueryCapture;
import io.github.treesitter.jtreesitter.QueryError;
import io.github.treesitter.jtreesitter.QueryMatch;
import io.github.treesitter.jtreesitter.QueryPredicate;
import io.github.treesitter.jtreesitter.QueryPredicateArg;
import io.github.treesitter.jtreesitter.Tree;
import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TSNode;
import io.github.treesitter.jtreesitter.internal.TSQueryCapture;
import io.github.treesitter.jtreesitter.internal.TSQueryMatch;
import io.github.treesitter.jtreesitter.internal.TSQueryPredicateStep;
import io.github.treesitter.jtreesitter.internal.TreeSitter;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Query
implements AutoCloseable {
    private final MemorySegment query;
    private final MemorySegment cursor;
    private final Arena arena = Arena.ofShared();
    private final Language language;
    private final String source;
    private final List<String> captureNames;
    private final List<List<QueryPredicate>> predicates;
    private final List<Map<String, Optional<String>>> settings;
    private final List<Map<String, Optional<String>>> positiveAssertions;
    private final List<Map<String, Optional<String>>> negativeAssertions;

    Query(Language language, String source) throws QueryError {
        int i;
        MemorySegment string = this.arena.allocateFrom(source);
        MemorySegment errorOffset = this.arena.allocate(TreeSitter.C_INT);
        MemorySegment errorType = this.arena.allocate(TreeSitter.C_INT);
        MemorySegment query = TreeSitter.ts_query_new(language.segment(), string, source.length(), errorOffset, errorType);
        if (query.equals(MemorySegment.NULL)) {
            String line;
            long end;
            long start = 0L;
            long row = 0L;
            int offset = errorOffset.get(TreeSitter.C_INT, 0L);
            String[] stringArray = source.split("\n");
            int n = stringArray.length;
            for (int j = 0; j < n && (end = start + (long)(line = stringArray[j]).length() + 1L) <= (long)offset; ++j) {
                start = end;
                ++row;
            }
            long column = (long)offset - start;
            long type = errorType.get(TreeSitter.C_INT, 0L);
            if (type == (long)TreeSitter.TSQueryErrorSyntax()) {
                if (offset >= source.length()) {
                    throw new QueryError.Syntax();
                }
                throw new QueryError.Syntax(row, column);
            }
            if (type == (long)TreeSitter.TSQueryErrorCapture()) {
                int index;
                int length = source.length();
                CharSequence suffix = source.subSequence(offset, length);
                for (index = 0; index < length && !Query.invalidPredicateChar(suffix.charAt(index)); ++index) {
                }
                throw new QueryError.Capture(row, column, suffix.subSequence(0, index));
            }
            if (type == (long)TreeSitter.TSQueryErrorNodeType()) {
                int index;
                int length = source.length();
                CharSequence suffix = source.subSequence(offset, length);
                for (index = 0; index < length && !Query.invalidIdentifierChar(suffix.charAt(index)); ++index) {
                }
                throw new QueryError.NodeType(row, column, suffix.subSequence(0, index));
            }
            if (type == (long)TreeSitter.TSQueryErrorField()) {
                int index;
                int length = source.length();
                CharSequence suffix = source.subSequence(offset, length);
                for (index = 0; index < length && !Query.invalidIdentifierChar(suffix.charAt(index)); ++index) {
                }
                throw new QueryError.Field(row, column, suffix.subSequence(0, index));
            }
            if (type == (long)TreeSitter.TSQueryErrorStructure()) {
                throw new QueryError.Structure(row, column);
            }
            throw new IllegalStateException("Unexpected query error");
        }
        this.language = language;
        this.source = source;
        this.query = query.reinterpret(this.arena, TreeSitter::ts_query_delete);
        this.cursor = TreeSitter.ts_query_cursor_new().reinterpret(this.arena, TreeSitter::ts_query_cursor_delete);
        int captureCount = TreeSitter.ts_query_capture_count(this.query);
        this.captureNames = new ArrayList<String>(captureCount);
        try (Arena alloc = Arena.ofConfined();){
            for (int i2 = 0; i2 < captureCount; ++i2) {
                MemorySegment length = alloc.allocate(TreeSitter.C_INT);
                MemorySegment name = TreeSitter.ts_query_capture_name_for_id(query, i2, length);
                if (length.get(TreeSitter.C_INT, 0L) == 0) {
                    throw new IllegalStateException("Failed to get capture name at index %d".formatted(i2));
                }
                this.captureNames.add(name.getString(0L));
            }
        }
        int patternCount = TreeSitter.ts_query_pattern_count(this.query);
        this.predicates = Query.generate(ArrayList::new, patternCount);
        this.settings = Query.generate(HashMap::new, patternCount);
        this.positiveAssertions = Query.generate(HashMap::new, patternCount);
        this.negativeAssertions = Query.generate(HashMap::new, patternCount);
        int stringCount = TreeSitter.ts_query_string_count(this.query);
        ArrayList<String> stringValues = new ArrayList<String>(stringCount);
        try (Arena alloc = Arena.ofConfined();){
            for (i = 0; i < stringCount; ++i) {
                MemorySegment length = alloc.allocate(TreeSitter.C_INT);
                MemorySegment name = TreeSitter.ts_query_string_value_for_id(query, i, length);
                if (length.get(TreeSitter.C_INT, 0L) == 0) {
                    throw new IllegalStateException("Failed to get string value at index %d".formatted(i));
                }
                stringValues.add(name.getString(0L));
            }
        }
        alloc = Arena.ofConfined();
        try {
            for (i = 0; i < patternCount; ++i) {
                MemorySegment count = alloc.allocate(TreeSitter.C_INT);
                MemorySegment tokens = TreeSitter.ts_query_predicates_for_pattern(query, i, count);
                int steps = count.get(TreeSitter.C_INT, 0L);
                if (steps == 0) continue;
                int offset = TreeSitter.ts_query_start_byte_for_pattern(query, i);
                long row = source.chars().limit(offset).filter(c -> c == 10).count();
                long nargs = 0L;
                for (long j = 0L; j < (long)steps; ++j) {
                    MemorySegment t;
                    while (TSQueryPredicateStep.type(t = TSQueryPredicateStep.asSlice(tokens, nargs)) != TreeSitter.TSQueryPredicateStepTypeDone()) {
                        ++nargs;
                    }
                    MemorySegment t0 = TSQueryPredicateStep.asSlice(tokens, 0L);
                    if (TSQueryPredicateStep.type(t0) == TreeSitter.TSQueryPredicateStepTypeCapture()) {
                        String name = this.captureNames.get(TSQueryPredicateStep.value_id(t0));
                        throw new QueryError.Predicate(row, "@%s".formatted(name), new Object[0]);
                    }
                    String predicate = (String)stringValues.get(TSQueryPredicateStep.value_id(t0));
                    if (QueryPredicate.Eq.NAMES.contains(predicate)) {
                        if (nargs != 3L) {
                            error = "#%s expects 2 arguments, got %d";
                            throw new QueryError.Predicate(row, error, predicate, nargs - 1L);
                        }
                        t1 = TSQueryPredicateStep.asSlice(tokens, 1L);
                        if (TSQueryPredicateStep.type(t1) != TreeSitter.TSQueryPredicateStepTypeCapture()) {
                            String value = (String)stringValues.get(TSQueryPredicateStep.value_id(t1));
                            error = "first argument to #%s must be a capture name, got \"%s\"";
                            throw new QueryError.Predicate(row, error, predicate, value);
                        }
                        String capture = this.captureNames.get(TSQueryPredicateStep.value_id(t1));
                        MemorySegment t2 = TSQueryPredicateStep.asSlice(tokens, 2L);
                        int id = TSQueryPredicateStep.value_id(t2);
                        boolean isCapture = TSQueryPredicateStep.type(t2) == TreeSitter.TSQueryPredicateStepTypeCapture();
                        value = isCapture ? this.captureNames.get(id) : (String)stringValues.get(id);
                        this.predicates.get(i).add(new QueryPredicate.Eq(predicate, capture, value, isCapture));
                    } else if (QueryPredicate.Match.NAMES.contains(predicate)) {
                        if (nargs != 3L) {
                            error = "#%s expects 2 arguments, got %d";
                            throw new QueryError.Predicate(row, error, predicate, nargs - 1L);
                        }
                        t1 = TSQueryPredicateStep.asSlice(tokens, 1L);
                        if (TSQueryPredicateStep.type(t1) != TreeSitter.TSQueryPredicateStepTypeCapture()) {
                            String value = (String)stringValues.get(TSQueryPredicateStep.value_id(t1));
                            error = "first argument to #%s must be a capture name, got \"%s\"";
                            throw new QueryError.Predicate(row, error, predicate, value);
                        }
                        MemorySegment t2 = TSQueryPredicateStep.asSlice(tokens, 2L);
                        if (TSQueryPredicateStep.type(t2) != TreeSitter.TSQueryPredicateStepTypeString()) {
                            value = this.captureNames.get(TSQueryPredicateStep.value_id(t2));
                            String error = "second argument to #%s must be a string literal, got @%s";
                            throw new QueryError.Predicate(row, error, predicate, value);
                        }
                        try {
                            capture = this.captureNames.get(TSQueryPredicateStep.value_id(t1));
                            Pattern pattern = Pattern.compile((String)stringValues.get(TSQueryPredicateStep.value_id(t2)));
                            this.predicates.get(i).add(new QueryPredicate.Match(predicate, capture, pattern));
                        }
                        catch (PatternSyntaxException e) {
                            throw new QueryError.Predicate(row, "pattern error", e);
                        }
                    } else if (QueryPredicate.AnyOf.NAMES.contains(predicate)) {
                        if (nargs < 3L) {
                            error = "#%s expects at least 2 arguments, got %d";
                            throw new QueryError.Predicate(row, error, predicate, nargs - 1L);
                        }
                        t1 = TSQueryPredicateStep.asSlice(tokens, 1L);
                        if (TSQueryPredicateStep.type(t1) != TreeSitter.TSQueryPredicateStepTypeCapture()) {
                            String value = (String)stringValues.get(TSQueryPredicateStep.value_id(t1));
                            error = "first argument to #%s must be a capture name, got \"%s\"";
                            throw new QueryError.Predicate(row, error, predicate, value);
                        }
                        ArrayList<String> values = new ArrayList<String>((int)nargs - 2);
                        for (long k = 2L; k < nargs; ++k) {
                            MemorySegment t2 = TSQueryPredicateStep.asSlice(tokens, k);
                            if (TSQueryPredicateStep.type(t2) != TreeSitter.TSQueryPredicateStepTypeString()) {
                                value = this.captureNames.get(TSQueryPredicateStep.value_id(t2));
                                String error = "arguments to #%s must be string literals, got @%s";
                                throw new QueryError.Predicate(row, error, predicate, value);
                            }
                            values.add((String)stringValues.get(TSQueryPredicateStep.value_id(t2)));
                        }
                        capture = this.captureNames.get(TSQueryPredicateStep.value_id(t1));
                        this.predicates.get(i).add(new QueryPredicate.AnyOf(predicate, capture, values));
                    } else if (predicate.equals("is?") || predicate.equals("is-not?") || predicate.equals("set!")) {
                        if (nargs == 1L || nargs > 3L) {
                            error = "#%s expects 1-2 arguments, got %d";
                            throw new QueryError.Predicate(row, error, predicate, nargs - 1L);
                        }
                        t1 = TSQueryPredicateStep.asSlice(tokens, 1L);
                        if (TSQueryPredicateStep.type(t1) != TreeSitter.TSQueryPredicateStepTypeString()) {
                            String value = this.captureNames.get(TSQueryPredicateStep.value_id(t1));
                            error = "first argument to #%s must be a string literal, got @%s";
                            throw new QueryError.Predicate(row, error, predicate, value);
                        }
                        String key = (String)stringValues.get(TSQueryPredicateStep.value_id(t1));
                        value = null;
                        if (nargs == 3L) {
                            MemorySegment t2 = TSQueryPredicateStep.asSlice(tokens, 2L);
                            if (TSQueryPredicateStep.type(t2) != TreeSitter.TSQueryPredicateStepTypeString()) {
                                String capture = this.captureNames.get(TSQueryPredicateStep.value_id(t2));
                                String error = "second argument to #%s must be a string literal, got @%s";
                                throw new QueryError.Predicate(row, error, predicate, capture);
                            }
                            value = (String)stringValues.get(TSQueryPredicateStep.value_id(t2));
                        }
                        if (predicate.equals("is?")) {
                            this.positiveAssertions.get(i).put(key, Optional.ofNullable(value));
                        } else if (predicate.equals("is-not?")) {
                            this.negativeAssertions.get(i).put(key, Optional.ofNullable(value));
                        } else {
                            this.settings.get(i).put(key, Optional.ofNullable(value));
                        }
                    } else {
                        ArrayList<QueryPredicateArg> values = new ArrayList<QueryPredicateArg>((int)nargs - 1);
                        for (long k = 1L; k < nargs; ++k) {
                            MemorySegment t3 = TSQueryPredicateStep.asSlice(tokens, k);
                            if (TSQueryPredicateStep.type(t3) == TreeSitter.TSQueryPredicateStepTypeString()) {
                                String value = (String)stringValues.get(TSQueryPredicateStep.value_id(t3));
                                values.add(new QueryPredicateArg.Literal(value));
                                continue;
                            }
                            String capture = this.captureNames.get(TSQueryPredicateStep.value_id(t3));
                            values.add(new QueryPredicateArg.Capture(capture));
                        }
                        this.predicates.get(i).add(new QueryPredicate(predicate, values));
                    }
                    j += nargs;
                    tokens = TSQueryPredicateStep.asSlice(tokens, nargs);
                }
            }
        }
        finally {
            if (alloc != null) {
                alloc.close();
            }
        }
    }

    private static <T> List<T> generate(Supplier<T> supplier, int limit) {
        return Stream.generate(supplier).limit(limit).toList();
    }

    private static boolean invalidIdentifierChar(char c) {
        return !Character.isLetterOrDigit(c) && c != '_';
    }

    private static boolean invalidPredicateChar(char c) {
        return !Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.' && c != '?' && c != '!';
    }

    @Unsigned
    public int getPatternCount() {
        return TreeSitter.ts_query_pattern_count(this.query);
    }

    @Unsigned
    public int getCaptureCount() {
        return TreeSitter.ts_query_capture_count(this.query);
    }

    @Unsigned
    public int getMatchLimit() {
        return TreeSitter.ts_query_cursor_match_limit(this.cursor);
    }

    public Query setMatchLimit(@Unsigned int matchLimit) throws IllegalArgumentException {
        if (matchLimit == 0) {
            throw new IllegalArgumentException("The match limit cannot equal 0");
        }
        TreeSitter.ts_query_cursor_set_match_limit(this.cursor, matchLimit);
        return this;
    }

    @Unsigned
    public long getTimeoutMicros() {
        return TreeSitter.ts_query_cursor_timeout_micros(this.cursor);
    }

    public Query setTimeoutMicros(@Unsigned long timeoutMicros) {
        TreeSitter.ts_query_cursor_set_timeout_micros(this.cursor, timeoutMicros);
        return this;
    }

    public Query setMaxStartDepth(@Unsigned int maxStartDepth) {
        TreeSitter.ts_query_cursor_set_max_start_depth(this.cursor, maxStartDepth);
        return this;
    }

    public Query setByteRange(@Unsigned int startByte, @Unsigned int endByte) {
        TreeSitter.ts_query_cursor_set_byte_range(this.cursor, startByte, endByte);
        return this;
    }

    public Query setPointRange(Point startPoint, Point endPoint) {
        try (Arena alloc = Arena.ofConfined();){
            MemorySegment start = startPoint.into(alloc);
            MemorySegment end = endPoint.into(alloc);
            TreeSitter.ts_query_cursor_set_point_range(this.cursor, start, end);
        }
        return this;
    }

    public boolean didExceedMatchLimit() {
        return TreeSitter.ts_query_cursor_did_exceed_match_limit(this.cursor);
    }

    public void disablePattern(@Unsigned int index) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        TreeSitter.ts_query_disable_pattern(this.query, index);
    }

    public void disableCapture(String name) throws NoSuchElementException {
        if (!this.captureNames.remove(name)) {
            throw new NoSuchElementException("Capture @%s does not exist".formatted(name));
        }
        try (Arena alloc = Arena.ofConfined();){
            TreeSitter.ts_query_disable_capture(this.query, alloc.allocateFrom(name), name.length());
        }
    }

    @Unsigned
    public int startByteForPattern(@Unsigned int index) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        return TreeSitter.ts_query_start_byte_for_pattern(this.query, index);
    }

    @Unsigned
    public int endByteForPattern(@Unsigned int index) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        return TreeSitter.ts_query_end_byte_for_pattern(this.query, index);
    }

    public boolean isPatternRooted(@Unsigned int index) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        return TreeSitter.ts_query_is_pattern_rooted(this.query, index);
    }

    public boolean isPatternNonLocal(@Unsigned int index) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        return TreeSitter.ts_query_is_pattern_non_local(this.query, index);
    }

    public boolean isPatternGuaranteedAtStep(@Unsigned int offset) throws IndexOutOfBoundsException {
        if (Integer.compareUnsigned(offset, this.source.length()) >= 0) {
            throw new IndexOutOfBoundsException("Byte offset %s exceeds EOF".formatted(Integer.toUnsignedString(offset)));
        }
        return TreeSitter.ts_query_is_pattern_guaranteed_at_step(this.query, offset);
    }

    public Map<String, Optional<String>> getPatternSettings(@Unsigned int index) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        return Collections.unmodifiableMap(this.settings.get(index));
    }

    public Map<String, Optional<String>> getPatternAssertions(@Unsigned int index, boolean positive) throws IndexOutOfBoundsException {
        this.checkIndex(index);
        List<Map<String, Optional<String>>> assertions = positive ? this.positiveAssertions : this.negativeAssertions;
        return Collections.unmodifiableMap(assertions.get(index));
    }

    public Stream<QueryMatch> findMatches(Node node) {
        return this.findMatches(node, null);
    }

    public Stream<QueryMatch> findMatches(Node node, @Nullable BiPredicate<QueryPredicate, QueryMatch> predicate) {
        try (Arena alloc = Arena.ofConfined();){
            TreeSitter.ts_query_cursor_exec(this.cursor, this.query, node.copy(alloc));
        }
        return StreamSupport.stream(new MatchesIterator(node.getTree(), predicate), false);
    }

    @Override
    public void close() throws RuntimeException {
        this.arena.close();
    }

    public String toString() {
        return "Query{language=%s, source=%s}".formatted(this.language, this.source);
    }

    private boolean matches(@Nullable BiPredicate<QueryPredicate, QueryMatch> predicate, QueryMatch match) {
        return this.predicates.get(match.patternIndex()).stream().allMatch(p -> {
            if (p.getClass() != QueryPredicate.class) {
                return p.test(match);
            }
            return predicate == null || predicate.test((QueryPredicate)p, match);
        });
    }

    private void checkIndex(@Unsigned int index) throws IndexOutOfBoundsException {
        if (Integer.compareUnsigned(index, this.getPatternCount()) >= 0) {
            throw new IndexOutOfBoundsException("Pattern index %s is out of bounds".formatted(Integer.toUnsignedString(index)));
        }
    }

    private final class MatchesIterator
    extends Spliterators.AbstractSpliterator<QueryMatch> {
        private final @Nullable BiPredicate<QueryPredicate, QueryMatch> predicate;
        private final Tree tree;

        public MatchesIterator(@Nullable Tree tree, BiPredicate<QueryPredicate, QueryMatch> predicate) {
            super(Long.MAX_VALUE, 1280);
            this.predicate = predicate;
            this.tree = tree;
        }

        @Override
        public boolean tryAdvance(Consumer<? super QueryMatch> action) {
            boolean hasNoText = this.tree.getText() == null;
            MemorySegment match = Query.this.arena.allocate(TSQueryMatch.layout());
            while (TreeSitter.ts_query_cursor_next_match(Query.this.cursor, match)) {
                int count = Short.toUnsignedInt(TSQueryMatch.capture_count(match));
                MemorySegment matchCaptures = TSQueryMatch.captures(match);
                ArrayList<QueryCapture> captureList = new ArrayList<QueryCapture>(count);
                for (int i = 0; i < count; ++i) {
                    MemorySegment capture = TSQueryCapture.asSlice(matchCaptures, i);
                    String name = Query.this.captureNames.get(TSQueryCapture.index(capture));
                    MemorySegment node = TSNode.allocate(Query.this.arena).copyFrom(TSQueryCapture.node(capture));
                    captureList.add(new QueryCapture(name, new Node(node, this.tree)));
                }
                short patternIndex = TSQueryMatch.pattern_index(match);
                QueryMatch result = new QueryMatch(patternIndex, captureList);
                if (!hasNoText && !Query.this.matches(this.predicate, result)) continue;
                action.accept(result);
                return true;
            }
            return false;
        }
    }
}

