/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.Node;
import io.github.treesitter.jtreesitter.QueryMatch;
import io.github.treesitter.jtreesitter.QueryPredicateArg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed class QueryPredicate {
    private final String name;
    protected final List<QueryPredicateArg> args;

    protected QueryPredicate(String name, int argc) {
        this(name, new ArrayList<QueryPredicateArg>(argc));
    }

    QueryPredicate(String name, List<QueryPredicateArg> args) {
        this.name = name;
        this.args = args;
    }

    public String getName() {
        return this.name;
    }

    public List<QueryPredicateArg> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    boolean test(QueryMatch queryMatch) {
        return true;
    }

    public String toString() {
        return "QueryPredicate{name=%s, args=%s}".formatted(this.name, this.args);
    }

    @NullMarked
    public static final class AnyOf
    extends QueryPredicate {
        private final String capture;
        private final List<String> values;
        private final boolean isPositive;
        static final Set<String> NAMES = Set.of("any-of?", "not-any-of?");

        AnyOf(String name, String capture, List<String> values) {
            super(name, values.size() + 1);
            this.capture = capture;
            this.values = List.copyOf(values);
            this.isPositive = name.equals("any-of?");
            this.args.add(new QueryPredicateArg.Capture(capture));
            for (String value : this.values) {
                this.args.add(new QueryPredicateArg.Literal(value));
            }
        }

        @Override
        boolean test(QueryMatch match) {
            return match.findNodes(this.capture).stream().noneMatch(node -> {
                String text = Objects.requireNonNull(node.getText());
                return this.values.contains(text) != this.isPositive;
            });
        }
    }

    @NullMarked
    public static final class Match
    extends QueryPredicate {
        private final String capture;
        private final Pattern pattern;
        private final boolean isPositive;
        private final boolean isAny;
        static final Set<String> NAMES = Set.of("match?", "not-match?", "any-match?", "any-not-match?");

        Match(String name, String capture, Pattern pattern) {
            super(name, 2);
            this.capture = capture;
            this.pattern = pattern;
            this.isPositive = !name.contains("not-");
            this.isAny = name.startsWith("any-");
            this.args.add(new QueryPredicateArg.Capture(capture));
            this.args.add(new QueryPredicateArg.Literal(pattern.pattern()));
        }

        @Override
        boolean test(QueryMatch match) {
            List<Node> findNodes1 = match.findNodes(this.capture);
            if (findNodes1.isEmpty()) {
                return !this.isPositive;
            }
            Predicate<Node> predicate = node -> {
                String text = Objects.requireNonNull(node.getText());
                return this.pattern.matcher(text).hasMatch() == this.isPositive;
            };
            if (!this.isAny) {
                return findNodes1.stream().allMatch(predicate);
            }
            return findNodes1.stream().anyMatch(predicate);
        }
    }

    @NullMarked
    public static final class Eq
    extends QueryPredicate {
        private final String capture;
        private final String value;
        private final boolean isPositive;
        private final boolean isAny;
        private final boolean isCapture;
        static final Set<String> NAMES = Set.of("eq?", "not-eq?", "any-eq?", "any-not-eq?");

        Eq(String name, String capture, String value, boolean isCapture) {
            super(name, 2);
            this.capture = capture;
            this.value = value;
            this.isPositive = !name.contains("not-");
            this.isAny = name.startsWith("any-");
            this.isCapture = isCapture;
            this.args.add(new QueryPredicateArg.Capture(capture));
            if (isCapture) {
                this.args.add(new QueryPredicateArg.Capture(value));
            } else {
                this.args.add(new QueryPredicateArg.Literal(value));
            }
        }

        @Override
        boolean test(QueryMatch match) {
            return this.isCapture ? this.testCapture(match) : this.testLiteral(match);
        }

        private boolean testCapture(QueryMatch match) {
            Stream findNodes1 = match.findNodes(this.capture).stream();
            Stream findNodes2 = match.findNodes(this.value).stream();
            Predicate<Node> predicate = n1 -> findNodes2.anyMatch(n2 -> Objects.equals(n1.getText(), n2.getText()) == this.isPositive);
            return this.isAny ? findNodes1.anyMatch(predicate) : findNodes1.allMatch(predicate);
        }

        private boolean testLiteral(QueryMatch match) {
            List<Node> findNodes1 = match.findNodes(this.capture);
            if (findNodes1.isEmpty()) {
                return !this.isPositive;
            }
            Predicate<Node> predicate = node -> {
                String text = Objects.requireNonNull(node.getText());
                return this.value.equals(text) == this.isPositive;
            };
            if (!this.isAny) {
                return findNodes1.stream().allMatch(predicate);
            }
            return findNodes1.stream().anyMatch(predicate);
        }
    }
}

