/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.Point;
import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TSRange;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record Range(Point startPoint, Point endPoint, @Unsigned int startByte, @Unsigned int endByte) {
    static final Range DEFAULT = new Range(Point.MIN, Point.MAX, 0, -1);

    public Range {
        if (startPoint.compareTo(endPoint) > 0) {
            throw new IllegalArgumentException("Invalid point range: %s to %s".formatted(startPoint, endPoint));
        }
        if (Integer.compareUnsigned(startByte, endByte) > 0) {
            throw new IllegalArgumentException(String.format("Invalid byte range: %s to %s", Integer.toUnsignedString(startByte), Integer.toUnsignedString(endByte)));
        }
    }

    static Range from(MemorySegment range) {
        int endByte = TSRange.end_byte(range);
        int startByte = TSRange.start_byte(range);
        MemorySegment startPoint = TSRange.start_point(range);
        MemorySegment endPoint = TSRange.end_point(range);
        return new Range(Point.from(startPoint), Point.from(endPoint), startByte, endByte);
    }

    MemorySegment into(SegmentAllocator allocator) {
        MemorySegment range = TSRange.allocate(allocator);
        TSRange.start_byte(range, this.startByte);
        TSRange.end_byte(range, this.endByte);
        TSRange.start_point(range, this.startPoint.into(allocator));
        TSRange.end_point(range, this.endPoint.into(allocator));
        return range;
    }

    @Override
    public String toString() {
        return String.format("Range[startPoint=%s, endPoint=%s, startByte=%s, endByte=%s]", this.startPoint, this.endPoint, Integer.toUnsignedString(this.startByte), Integer.toUnsignedString(this.endByte));
    }
}

