/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.InputEdit;
import io.github.treesitter.jtreesitter.Language;
import io.github.treesitter.jtreesitter.Node;
import io.github.treesitter.jtreesitter.Point;
import io.github.treesitter.jtreesitter.Range;
import io.github.treesitter.jtreesitter.TreeCursor;
import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TSRange;
import io.github.treesitter.jtreesitter.internal.TreeSitter;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Tree
implements AutoCloseable,
Cloneable {
    private final MemorySegment self;
    private @Nullable String source;
    private final Arena arena;
    private final Language language;
    private @Nullable List<Range> includedRanges;

    Tree(MemorySegment self, Language language, @Nullable String source) {
        this.arena = Arena.ofConfined();
        this.self = self.reinterpret(this.arena, TreeSitter::ts_tree_delete);
        this.language = language;
        this.source = source;
    }

    private Tree(Tree tree) {
        MemorySegment copy = TreeSitter.ts_tree_copy(tree.self);
        this.arena = Arena.ofConfined();
        this.self = copy.reinterpret(this.arena, TreeSitter::ts_tree_delete);
        this.language = tree.language;
        this.source = tree.source;
        this.includedRanges = tree.includedRanges;
    }

    MemorySegment segment() {
        return this.self;
    }

    public Language getLanguage() {
        return this.language;
    }

    public @Nullable String getText() {
        return this.source;
    }

    public Node getRootNode() {
        return new Node(TreeSitter.ts_tree_root_node(this.arena, this.self), this);
    }

    public @Nullable Node getRootNodeWithOffset(@Unsigned int bytes, Point extent) {
        try (Arena alloc = Arena.ofConfined();){
            MemorySegment offsetExtent = extent.into(alloc);
            MemorySegment node = TreeSitter.ts_tree_root_node_with_offset(this.arena, this.self, bytes, offsetExtent);
            if (TreeSitter.ts_node_is_null(node)) {
                Node node2 = null;
                return node2;
            }
            Node node3 = new Node(node, this);
            return node3;
        }
    }

    public List<Range> getIncludedRanges() {
        if (this.includedRanges == null) {
            try (Arena alloc = Arena.ofConfined();){
                MemorySegment length = alloc.allocate(TreeSitter.C_INT.byteSize(), TreeSitter.C_INT.byteAlignment());
                MemorySegment ranges = TreeSitter.ts_tree_included_ranges(this.self, length);
                int size = length.get(TreeSitter.C_INT, 0L);
                if (size == 0) {
                    List<Range> list = Collections.emptyList();
                    return list;
                }
                this.includedRanges = new ArrayList<Range>(size);
                for (int i = 0; i < size; ++i) {
                    MemorySegment range = TSRange.asSlice(ranges, i);
                    this.includedRanges.add(Range.from(range));
                }
                TreeSitter.free(ranges);
            }
        }
        return Collections.unmodifiableList(this.includedRanges);
    }

    public List<Range> getChangedRanges(Tree newTree) {
        try (Arena alloc = Arena.ofConfined();){
            MemorySegment length = alloc.allocate(TreeSitter.C_INT.byteSize(), TreeSitter.C_INT.byteAlignment());
            MemorySegment ranges = TreeSitter.ts_tree_get_changed_ranges(this.self, newTree.self, length);
            int size = length.get(TreeSitter.C_INT, 0L);
            if (size == 0) {
                List<Range> list = Collections.emptyList();
                return list;
            }
            ArrayList<Range> changedRanges = new ArrayList<Range>(size);
            for (int i = 0; i < size; ++i) {
                MemorySegment range = TSRange.asSlice(ranges, i);
                changedRanges.add(Range.from(range));
            }
            TreeSitter.free(ranges);
            ArrayList<Range> arrayList = changedRanges;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edit(InputEdit edit) {
        try (Arena alloc = Arena.ofConfined();){
            TreeSitter.ts_tree_edit(this.self, edit.into(alloc));
        }
        finally {
            this.source = null;
        }
    }

    public TreeCursor walk() {
        return new TreeCursor(this);
    }

    public Tree clone() {
        return new Tree(this);
    }

    @Override
    public void close() throws RuntimeException {
        this.arena.close();
    }

    public String toString() {
        return "Tree{language=%s, source=%s}".formatted(this.language, this.source);
    }
}

