/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter;

import io.github.treesitter.jtreesitter.Node;
import io.github.treesitter.jtreesitter.Point;
import io.github.treesitter.jtreesitter.Tree;
import io.github.treesitter.jtreesitter.Unsigned;
import io.github.treesitter.jtreesitter.internal.TreeSitter;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.OptionalInt;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class TreeCursor
implements AutoCloseable,
Cloneable {
    private final MemorySegment self;
    private final Arena arena = Arena.ofConfined();
    private final Tree tree;
    private @Nullable Node node;

    TreeCursor(Node node, Tree tree) {
        this.self = TreeSitter.ts_tree_cursor_new(this.arena, node.copy(this.arena));
        this.tree = tree;
    }

    TreeCursor(Tree tree) {
        MemorySegment node = TreeSitter.ts_tree_root_node(this.arena, tree.segment());
        this.self = TreeSitter.ts_tree_cursor_new(this.arena, node);
        this.tree = tree;
    }

    private TreeCursor(TreeCursor cursor) {
        this.self = TreeSitter.ts_tree_cursor_copy(this.arena, cursor.self);
        this.tree = cursor.tree.clone();
        this.node = cursor.node;
    }

    public Node getCurrentNode() {
        if (this.node == null) {
            MemorySegment node = TreeSitter.ts_tree_cursor_current_node(this.arena, this.self);
            this.node = new Node(node, this.tree);
        }
        return this.node;
    }

    @Unsigned
    public int getCurrentDepth() {
        return TreeSitter.ts_tree_cursor_current_depth(this.self);
    }

    @Unsigned
    public short getCurrentFieldId() {
        return TreeSitter.ts_tree_cursor_current_field_id(this.self);
    }

    public @Nullable String getCurrentFieldName() {
        MemorySegment segment = TreeSitter.ts_tree_cursor_current_field_name(this.self);
        return segment.equals(MemorySegment.NULL) ? null : segment.getString(0L);
    }

    @Unsigned
    public int getCurrentDescendantIndex() {
        return TreeSitter.ts_tree_cursor_current_descendant_index(this.self);
    }

    public boolean gotoFirstChild() {
        boolean result = TreeSitter.ts_tree_cursor_goto_first_child(this.self);
        if (result) {
            this.node = null;
        }
        return result;
    }

    public boolean gotoLastChild() {
        boolean result = TreeSitter.ts_tree_cursor_goto_last_child(this.self);
        if (result) {
            this.node = null;
        }
        return result;
    }

    public boolean gotoParent() {
        boolean result = TreeSitter.ts_tree_cursor_goto_parent(this.self);
        if (result) {
            this.node = null;
        }
        return result;
    }

    public boolean gotoNextSibling() {
        boolean result = TreeSitter.ts_tree_cursor_goto_next_sibling(this.self);
        if (result) {
            this.node = null;
        }
        return result;
    }

    public boolean gotoPreviousSibling() {
        boolean result = TreeSitter.ts_tree_cursor_goto_previous_sibling(this.self);
        if (result) {
            this.node = null;
        }
        return result;
    }

    public void gotoDescendant(@Unsigned int index) {
        TreeSitter.ts_tree_cursor_goto_descendant(this.self, index);
        this.node = null;
    }

    @Unsigned
    public OptionalInt gotoFirstChildForByte(@Unsigned int offset) {
        long index = TreeSitter.ts_tree_cursor_goto_first_child_for_byte(this.self, offset);
        if (index == -1L) {
            return OptionalInt.empty();
        }
        this.node = null;
        return OptionalInt.of((int)index);
    }

    @Unsigned
    public OptionalInt gotoFirstChildForPoint(Point point) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment goal = point.into(arena);
            long index = TreeSitter.ts_tree_cursor_goto_first_child_for_point(this.self, goal);
            if (index == -1L) {
                OptionalInt optionalInt = OptionalInt.empty();
                return optionalInt;
            }
            this.node = null;
            OptionalInt optionalInt = OptionalInt.of((int)index);
            return optionalInt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Node node) {
        try (Arena arena = Arena.ofConfined();){
            TreeSitter.ts_tree_cursor_reset(this.self, node.copy(arena));
        }
        finally {
            this.node = null;
        }
    }

    public void reset(TreeCursor cursor) {
        TreeSitter.ts_tree_cursor_reset_to(this.self, cursor.self);
        this.node = null;
    }

    public TreeCursor clone() {
        return new TreeCursor(this);
    }

    @Override
    public void close() throws RuntimeException {
        TreeSitter.ts_tree_cursor_delete(this.self);
        this.arena.close();
    }

    public String toString() {
        return "TreeCursor{tree=%s}".formatted(this.tree);
    }
}

