/*
 * Decompiled with CFR 0.152.
 */
package io.github.treesitter.jtreesitter.internal;

import io.github.treesitter.jtreesitter.internal.TSInput;
import io.github.treesitter.jtreesitter.internal.TSLogger;
import io.github.treesitter.jtreesitter.internal.TSNode;
import io.github.treesitter.jtreesitter.internal.TSPoint;
import io.github.treesitter.jtreesitter.internal.TSTreeCursor;
import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class TreeSitter {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup(System.mapLibraryName("tree-sitter"), LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfLong C_LONG = ValueLayout.JAVA_LONG;
    private static final int TREE_SITTER_LANGUAGE_VERSION = 14;
    private static final int TREE_SITTER_MIN_COMPATIBLE_LANGUAGE_VERSION = 13;
    private static final int TSInputEncodingUTF8 = 0;
    private static final int TSInputEncodingUTF16 = 1;
    private static final int TSSymbolTypeRegular = 0;
    private static final int TSSymbolTypeAnonymous = 1;
    private static final int TSSymbolTypeAuxiliary = 2;
    private static final int TSLogTypeParse = 0;
    private static final int TSLogTypeLex = 1;
    private static final int TSQuantifierZero = 0;
    private static final int TSQuantifierZeroOrOne = 1;
    private static final int TSQuantifierZeroOrMore = 2;
    private static final int TSQuantifierOne = 3;
    private static final int TSQuantifierOneOrMore = 4;
    private static final int TSQueryPredicateStepTypeDone = 0;
    private static final int TSQueryPredicateStepTypeCapture = 1;
    private static final int TSQueryPredicateStepTypeString = 2;
    private static final int TSQueryErrorNone = 0;
    private static final int TSQueryErrorSyntax = 1;
    private static final int TSQueryErrorNodeType = 2;
    private static final int TSQueryErrorField = 3;
    private static final int TSQueryErrorCapture = 4;
    private static final int TSQueryErrorStructure = 5;
    private static final int TSQueryErrorLanguage = 6;

    TreeSitter() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> TreeSitter.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), TreeSitter.align(s.elementLayout(), align));
            }
        };
    }

    public static int TREE_SITTER_LANGUAGE_VERSION() {
        return 14;
    }

    public static int TREE_SITTER_MIN_COMPATIBLE_LANGUAGE_VERSION() {
        return 13;
    }

    public static FunctionDescriptor free$descriptor() {
        return free.DESC;
    }

    public static MethodHandle free$handle() {
        return free.HANDLE;
    }

    public static MemorySegment free$address() {
        return free.ADDR;
    }

    public static void free(MemorySegment __ptr) {
        MethodHandle mh$ = free.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("free", __ptr);
            }
            mh$.invokeExact(__ptr);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int TSInputEncodingUTF8() {
        return 0;
    }

    public static int TSInputEncodingUTF16() {
        return 1;
    }

    public static int TSSymbolTypeRegular() {
        return 0;
    }

    public static int TSSymbolTypeAnonymous() {
        return 1;
    }

    public static int TSSymbolTypeAuxiliary() {
        return 2;
    }

    public static int TSLogTypeParse() {
        return 0;
    }

    public static int TSLogTypeLex() {
        return 1;
    }

    public static int TSQuantifierZero() {
        return 0;
    }

    public static int TSQuantifierZeroOrOne() {
        return 1;
    }

    public static int TSQuantifierZeroOrMore() {
        return 2;
    }

    public static int TSQuantifierOne() {
        return 3;
    }

    public static int TSQuantifierOneOrMore() {
        return 4;
    }

    public static int TSQueryPredicateStepTypeDone() {
        return 0;
    }

    public static int TSQueryPredicateStepTypeCapture() {
        return 1;
    }

    public static int TSQueryPredicateStepTypeString() {
        return 2;
    }

    public static int TSQueryErrorNone() {
        return 0;
    }

    public static int TSQueryErrorSyntax() {
        return 1;
    }

    public static int TSQueryErrorNodeType() {
        return 2;
    }

    public static int TSQueryErrorField() {
        return 3;
    }

    public static int TSQueryErrorCapture() {
        return 4;
    }

    public static int TSQueryErrorStructure() {
        return 5;
    }

    public static int TSQueryErrorLanguage() {
        return 6;
    }

    public static FunctionDescriptor ts_parser_new$descriptor() {
        return ts_parser_new.DESC;
    }

    public static MethodHandle ts_parser_new$handle() {
        return ts_parser_new.HANDLE;
    }

    public static MemorySegment ts_parser_new$address() {
        return ts_parser_new.ADDR;
    }

    public static MemorySegment ts_parser_new() {
        MethodHandle mh$ = ts_parser_new.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_new", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_delete$descriptor() {
        return ts_parser_delete.DESC;
    }

    public static MethodHandle ts_parser_delete$handle() {
        return ts_parser_delete.HANDLE;
    }

    public static MemorySegment ts_parser_delete$address() {
        return ts_parser_delete.ADDR;
    }

    public static void ts_parser_delete(MemorySegment self) {
        MethodHandle mh$ = ts_parser_delete.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_delete", self);
            }
            mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_language$descriptor() {
        return ts_parser_language.DESC;
    }

    public static MethodHandle ts_parser_language$handle() {
        return ts_parser_language.HANDLE;
    }

    public static MemorySegment ts_parser_language$address() {
        return ts_parser_language.ADDR;
    }

    public static MemorySegment ts_parser_language(MemorySegment self) {
        MethodHandle mh$ = ts_parser_language.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_language", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_set_language$descriptor() {
        return ts_parser_set_language.DESC;
    }

    public static MethodHandle ts_parser_set_language$handle() {
        return ts_parser_set_language.HANDLE;
    }

    public static MemorySegment ts_parser_set_language$address() {
        return ts_parser_set_language.ADDR;
    }

    public static boolean ts_parser_set_language(MemorySegment self, MemorySegment language) {
        MethodHandle mh$ = ts_parser_set_language.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_set_language", self, language);
            }
            return mh$.invokeExact(self, language);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_set_included_ranges$descriptor() {
        return ts_parser_set_included_ranges.DESC;
    }

    public static MethodHandle ts_parser_set_included_ranges$handle() {
        return ts_parser_set_included_ranges.HANDLE;
    }

    public static MemorySegment ts_parser_set_included_ranges$address() {
        return ts_parser_set_included_ranges.ADDR;
    }

    public static boolean ts_parser_set_included_ranges(MemorySegment self, MemorySegment ranges, int count) {
        MethodHandle mh$ = ts_parser_set_included_ranges.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_set_included_ranges", self, ranges, count);
            }
            return mh$.invokeExact(self, ranges, count);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_included_ranges$descriptor() {
        return ts_parser_included_ranges.DESC;
    }

    public static MethodHandle ts_parser_included_ranges$handle() {
        return ts_parser_included_ranges.HANDLE;
    }

    public static MemorySegment ts_parser_included_ranges$address() {
        return ts_parser_included_ranges.ADDR;
    }

    public static MemorySegment ts_parser_included_ranges(MemorySegment self, MemorySegment count) {
        MethodHandle mh$ = ts_parser_included_ranges.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_included_ranges", self, count);
            }
            return mh$.invokeExact(self, count);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_parse$descriptor() {
        return ts_parser_parse.DESC;
    }

    public static MethodHandle ts_parser_parse$handle() {
        return ts_parser_parse.HANDLE;
    }

    public static MemorySegment ts_parser_parse$address() {
        return ts_parser_parse.ADDR;
    }

    public static MemorySegment ts_parser_parse(MemorySegment self, MemorySegment old_tree, MemorySegment input) {
        MethodHandle mh$ = ts_parser_parse.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_parse", self, old_tree, input);
            }
            return mh$.invokeExact(self, old_tree, input);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_parse_string$descriptor() {
        return ts_parser_parse_string.DESC;
    }

    public static MethodHandle ts_parser_parse_string$handle() {
        return ts_parser_parse_string.HANDLE;
    }

    public static MemorySegment ts_parser_parse_string$address() {
        return ts_parser_parse_string.ADDR;
    }

    public static MemorySegment ts_parser_parse_string(MemorySegment self, MemorySegment old_tree, MemorySegment string, int length) {
        MethodHandle mh$ = ts_parser_parse_string.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_parse_string", self, old_tree, string, length);
            }
            return mh$.invokeExact(self, old_tree, string, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_parse_string_encoding$descriptor() {
        return ts_parser_parse_string_encoding.DESC;
    }

    public static MethodHandle ts_parser_parse_string_encoding$handle() {
        return ts_parser_parse_string_encoding.HANDLE;
    }

    public static MemorySegment ts_parser_parse_string_encoding$address() {
        return ts_parser_parse_string_encoding.ADDR;
    }

    public static MemorySegment ts_parser_parse_string_encoding(MemorySegment self, MemorySegment old_tree, MemorySegment string, int length, int encoding) {
        MethodHandle mh$ = ts_parser_parse_string_encoding.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_parse_string_encoding", self, old_tree, string, length, encoding);
            }
            return mh$.invokeExact(self, old_tree, string, length, encoding);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_reset$descriptor() {
        return ts_parser_reset.DESC;
    }

    public static MethodHandle ts_parser_reset$handle() {
        return ts_parser_reset.HANDLE;
    }

    public static MemorySegment ts_parser_reset$address() {
        return ts_parser_reset.ADDR;
    }

    public static void ts_parser_reset(MemorySegment self) {
        MethodHandle mh$ = ts_parser_reset.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_reset", self);
            }
            mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_set_timeout_micros$descriptor() {
        return ts_parser_set_timeout_micros.DESC;
    }

    public static MethodHandle ts_parser_set_timeout_micros$handle() {
        return ts_parser_set_timeout_micros.HANDLE;
    }

    public static MemorySegment ts_parser_set_timeout_micros$address() {
        return ts_parser_set_timeout_micros.ADDR;
    }

    public static void ts_parser_set_timeout_micros(MemorySegment self, long timeout_micros) {
        MethodHandle mh$ = ts_parser_set_timeout_micros.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_set_timeout_micros", self, timeout_micros);
            }
            mh$.invokeExact(self, timeout_micros);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_timeout_micros$descriptor() {
        return ts_parser_timeout_micros.DESC;
    }

    public static MethodHandle ts_parser_timeout_micros$handle() {
        return ts_parser_timeout_micros.HANDLE;
    }

    public static MemorySegment ts_parser_timeout_micros$address() {
        return ts_parser_timeout_micros.ADDR;
    }

    public static long ts_parser_timeout_micros(MemorySegment self) {
        MethodHandle mh$ = ts_parser_timeout_micros.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_timeout_micros", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_set_cancellation_flag$descriptor() {
        return ts_parser_set_cancellation_flag.DESC;
    }

    public static MethodHandle ts_parser_set_cancellation_flag$handle() {
        return ts_parser_set_cancellation_flag.HANDLE;
    }

    public static MemorySegment ts_parser_set_cancellation_flag$address() {
        return ts_parser_set_cancellation_flag.ADDR;
    }

    public static void ts_parser_set_cancellation_flag(MemorySegment self, MemorySegment flag) {
        MethodHandle mh$ = ts_parser_set_cancellation_flag.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_set_cancellation_flag", self, flag);
            }
            mh$.invokeExact(self, flag);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_cancellation_flag$descriptor() {
        return ts_parser_cancellation_flag.DESC;
    }

    public static MethodHandle ts_parser_cancellation_flag$handle() {
        return ts_parser_cancellation_flag.HANDLE;
    }

    public static MemorySegment ts_parser_cancellation_flag$address() {
        return ts_parser_cancellation_flag.ADDR;
    }

    public static MemorySegment ts_parser_cancellation_flag(MemorySegment self) {
        MethodHandle mh$ = ts_parser_cancellation_flag.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_cancellation_flag", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_set_logger$descriptor() {
        return ts_parser_set_logger.DESC;
    }

    public static MethodHandle ts_parser_set_logger$handle() {
        return ts_parser_set_logger.HANDLE;
    }

    public static MemorySegment ts_parser_set_logger$address() {
        return ts_parser_set_logger.ADDR;
    }

    public static void ts_parser_set_logger(MemorySegment self, MemorySegment logger) {
        MethodHandle mh$ = ts_parser_set_logger.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_set_logger", self, logger);
            }
            mh$.invokeExact(self, logger);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_logger$descriptor() {
        return ts_parser_logger.DESC;
    }

    public static MethodHandle ts_parser_logger$handle() {
        return ts_parser_logger.HANDLE;
    }

    public static MemorySegment ts_parser_logger$address() {
        return ts_parser_logger.ADDR;
    }

    public static MemorySegment ts_parser_logger(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_parser_logger.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_logger", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_parser_print_dot_graphs$descriptor() {
        return ts_parser_print_dot_graphs.DESC;
    }

    public static MethodHandle ts_parser_print_dot_graphs$handle() {
        return ts_parser_print_dot_graphs.HANDLE;
    }

    public static MemorySegment ts_parser_print_dot_graphs$address() {
        return ts_parser_print_dot_graphs.ADDR;
    }

    public static void ts_parser_print_dot_graphs(MemorySegment self, int fd) {
        MethodHandle mh$ = ts_parser_print_dot_graphs.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_parser_print_dot_graphs", self, fd);
            }
            mh$.invokeExact(self, fd);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_copy$descriptor() {
        return ts_tree_copy.DESC;
    }

    public static MethodHandle ts_tree_copy$handle() {
        return ts_tree_copy.HANDLE;
    }

    public static MemorySegment ts_tree_copy$address() {
        return ts_tree_copy.ADDR;
    }

    public static MemorySegment ts_tree_copy(MemorySegment self) {
        MethodHandle mh$ = ts_tree_copy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_copy", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_delete$descriptor() {
        return ts_tree_delete.DESC;
    }

    public static MethodHandle ts_tree_delete$handle() {
        return ts_tree_delete.HANDLE;
    }

    public static MemorySegment ts_tree_delete$address() {
        return ts_tree_delete.ADDR;
    }

    public static void ts_tree_delete(MemorySegment self) {
        MethodHandle mh$ = ts_tree_delete.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_delete", self);
            }
            mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_root_node$descriptor() {
        return ts_tree_root_node.DESC;
    }

    public static MethodHandle ts_tree_root_node$handle() {
        return ts_tree_root_node.HANDLE;
    }

    public static MemorySegment ts_tree_root_node$address() {
        return ts_tree_root_node.ADDR;
    }

    public static MemorySegment ts_tree_root_node(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_tree_root_node.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_root_node", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_root_node_with_offset$descriptor() {
        return ts_tree_root_node_with_offset.DESC;
    }

    public static MethodHandle ts_tree_root_node_with_offset$handle() {
        return ts_tree_root_node_with_offset.HANDLE;
    }

    public static MemorySegment ts_tree_root_node_with_offset$address() {
        return ts_tree_root_node_with_offset.ADDR;
    }

    public static MemorySegment ts_tree_root_node_with_offset(SegmentAllocator allocator, MemorySegment self, int offset_bytes, MemorySegment offset_extent) {
        MethodHandle mh$ = ts_tree_root_node_with_offset.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_root_node_with_offset", allocator, self, offset_bytes, offset_extent);
            }
            return mh$.invokeExact(allocator, self, offset_bytes, offset_extent);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_language$descriptor() {
        return ts_tree_language.DESC;
    }

    public static MethodHandle ts_tree_language$handle() {
        return ts_tree_language.HANDLE;
    }

    public static MemorySegment ts_tree_language$address() {
        return ts_tree_language.ADDR;
    }

    public static MemorySegment ts_tree_language(MemorySegment self) {
        MethodHandle mh$ = ts_tree_language.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_language", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_included_ranges$descriptor() {
        return ts_tree_included_ranges.DESC;
    }

    public static MethodHandle ts_tree_included_ranges$handle() {
        return ts_tree_included_ranges.HANDLE;
    }

    public static MemorySegment ts_tree_included_ranges$address() {
        return ts_tree_included_ranges.ADDR;
    }

    public static MemorySegment ts_tree_included_ranges(MemorySegment self, MemorySegment length) {
        MethodHandle mh$ = ts_tree_included_ranges.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_included_ranges", self, length);
            }
            return mh$.invokeExact(self, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_edit$descriptor() {
        return ts_tree_edit.DESC;
    }

    public static MethodHandle ts_tree_edit$handle() {
        return ts_tree_edit.HANDLE;
    }

    public static MemorySegment ts_tree_edit$address() {
        return ts_tree_edit.ADDR;
    }

    public static void ts_tree_edit(MemorySegment self, MemorySegment edit) {
        MethodHandle mh$ = ts_tree_edit.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_edit", self, edit);
            }
            mh$.invokeExact(self, edit);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_get_changed_ranges$descriptor() {
        return ts_tree_get_changed_ranges.DESC;
    }

    public static MethodHandle ts_tree_get_changed_ranges$handle() {
        return ts_tree_get_changed_ranges.HANDLE;
    }

    public static MemorySegment ts_tree_get_changed_ranges$address() {
        return ts_tree_get_changed_ranges.ADDR;
    }

    public static MemorySegment ts_tree_get_changed_ranges(MemorySegment old_tree, MemorySegment new_tree, MemorySegment length) {
        MethodHandle mh$ = ts_tree_get_changed_ranges.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_get_changed_ranges", old_tree, new_tree, length);
            }
            return mh$.invokeExact(old_tree, new_tree, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_print_dot_graph$descriptor() {
        return ts_tree_print_dot_graph.DESC;
    }

    public static MethodHandle ts_tree_print_dot_graph$handle() {
        return ts_tree_print_dot_graph.HANDLE;
    }

    public static MemorySegment ts_tree_print_dot_graph$address() {
        return ts_tree_print_dot_graph.ADDR;
    }

    public static void ts_tree_print_dot_graph(MemorySegment self, int file_descriptor) {
        MethodHandle mh$ = ts_tree_print_dot_graph.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_print_dot_graph", self, file_descriptor);
            }
            mh$.invokeExact(self, file_descriptor);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_type$descriptor() {
        return ts_node_type.DESC;
    }

    public static MethodHandle ts_node_type$handle() {
        return ts_node_type.HANDLE;
    }

    public static MemorySegment ts_node_type$address() {
        return ts_node_type.ADDR;
    }

    public static MemorySegment ts_node_type(MemorySegment self) {
        MethodHandle mh$ = ts_node_type.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_type", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_symbol$descriptor() {
        return ts_node_symbol.DESC;
    }

    public static MethodHandle ts_node_symbol$handle() {
        return ts_node_symbol.HANDLE;
    }

    public static MemorySegment ts_node_symbol$address() {
        return ts_node_symbol.ADDR;
    }

    public static short ts_node_symbol(MemorySegment self) {
        MethodHandle mh$ = ts_node_symbol.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_symbol", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_language$descriptor() {
        return ts_node_language.DESC;
    }

    public static MethodHandle ts_node_language$handle() {
        return ts_node_language.HANDLE;
    }

    public static MemorySegment ts_node_language$address() {
        return ts_node_language.ADDR;
    }

    public static MemorySegment ts_node_language(MemorySegment self) {
        MethodHandle mh$ = ts_node_language.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_language", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_grammar_type$descriptor() {
        return ts_node_grammar_type.DESC;
    }

    public static MethodHandle ts_node_grammar_type$handle() {
        return ts_node_grammar_type.HANDLE;
    }

    public static MemorySegment ts_node_grammar_type$address() {
        return ts_node_grammar_type.ADDR;
    }

    public static MemorySegment ts_node_grammar_type(MemorySegment self) {
        MethodHandle mh$ = ts_node_grammar_type.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_grammar_type", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_grammar_symbol$descriptor() {
        return ts_node_grammar_symbol.DESC;
    }

    public static MethodHandle ts_node_grammar_symbol$handle() {
        return ts_node_grammar_symbol.HANDLE;
    }

    public static MemorySegment ts_node_grammar_symbol$address() {
        return ts_node_grammar_symbol.ADDR;
    }

    public static short ts_node_grammar_symbol(MemorySegment self) {
        MethodHandle mh$ = ts_node_grammar_symbol.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_grammar_symbol", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_start_byte$descriptor() {
        return ts_node_start_byte.DESC;
    }

    public static MethodHandle ts_node_start_byte$handle() {
        return ts_node_start_byte.HANDLE;
    }

    public static MemorySegment ts_node_start_byte$address() {
        return ts_node_start_byte.ADDR;
    }

    public static int ts_node_start_byte(MemorySegment self) {
        MethodHandle mh$ = ts_node_start_byte.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_start_byte", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_start_point$descriptor() {
        return ts_node_start_point.DESC;
    }

    public static MethodHandle ts_node_start_point$handle() {
        return ts_node_start_point.HANDLE;
    }

    public static MemorySegment ts_node_start_point$address() {
        return ts_node_start_point.ADDR;
    }

    public static MemorySegment ts_node_start_point(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_node_start_point.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_start_point", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_end_byte$descriptor() {
        return ts_node_end_byte.DESC;
    }

    public static MethodHandle ts_node_end_byte$handle() {
        return ts_node_end_byte.HANDLE;
    }

    public static MemorySegment ts_node_end_byte$address() {
        return ts_node_end_byte.ADDR;
    }

    public static int ts_node_end_byte(MemorySegment self) {
        MethodHandle mh$ = ts_node_end_byte.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_end_byte", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_end_point$descriptor() {
        return ts_node_end_point.DESC;
    }

    public static MethodHandle ts_node_end_point$handle() {
        return ts_node_end_point.HANDLE;
    }

    public static MemorySegment ts_node_end_point$address() {
        return ts_node_end_point.ADDR;
    }

    public static MemorySegment ts_node_end_point(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_node_end_point.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_end_point", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_string$descriptor() {
        return ts_node_string.DESC;
    }

    public static MethodHandle ts_node_string$handle() {
        return ts_node_string.HANDLE;
    }

    public static MemorySegment ts_node_string$address() {
        return ts_node_string.ADDR;
    }

    public static MemorySegment ts_node_string(MemorySegment self) {
        MethodHandle mh$ = ts_node_string.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_string", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_is_null$descriptor() {
        return ts_node_is_null.DESC;
    }

    public static MethodHandle ts_node_is_null$handle() {
        return ts_node_is_null.HANDLE;
    }

    public static MemorySegment ts_node_is_null$address() {
        return ts_node_is_null.ADDR;
    }

    public static boolean ts_node_is_null(MemorySegment self) {
        MethodHandle mh$ = ts_node_is_null.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_is_null", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_is_named$descriptor() {
        return ts_node_is_named.DESC;
    }

    public static MethodHandle ts_node_is_named$handle() {
        return ts_node_is_named.HANDLE;
    }

    public static MemorySegment ts_node_is_named$address() {
        return ts_node_is_named.ADDR;
    }

    public static boolean ts_node_is_named(MemorySegment self) {
        MethodHandle mh$ = ts_node_is_named.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_is_named", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_is_missing$descriptor() {
        return ts_node_is_missing.DESC;
    }

    public static MethodHandle ts_node_is_missing$handle() {
        return ts_node_is_missing.HANDLE;
    }

    public static MemorySegment ts_node_is_missing$address() {
        return ts_node_is_missing.ADDR;
    }

    public static boolean ts_node_is_missing(MemorySegment self) {
        MethodHandle mh$ = ts_node_is_missing.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_is_missing", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_is_extra$descriptor() {
        return ts_node_is_extra.DESC;
    }

    public static MethodHandle ts_node_is_extra$handle() {
        return ts_node_is_extra.HANDLE;
    }

    public static MemorySegment ts_node_is_extra$address() {
        return ts_node_is_extra.ADDR;
    }

    public static boolean ts_node_is_extra(MemorySegment self) {
        MethodHandle mh$ = ts_node_is_extra.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_is_extra", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_has_changes$descriptor() {
        return ts_node_has_changes.DESC;
    }

    public static MethodHandle ts_node_has_changes$handle() {
        return ts_node_has_changes.HANDLE;
    }

    public static MemorySegment ts_node_has_changes$address() {
        return ts_node_has_changes.ADDR;
    }

    public static boolean ts_node_has_changes(MemorySegment self) {
        MethodHandle mh$ = ts_node_has_changes.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_has_changes", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_has_error$descriptor() {
        return ts_node_has_error.DESC;
    }

    public static MethodHandle ts_node_has_error$handle() {
        return ts_node_has_error.HANDLE;
    }

    public static MemorySegment ts_node_has_error$address() {
        return ts_node_has_error.ADDR;
    }

    public static boolean ts_node_has_error(MemorySegment self) {
        MethodHandle mh$ = ts_node_has_error.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_has_error", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_is_error$descriptor() {
        return ts_node_is_error.DESC;
    }

    public static MethodHandle ts_node_is_error$handle() {
        return ts_node_is_error.HANDLE;
    }

    public static MemorySegment ts_node_is_error$address() {
        return ts_node_is_error.ADDR;
    }

    public static boolean ts_node_is_error(MemorySegment self) {
        MethodHandle mh$ = ts_node_is_error.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_is_error", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_parse_state$descriptor() {
        return ts_node_parse_state.DESC;
    }

    public static MethodHandle ts_node_parse_state$handle() {
        return ts_node_parse_state.HANDLE;
    }

    public static MemorySegment ts_node_parse_state$address() {
        return ts_node_parse_state.ADDR;
    }

    public static short ts_node_parse_state(MemorySegment self) {
        MethodHandle mh$ = ts_node_parse_state.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_parse_state", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_next_parse_state$descriptor() {
        return ts_node_next_parse_state.DESC;
    }

    public static MethodHandle ts_node_next_parse_state$handle() {
        return ts_node_next_parse_state.HANDLE;
    }

    public static MemorySegment ts_node_next_parse_state$address() {
        return ts_node_next_parse_state.ADDR;
    }

    public static short ts_node_next_parse_state(MemorySegment self) {
        MethodHandle mh$ = ts_node_next_parse_state.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_next_parse_state", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_parent$descriptor() {
        return ts_node_parent.DESC;
    }

    public static MethodHandle ts_node_parent$handle() {
        return ts_node_parent.HANDLE;
    }

    public static MemorySegment ts_node_parent$address() {
        return ts_node_parent.ADDR;
    }

    public static MemorySegment ts_node_parent(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_node_parent.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_parent", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_child_containing_descendant$descriptor() {
        return ts_node_child_containing_descendant.DESC;
    }

    public static MethodHandle ts_node_child_containing_descendant$handle() {
        return ts_node_child_containing_descendant.HANDLE;
    }

    public static MemorySegment ts_node_child_containing_descendant$address() {
        return ts_node_child_containing_descendant.ADDR;
    }

    public static MemorySegment ts_node_child_containing_descendant(SegmentAllocator allocator, MemorySegment self, MemorySegment descendant) {
        MethodHandle mh$ = ts_node_child_containing_descendant.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_child_containing_descendant", allocator, self, descendant);
            }
            return mh$.invokeExact(allocator, self, descendant);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_child$descriptor() {
        return ts_node_child.DESC;
    }

    public static MethodHandle ts_node_child$handle() {
        return ts_node_child.HANDLE;
    }

    public static MemorySegment ts_node_child$address() {
        return ts_node_child.ADDR;
    }

    public static MemorySegment ts_node_child(SegmentAllocator allocator, MemorySegment self, int child_index) {
        MethodHandle mh$ = ts_node_child.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_child", allocator, self, child_index);
            }
            return mh$.invokeExact(allocator, self, child_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_field_name_for_child$descriptor() {
        return ts_node_field_name_for_child.DESC;
    }

    public static MethodHandle ts_node_field_name_for_child$handle() {
        return ts_node_field_name_for_child.HANDLE;
    }

    public static MemorySegment ts_node_field_name_for_child$address() {
        return ts_node_field_name_for_child.ADDR;
    }

    public static MemorySegment ts_node_field_name_for_child(MemorySegment self, int child_index) {
        MethodHandle mh$ = ts_node_field_name_for_child.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_field_name_for_child", self, child_index);
            }
            return mh$.invokeExact(self, child_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_child_count$descriptor() {
        return ts_node_child_count.DESC;
    }

    public static MethodHandle ts_node_child_count$handle() {
        return ts_node_child_count.HANDLE;
    }

    public static MemorySegment ts_node_child_count$address() {
        return ts_node_child_count.ADDR;
    }

    public static int ts_node_child_count(MemorySegment self) {
        MethodHandle mh$ = ts_node_child_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_child_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_named_child$descriptor() {
        return ts_node_named_child.DESC;
    }

    public static MethodHandle ts_node_named_child$handle() {
        return ts_node_named_child.HANDLE;
    }

    public static MemorySegment ts_node_named_child$address() {
        return ts_node_named_child.ADDR;
    }

    public static MemorySegment ts_node_named_child(SegmentAllocator allocator, MemorySegment self, int child_index) {
        MethodHandle mh$ = ts_node_named_child.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_named_child", allocator, self, child_index);
            }
            return mh$.invokeExact(allocator, self, child_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_named_child_count$descriptor() {
        return ts_node_named_child_count.DESC;
    }

    public static MethodHandle ts_node_named_child_count$handle() {
        return ts_node_named_child_count.HANDLE;
    }

    public static MemorySegment ts_node_named_child_count$address() {
        return ts_node_named_child_count.ADDR;
    }

    public static int ts_node_named_child_count(MemorySegment self) {
        MethodHandle mh$ = ts_node_named_child_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_named_child_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_child_by_field_name$descriptor() {
        return ts_node_child_by_field_name.DESC;
    }

    public static MethodHandle ts_node_child_by_field_name$handle() {
        return ts_node_child_by_field_name.HANDLE;
    }

    public static MemorySegment ts_node_child_by_field_name$address() {
        return ts_node_child_by_field_name.ADDR;
    }

    public static MemorySegment ts_node_child_by_field_name(SegmentAllocator allocator, MemorySegment self, MemorySegment name, int name_length) {
        MethodHandle mh$ = ts_node_child_by_field_name.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_child_by_field_name", allocator, self, name, name_length);
            }
            return mh$.invokeExact(allocator, self, name, name_length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_child_by_field_id$descriptor() {
        return ts_node_child_by_field_id.DESC;
    }

    public static MethodHandle ts_node_child_by_field_id$handle() {
        return ts_node_child_by_field_id.HANDLE;
    }

    public static MemorySegment ts_node_child_by_field_id$address() {
        return ts_node_child_by_field_id.ADDR;
    }

    public static MemorySegment ts_node_child_by_field_id(SegmentAllocator allocator, MemorySegment self, short field_id) {
        MethodHandle mh$ = ts_node_child_by_field_id.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_child_by_field_id", allocator, self, field_id);
            }
            return mh$.invokeExact(allocator, self, field_id);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_next_sibling$descriptor() {
        return ts_node_next_sibling.DESC;
    }

    public static MethodHandle ts_node_next_sibling$handle() {
        return ts_node_next_sibling.HANDLE;
    }

    public static MemorySegment ts_node_next_sibling$address() {
        return ts_node_next_sibling.ADDR;
    }

    public static MemorySegment ts_node_next_sibling(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_node_next_sibling.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_next_sibling", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_prev_sibling$descriptor() {
        return ts_node_prev_sibling.DESC;
    }

    public static MethodHandle ts_node_prev_sibling$handle() {
        return ts_node_prev_sibling.HANDLE;
    }

    public static MemorySegment ts_node_prev_sibling$address() {
        return ts_node_prev_sibling.ADDR;
    }

    public static MemorySegment ts_node_prev_sibling(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_node_prev_sibling.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_prev_sibling", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_next_named_sibling$descriptor() {
        return ts_node_next_named_sibling.DESC;
    }

    public static MethodHandle ts_node_next_named_sibling$handle() {
        return ts_node_next_named_sibling.HANDLE;
    }

    public static MemorySegment ts_node_next_named_sibling$address() {
        return ts_node_next_named_sibling.ADDR;
    }

    public static MemorySegment ts_node_next_named_sibling(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_node_next_named_sibling.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_next_named_sibling", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_prev_named_sibling$descriptor() {
        return ts_node_prev_named_sibling.DESC;
    }

    public static MethodHandle ts_node_prev_named_sibling$handle() {
        return ts_node_prev_named_sibling.HANDLE;
    }

    public static MemorySegment ts_node_prev_named_sibling$address() {
        return ts_node_prev_named_sibling.ADDR;
    }

    public static MemorySegment ts_node_prev_named_sibling(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_node_prev_named_sibling.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_prev_named_sibling", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_first_child_for_byte$descriptor() {
        return ts_node_first_child_for_byte.DESC;
    }

    public static MethodHandle ts_node_first_child_for_byte$handle() {
        return ts_node_first_child_for_byte.HANDLE;
    }

    public static MemorySegment ts_node_first_child_for_byte$address() {
        return ts_node_first_child_for_byte.ADDR;
    }

    public static MemorySegment ts_node_first_child_for_byte(SegmentAllocator allocator, MemorySegment self, int byte_) {
        MethodHandle mh$ = ts_node_first_child_for_byte.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_first_child_for_byte", allocator, self, byte_);
            }
            return mh$.invokeExact(allocator, self, byte_);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_first_named_child_for_byte$descriptor() {
        return ts_node_first_named_child_for_byte.DESC;
    }

    public static MethodHandle ts_node_first_named_child_for_byte$handle() {
        return ts_node_first_named_child_for_byte.HANDLE;
    }

    public static MemorySegment ts_node_first_named_child_for_byte$address() {
        return ts_node_first_named_child_for_byte.ADDR;
    }

    public static MemorySegment ts_node_first_named_child_for_byte(SegmentAllocator allocator, MemorySegment self, int byte_) {
        MethodHandle mh$ = ts_node_first_named_child_for_byte.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_first_named_child_for_byte", allocator, self, byte_);
            }
            return mh$.invokeExact(allocator, self, byte_);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_descendant_count$descriptor() {
        return ts_node_descendant_count.DESC;
    }

    public static MethodHandle ts_node_descendant_count$handle() {
        return ts_node_descendant_count.HANDLE;
    }

    public static MemorySegment ts_node_descendant_count$address() {
        return ts_node_descendant_count.ADDR;
    }

    public static int ts_node_descendant_count(MemorySegment self) {
        MethodHandle mh$ = ts_node_descendant_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_descendant_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_descendant_for_byte_range$descriptor() {
        return ts_node_descendant_for_byte_range.DESC;
    }

    public static MethodHandle ts_node_descendant_for_byte_range$handle() {
        return ts_node_descendant_for_byte_range.HANDLE;
    }

    public static MemorySegment ts_node_descendant_for_byte_range$address() {
        return ts_node_descendant_for_byte_range.ADDR;
    }

    public static MemorySegment ts_node_descendant_for_byte_range(SegmentAllocator allocator, MemorySegment self, int start, int end) {
        MethodHandle mh$ = ts_node_descendant_for_byte_range.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_descendant_for_byte_range", allocator, self, start, end);
            }
            return mh$.invokeExact(allocator, self, start, end);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_descendant_for_point_range$descriptor() {
        return ts_node_descendant_for_point_range.DESC;
    }

    public static MethodHandle ts_node_descendant_for_point_range$handle() {
        return ts_node_descendant_for_point_range.HANDLE;
    }

    public static MemorySegment ts_node_descendant_for_point_range$address() {
        return ts_node_descendant_for_point_range.ADDR;
    }

    public static MemorySegment ts_node_descendant_for_point_range(SegmentAllocator allocator, MemorySegment self, MemorySegment start, MemorySegment end) {
        MethodHandle mh$ = ts_node_descendant_for_point_range.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_descendant_for_point_range", allocator, self, start, end);
            }
            return mh$.invokeExact(allocator, self, start, end);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_named_descendant_for_byte_range$descriptor() {
        return ts_node_named_descendant_for_byte_range.DESC;
    }

    public static MethodHandle ts_node_named_descendant_for_byte_range$handle() {
        return ts_node_named_descendant_for_byte_range.HANDLE;
    }

    public static MemorySegment ts_node_named_descendant_for_byte_range$address() {
        return ts_node_named_descendant_for_byte_range.ADDR;
    }

    public static MemorySegment ts_node_named_descendant_for_byte_range(SegmentAllocator allocator, MemorySegment self, int start, int end) {
        MethodHandle mh$ = ts_node_named_descendant_for_byte_range.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_named_descendant_for_byte_range", allocator, self, start, end);
            }
            return mh$.invokeExact(allocator, self, start, end);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_named_descendant_for_point_range$descriptor() {
        return ts_node_named_descendant_for_point_range.DESC;
    }

    public static MethodHandle ts_node_named_descendant_for_point_range$handle() {
        return ts_node_named_descendant_for_point_range.HANDLE;
    }

    public static MemorySegment ts_node_named_descendant_for_point_range$address() {
        return ts_node_named_descendant_for_point_range.ADDR;
    }

    public static MemorySegment ts_node_named_descendant_for_point_range(SegmentAllocator allocator, MemorySegment self, MemorySegment start, MemorySegment end) {
        MethodHandle mh$ = ts_node_named_descendant_for_point_range.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_named_descendant_for_point_range", allocator, self, start, end);
            }
            return mh$.invokeExact(allocator, self, start, end);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_edit$descriptor() {
        return ts_node_edit.DESC;
    }

    public static MethodHandle ts_node_edit$handle() {
        return ts_node_edit.HANDLE;
    }

    public static MemorySegment ts_node_edit$address() {
        return ts_node_edit.ADDR;
    }

    public static void ts_node_edit(MemorySegment self, MemorySegment edit) {
        MethodHandle mh$ = ts_node_edit.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_edit", self, edit);
            }
            mh$.invokeExact(self, edit);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_node_eq$descriptor() {
        return ts_node_eq.DESC;
    }

    public static MethodHandle ts_node_eq$handle() {
        return ts_node_eq.HANDLE;
    }

    public static MemorySegment ts_node_eq$address() {
        return ts_node_eq.ADDR;
    }

    public static boolean ts_node_eq(MemorySegment self, MemorySegment other) {
        MethodHandle mh$ = ts_node_eq.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_node_eq", self, other);
            }
            return mh$.invokeExact(self, other);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_new$descriptor() {
        return ts_tree_cursor_new.DESC;
    }

    public static MethodHandle ts_tree_cursor_new$handle() {
        return ts_tree_cursor_new.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_new$address() {
        return ts_tree_cursor_new.ADDR;
    }

    public static MemorySegment ts_tree_cursor_new(SegmentAllocator allocator, MemorySegment node) {
        MethodHandle mh$ = ts_tree_cursor_new.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_new", allocator, node);
            }
            return mh$.invokeExact(allocator, node);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_delete$descriptor() {
        return ts_tree_cursor_delete.DESC;
    }

    public static MethodHandle ts_tree_cursor_delete$handle() {
        return ts_tree_cursor_delete.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_delete$address() {
        return ts_tree_cursor_delete.ADDR;
    }

    public static void ts_tree_cursor_delete(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_delete.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_delete", self);
            }
            mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_reset$descriptor() {
        return ts_tree_cursor_reset.DESC;
    }

    public static MethodHandle ts_tree_cursor_reset$handle() {
        return ts_tree_cursor_reset.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_reset$address() {
        return ts_tree_cursor_reset.ADDR;
    }

    public static void ts_tree_cursor_reset(MemorySegment self, MemorySegment node) {
        MethodHandle mh$ = ts_tree_cursor_reset.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_reset", self, node);
            }
            mh$.invokeExact(self, node);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_reset_to$descriptor() {
        return ts_tree_cursor_reset_to.DESC;
    }

    public static MethodHandle ts_tree_cursor_reset_to$handle() {
        return ts_tree_cursor_reset_to.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_reset_to$address() {
        return ts_tree_cursor_reset_to.ADDR;
    }

    public static void ts_tree_cursor_reset_to(MemorySegment dst, MemorySegment src) {
        MethodHandle mh$ = ts_tree_cursor_reset_to.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_reset_to", dst, src);
            }
            mh$.invokeExact(dst, src);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_current_node$descriptor() {
        return ts_tree_cursor_current_node.DESC;
    }

    public static MethodHandle ts_tree_cursor_current_node$handle() {
        return ts_tree_cursor_current_node.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_current_node$address() {
        return ts_tree_cursor_current_node.ADDR;
    }

    public static MemorySegment ts_tree_cursor_current_node(SegmentAllocator allocator, MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_current_node.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_current_node", allocator, self);
            }
            return mh$.invokeExact(allocator, self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_current_field_name$descriptor() {
        return ts_tree_cursor_current_field_name.DESC;
    }

    public static MethodHandle ts_tree_cursor_current_field_name$handle() {
        return ts_tree_cursor_current_field_name.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_current_field_name$address() {
        return ts_tree_cursor_current_field_name.ADDR;
    }

    public static MemorySegment ts_tree_cursor_current_field_name(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_current_field_name.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_current_field_name", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_current_field_id$descriptor() {
        return ts_tree_cursor_current_field_id.DESC;
    }

    public static MethodHandle ts_tree_cursor_current_field_id$handle() {
        return ts_tree_cursor_current_field_id.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_current_field_id$address() {
        return ts_tree_cursor_current_field_id.ADDR;
    }

    public static short ts_tree_cursor_current_field_id(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_current_field_id.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_current_field_id", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_goto_parent$descriptor() {
        return ts_tree_cursor_goto_parent.DESC;
    }

    public static MethodHandle ts_tree_cursor_goto_parent$handle() {
        return ts_tree_cursor_goto_parent.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_goto_parent$address() {
        return ts_tree_cursor_goto_parent.ADDR;
    }

    public static boolean ts_tree_cursor_goto_parent(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_goto_parent.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_goto_parent", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_goto_next_sibling$descriptor() {
        return ts_tree_cursor_goto_next_sibling.DESC;
    }

    public static MethodHandle ts_tree_cursor_goto_next_sibling$handle() {
        return ts_tree_cursor_goto_next_sibling.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_goto_next_sibling$address() {
        return ts_tree_cursor_goto_next_sibling.ADDR;
    }

    public static boolean ts_tree_cursor_goto_next_sibling(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_goto_next_sibling.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_goto_next_sibling", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_goto_previous_sibling$descriptor() {
        return ts_tree_cursor_goto_previous_sibling.DESC;
    }

    public static MethodHandle ts_tree_cursor_goto_previous_sibling$handle() {
        return ts_tree_cursor_goto_previous_sibling.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_goto_previous_sibling$address() {
        return ts_tree_cursor_goto_previous_sibling.ADDR;
    }

    public static boolean ts_tree_cursor_goto_previous_sibling(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_goto_previous_sibling.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_goto_previous_sibling", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_goto_first_child$descriptor() {
        return ts_tree_cursor_goto_first_child.DESC;
    }

    public static MethodHandle ts_tree_cursor_goto_first_child$handle() {
        return ts_tree_cursor_goto_first_child.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_goto_first_child$address() {
        return ts_tree_cursor_goto_first_child.ADDR;
    }

    public static boolean ts_tree_cursor_goto_first_child(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_goto_first_child.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_goto_first_child", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_goto_last_child$descriptor() {
        return ts_tree_cursor_goto_last_child.DESC;
    }

    public static MethodHandle ts_tree_cursor_goto_last_child$handle() {
        return ts_tree_cursor_goto_last_child.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_goto_last_child$address() {
        return ts_tree_cursor_goto_last_child.ADDR;
    }

    public static boolean ts_tree_cursor_goto_last_child(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_goto_last_child.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_goto_last_child", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_goto_descendant$descriptor() {
        return ts_tree_cursor_goto_descendant.DESC;
    }

    public static MethodHandle ts_tree_cursor_goto_descendant$handle() {
        return ts_tree_cursor_goto_descendant.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_goto_descendant$address() {
        return ts_tree_cursor_goto_descendant.ADDR;
    }

    public static void ts_tree_cursor_goto_descendant(MemorySegment self, int goal_descendant_index) {
        MethodHandle mh$ = ts_tree_cursor_goto_descendant.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_goto_descendant", self, goal_descendant_index);
            }
            mh$.invokeExact(self, goal_descendant_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_current_descendant_index$descriptor() {
        return ts_tree_cursor_current_descendant_index.DESC;
    }

    public static MethodHandle ts_tree_cursor_current_descendant_index$handle() {
        return ts_tree_cursor_current_descendant_index.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_current_descendant_index$address() {
        return ts_tree_cursor_current_descendant_index.ADDR;
    }

    public static int ts_tree_cursor_current_descendant_index(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_current_descendant_index.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_current_descendant_index", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_current_depth$descriptor() {
        return ts_tree_cursor_current_depth.DESC;
    }

    public static MethodHandle ts_tree_cursor_current_depth$handle() {
        return ts_tree_cursor_current_depth.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_current_depth$address() {
        return ts_tree_cursor_current_depth.ADDR;
    }

    public static int ts_tree_cursor_current_depth(MemorySegment self) {
        MethodHandle mh$ = ts_tree_cursor_current_depth.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_current_depth", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_goto_first_child_for_byte$descriptor() {
        return ts_tree_cursor_goto_first_child_for_byte.DESC;
    }

    public static MethodHandle ts_tree_cursor_goto_first_child_for_byte$handle() {
        return ts_tree_cursor_goto_first_child_for_byte.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_goto_first_child_for_byte$address() {
        return ts_tree_cursor_goto_first_child_for_byte.ADDR;
    }

    public static long ts_tree_cursor_goto_first_child_for_byte(MemorySegment self, int goal_byte) {
        MethodHandle mh$ = ts_tree_cursor_goto_first_child_for_byte.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_goto_first_child_for_byte", self, goal_byte);
            }
            return mh$.invokeExact(self, goal_byte);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_goto_first_child_for_point$descriptor() {
        return ts_tree_cursor_goto_first_child_for_point.DESC;
    }

    public static MethodHandle ts_tree_cursor_goto_first_child_for_point$handle() {
        return ts_tree_cursor_goto_first_child_for_point.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_goto_first_child_for_point$address() {
        return ts_tree_cursor_goto_first_child_for_point.ADDR;
    }

    public static long ts_tree_cursor_goto_first_child_for_point(MemorySegment self, MemorySegment goal_point) {
        MethodHandle mh$ = ts_tree_cursor_goto_first_child_for_point.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_goto_first_child_for_point", self, goal_point);
            }
            return mh$.invokeExact(self, goal_point);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_tree_cursor_copy$descriptor() {
        return ts_tree_cursor_copy.DESC;
    }

    public static MethodHandle ts_tree_cursor_copy$handle() {
        return ts_tree_cursor_copy.HANDLE;
    }

    public static MemorySegment ts_tree_cursor_copy$address() {
        return ts_tree_cursor_copy.ADDR;
    }

    public static MemorySegment ts_tree_cursor_copy(SegmentAllocator allocator, MemorySegment cursor) {
        MethodHandle mh$ = ts_tree_cursor_copy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_tree_cursor_copy", allocator, cursor);
            }
            return mh$.invokeExact(allocator, cursor);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_new$descriptor() {
        return ts_query_new.DESC;
    }

    public static MethodHandle ts_query_new$handle() {
        return ts_query_new.HANDLE;
    }

    public static MemorySegment ts_query_new$address() {
        return ts_query_new.ADDR;
    }

    public static MemorySegment ts_query_new(MemorySegment language, MemorySegment source, int source_len, MemorySegment error_offset, MemorySegment error_type) {
        MethodHandle mh$ = ts_query_new.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_new", language, source, source_len, error_offset, error_type);
            }
            return mh$.invokeExact(language, source, source_len, error_offset, error_type);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_delete$descriptor() {
        return ts_query_delete.DESC;
    }

    public static MethodHandle ts_query_delete$handle() {
        return ts_query_delete.HANDLE;
    }

    public static MemorySegment ts_query_delete$address() {
        return ts_query_delete.ADDR;
    }

    public static void ts_query_delete(MemorySegment self) {
        MethodHandle mh$ = ts_query_delete.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_delete", self);
            }
            mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_pattern_count$descriptor() {
        return ts_query_pattern_count.DESC;
    }

    public static MethodHandle ts_query_pattern_count$handle() {
        return ts_query_pattern_count.HANDLE;
    }

    public static MemorySegment ts_query_pattern_count$address() {
        return ts_query_pattern_count.ADDR;
    }

    public static int ts_query_pattern_count(MemorySegment self) {
        MethodHandle mh$ = ts_query_pattern_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_pattern_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_capture_count$descriptor() {
        return ts_query_capture_count.DESC;
    }

    public static MethodHandle ts_query_capture_count$handle() {
        return ts_query_capture_count.HANDLE;
    }

    public static MemorySegment ts_query_capture_count$address() {
        return ts_query_capture_count.ADDR;
    }

    public static int ts_query_capture_count(MemorySegment self) {
        MethodHandle mh$ = ts_query_capture_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_capture_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_string_count$descriptor() {
        return ts_query_string_count.DESC;
    }

    public static MethodHandle ts_query_string_count$handle() {
        return ts_query_string_count.HANDLE;
    }

    public static MemorySegment ts_query_string_count$address() {
        return ts_query_string_count.ADDR;
    }

    public static int ts_query_string_count(MemorySegment self) {
        MethodHandle mh$ = ts_query_string_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_string_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_start_byte_for_pattern$descriptor() {
        return ts_query_start_byte_for_pattern.DESC;
    }

    public static MethodHandle ts_query_start_byte_for_pattern$handle() {
        return ts_query_start_byte_for_pattern.HANDLE;
    }

    public static MemorySegment ts_query_start_byte_for_pattern$address() {
        return ts_query_start_byte_for_pattern.ADDR;
    }

    public static int ts_query_start_byte_for_pattern(MemorySegment self, int pattern_index) {
        MethodHandle mh$ = ts_query_start_byte_for_pattern.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_start_byte_for_pattern", self, pattern_index);
            }
            return mh$.invokeExact(self, pattern_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_end_byte_for_pattern$descriptor() {
        return ts_query_end_byte_for_pattern.DESC;
    }

    public static MethodHandle ts_query_end_byte_for_pattern$handle() {
        return ts_query_end_byte_for_pattern.HANDLE;
    }

    public static MemorySegment ts_query_end_byte_for_pattern$address() {
        return ts_query_end_byte_for_pattern.ADDR;
    }

    public static int ts_query_end_byte_for_pattern(MemorySegment self, int pattern_index) {
        MethodHandle mh$ = ts_query_end_byte_for_pattern.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_end_byte_for_pattern", self, pattern_index);
            }
            return mh$.invokeExact(self, pattern_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_predicates_for_pattern$descriptor() {
        return ts_query_predicates_for_pattern.DESC;
    }

    public static MethodHandle ts_query_predicates_for_pattern$handle() {
        return ts_query_predicates_for_pattern.HANDLE;
    }

    public static MemorySegment ts_query_predicates_for_pattern$address() {
        return ts_query_predicates_for_pattern.ADDR;
    }

    public static MemorySegment ts_query_predicates_for_pattern(MemorySegment self, int pattern_index, MemorySegment step_count) {
        MethodHandle mh$ = ts_query_predicates_for_pattern.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_predicates_for_pattern", self, pattern_index, step_count);
            }
            return mh$.invokeExact(self, pattern_index, step_count);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_is_pattern_rooted$descriptor() {
        return ts_query_is_pattern_rooted.DESC;
    }

    public static MethodHandle ts_query_is_pattern_rooted$handle() {
        return ts_query_is_pattern_rooted.HANDLE;
    }

    public static MemorySegment ts_query_is_pattern_rooted$address() {
        return ts_query_is_pattern_rooted.ADDR;
    }

    public static boolean ts_query_is_pattern_rooted(MemorySegment self, int pattern_index) {
        MethodHandle mh$ = ts_query_is_pattern_rooted.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_is_pattern_rooted", self, pattern_index);
            }
            return mh$.invokeExact(self, pattern_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_is_pattern_non_local$descriptor() {
        return ts_query_is_pattern_non_local.DESC;
    }

    public static MethodHandle ts_query_is_pattern_non_local$handle() {
        return ts_query_is_pattern_non_local.HANDLE;
    }

    public static MemorySegment ts_query_is_pattern_non_local$address() {
        return ts_query_is_pattern_non_local.ADDR;
    }

    public static boolean ts_query_is_pattern_non_local(MemorySegment self, int pattern_index) {
        MethodHandle mh$ = ts_query_is_pattern_non_local.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_is_pattern_non_local", self, pattern_index);
            }
            return mh$.invokeExact(self, pattern_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_is_pattern_guaranteed_at_step$descriptor() {
        return ts_query_is_pattern_guaranteed_at_step.DESC;
    }

    public static MethodHandle ts_query_is_pattern_guaranteed_at_step$handle() {
        return ts_query_is_pattern_guaranteed_at_step.HANDLE;
    }

    public static MemorySegment ts_query_is_pattern_guaranteed_at_step$address() {
        return ts_query_is_pattern_guaranteed_at_step.ADDR;
    }

    public static boolean ts_query_is_pattern_guaranteed_at_step(MemorySegment self, int byte_offset) {
        MethodHandle mh$ = ts_query_is_pattern_guaranteed_at_step.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_is_pattern_guaranteed_at_step", self, byte_offset);
            }
            return mh$.invokeExact(self, byte_offset);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_capture_name_for_id$descriptor() {
        return ts_query_capture_name_for_id.DESC;
    }

    public static MethodHandle ts_query_capture_name_for_id$handle() {
        return ts_query_capture_name_for_id.HANDLE;
    }

    public static MemorySegment ts_query_capture_name_for_id$address() {
        return ts_query_capture_name_for_id.ADDR;
    }

    public static MemorySegment ts_query_capture_name_for_id(MemorySegment self, int index, MemorySegment length) {
        MethodHandle mh$ = ts_query_capture_name_for_id.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_capture_name_for_id", self, index, length);
            }
            return mh$.invokeExact(self, index, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_capture_quantifier_for_id$descriptor() {
        return ts_query_capture_quantifier_for_id.DESC;
    }

    public static MethodHandle ts_query_capture_quantifier_for_id$handle() {
        return ts_query_capture_quantifier_for_id.HANDLE;
    }

    public static MemorySegment ts_query_capture_quantifier_for_id$address() {
        return ts_query_capture_quantifier_for_id.ADDR;
    }

    public static int ts_query_capture_quantifier_for_id(MemorySegment self, int pattern_index, int capture_index) {
        MethodHandle mh$ = ts_query_capture_quantifier_for_id.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_capture_quantifier_for_id", self, pattern_index, capture_index);
            }
            return mh$.invokeExact(self, pattern_index, capture_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_string_value_for_id$descriptor() {
        return ts_query_string_value_for_id.DESC;
    }

    public static MethodHandle ts_query_string_value_for_id$handle() {
        return ts_query_string_value_for_id.HANDLE;
    }

    public static MemorySegment ts_query_string_value_for_id$address() {
        return ts_query_string_value_for_id.ADDR;
    }

    public static MemorySegment ts_query_string_value_for_id(MemorySegment self, int index, MemorySegment length) {
        MethodHandle mh$ = ts_query_string_value_for_id.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_string_value_for_id", self, index, length);
            }
            return mh$.invokeExact(self, index, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_disable_capture$descriptor() {
        return ts_query_disable_capture.DESC;
    }

    public static MethodHandle ts_query_disable_capture$handle() {
        return ts_query_disable_capture.HANDLE;
    }

    public static MemorySegment ts_query_disable_capture$address() {
        return ts_query_disable_capture.ADDR;
    }

    public static void ts_query_disable_capture(MemorySegment self, MemorySegment name, int length) {
        MethodHandle mh$ = ts_query_disable_capture.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_disable_capture", self, name, length);
            }
            mh$.invokeExact(self, name, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_disable_pattern$descriptor() {
        return ts_query_disable_pattern.DESC;
    }

    public static MethodHandle ts_query_disable_pattern$handle() {
        return ts_query_disable_pattern.HANDLE;
    }

    public static MemorySegment ts_query_disable_pattern$address() {
        return ts_query_disable_pattern.ADDR;
    }

    public static void ts_query_disable_pattern(MemorySegment self, int pattern_index) {
        MethodHandle mh$ = ts_query_disable_pattern.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_disable_pattern", self, pattern_index);
            }
            mh$.invokeExact(self, pattern_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_new$descriptor() {
        return ts_query_cursor_new.DESC;
    }

    public static MethodHandle ts_query_cursor_new$handle() {
        return ts_query_cursor_new.HANDLE;
    }

    public static MemorySegment ts_query_cursor_new$address() {
        return ts_query_cursor_new.ADDR;
    }

    public static MemorySegment ts_query_cursor_new() {
        MethodHandle mh$ = ts_query_cursor_new.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_new", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_delete$descriptor() {
        return ts_query_cursor_delete.DESC;
    }

    public static MethodHandle ts_query_cursor_delete$handle() {
        return ts_query_cursor_delete.HANDLE;
    }

    public static MemorySegment ts_query_cursor_delete$address() {
        return ts_query_cursor_delete.ADDR;
    }

    public static void ts_query_cursor_delete(MemorySegment self) {
        MethodHandle mh$ = ts_query_cursor_delete.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_delete", self);
            }
            mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_exec$descriptor() {
        return ts_query_cursor_exec.DESC;
    }

    public static MethodHandle ts_query_cursor_exec$handle() {
        return ts_query_cursor_exec.HANDLE;
    }

    public static MemorySegment ts_query_cursor_exec$address() {
        return ts_query_cursor_exec.ADDR;
    }

    public static void ts_query_cursor_exec(MemorySegment self, MemorySegment query, MemorySegment node) {
        MethodHandle mh$ = ts_query_cursor_exec.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_exec", self, query, node);
            }
            mh$.invokeExact(self, query, node);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_did_exceed_match_limit$descriptor() {
        return ts_query_cursor_did_exceed_match_limit.DESC;
    }

    public static MethodHandle ts_query_cursor_did_exceed_match_limit$handle() {
        return ts_query_cursor_did_exceed_match_limit.HANDLE;
    }

    public static MemorySegment ts_query_cursor_did_exceed_match_limit$address() {
        return ts_query_cursor_did_exceed_match_limit.ADDR;
    }

    public static boolean ts_query_cursor_did_exceed_match_limit(MemorySegment self) {
        MethodHandle mh$ = ts_query_cursor_did_exceed_match_limit.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_did_exceed_match_limit", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_match_limit$descriptor() {
        return ts_query_cursor_match_limit.DESC;
    }

    public static MethodHandle ts_query_cursor_match_limit$handle() {
        return ts_query_cursor_match_limit.HANDLE;
    }

    public static MemorySegment ts_query_cursor_match_limit$address() {
        return ts_query_cursor_match_limit.ADDR;
    }

    public static int ts_query_cursor_match_limit(MemorySegment self) {
        MethodHandle mh$ = ts_query_cursor_match_limit.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_match_limit", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_set_match_limit$descriptor() {
        return ts_query_cursor_set_match_limit.DESC;
    }

    public static MethodHandle ts_query_cursor_set_match_limit$handle() {
        return ts_query_cursor_set_match_limit.HANDLE;
    }

    public static MemorySegment ts_query_cursor_set_match_limit$address() {
        return ts_query_cursor_set_match_limit.ADDR;
    }

    public static void ts_query_cursor_set_match_limit(MemorySegment self, int limit) {
        MethodHandle mh$ = ts_query_cursor_set_match_limit.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_set_match_limit", self, limit);
            }
            mh$.invokeExact(self, limit);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_set_timeout_micros$descriptor() {
        return ts_query_cursor_set_timeout_micros.DESC;
    }

    public static MethodHandle ts_query_cursor_set_timeout_micros$handle() {
        return ts_query_cursor_set_timeout_micros.HANDLE;
    }

    public static MemorySegment ts_query_cursor_set_timeout_micros$address() {
        return ts_query_cursor_set_timeout_micros.ADDR;
    }

    public static void ts_query_cursor_set_timeout_micros(MemorySegment self, long timeout_micros) {
        MethodHandle mh$ = ts_query_cursor_set_timeout_micros.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_set_timeout_micros", self, timeout_micros);
            }
            mh$.invokeExact(self, timeout_micros);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_timeout_micros$descriptor() {
        return ts_query_cursor_timeout_micros.DESC;
    }

    public static MethodHandle ts_query_cursor_timeout_micros$handle() {
        return ts_query_cursor_timeout_micros.HANDLE;
    }

    public static MemorySegment ts_query_cursor_timeout_micros$address() {
        return ts_query_cursor_timeout_micros.ADDR;
    }

    public static long ts_query_cursor_timeout_micros(MemorySegment self) {
        MethodHandle mh$ = ts_query_cursor_timeout_micros.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_timeout_micros", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_set_byte_range$descriptor() {
        return ts_query_cursor_set_byte_range.DESC;
    }

    public static MethodHandle ts_query_cursor_set_byte_range$handle() {
        return ts_query_cursor_set_byte_range.HANDLE;
    }

    public static MemorySegment ts_query_cursor_set_byte_range$address() {
        return ts_query_cursor_set_byte_range.ADDR;
    }

    public static void ts_query_cursor_set_byte_range(MemorySegment self, int start_byte, int end_byte) {
        MethodHandle mh$ = ts_query_cursor_set_byte_range.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_set_byte_range", self, start_byte, end_byte);
            }
            mh$.invokeExact(self, start_byte, end_byte);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_set_point_range$descriptor() {
        return ts_query_cursor_set_point_range.DESC;
    }

    public static MethodHandle ts_query_cursor_set_point_range$handle() {
        return ts_query_cursor_set_point_range.HANDLE;
    }

    public static MemorySegment ts_query_cursor_set_point_range$address() {
        return ts_query_cursor_set_point_range.ADDR;
    }

    public static void ts_query_cursor_set_point_range(MemorySegment self, MemorySegment start_point, MemorySegment end_point) {
        MethodHandle mh$ = ts_query_cursor_set_point_range.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_set_point_range", self, start_point, end_point);
            }
            mh$.invokeExact(self, start_point, end_point);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_next_match$descriptor() {
        return ts_query_cursor_next_match.DESC;
    }

    public static MethodHandle ts_query_cursor_next_match$handle() {
        return ts_query_cursor_next_match.HANDLE;
    }

    public static MemorySegment ts_query_cursor_next_match$address() {
        return ts_query_cursor_next_match.ADDR;
    }

    public static boolean ts_query_cursor_next_match(MemorySegment self, MemorySegment match) {
        MethodHandle mh$ = ts_query_cursor_next_match.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_next_match", self, match);
            }
            return mh$.invokeExact(self, match);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_remove_match$descriptor() {
        return ts_query_cursor_remove_match.DESC;
    }

    public static MethodHandle ts_query_cursor_remove_match$handle() {
        return ts_query_cursor_remove_match.HANDLE;
    }

    public static MemorySegment ts_query_cursor_remove_match$address() {
        return ts_query_cursor_remove_match.ADDR;
    }

    public static void ts_query_cursor_remove_match(MemorySegment self, int match_id) {
        MethodHandle mh$ = ts_query_cursor_remove_match.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_remove_match", self, match_id);
            }
            mh$.invokeExact(self, match_id);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_next_capture$descriptor() {
        return ts_query_cursor_next_capture.DESC;
    }

    public static MethodHandle ts_query_cursor_next_capture$handle() {
        return ts_query_cursor_next_capture.HANDLE;
    }

    public static MemorySegment ts_query_cursor_next_capture$address() {
        return ts_query_cursor_next_capture.ADDR;
    }

    public static boolean ts_query_cursor_next_capture(MemorySegment self, MemorySegment match, MemorySegment capture_index) {
        MethodHandle mh$ = ts_query_cursor_next_capture.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_next_capture", self, match, capture_index);
            }
            return mh$.invokeExact(self, match, capture_index);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_query_cursor_set_max_start_depth$descriptor() {
        return ts_query_cursor_set_max_start_depth.DESC;
    }

    public static MethodHandle ts_query_cursor_set_max_start_depth$handle() {
        return ts_query_cursor_set_max_start_depth.HANDLE;
    }

    public static MemorySegment ts_query_cursor_set_max_start_depth$address() {
        return ts_query_cursor_set_max_start_depth.ADDR;
    }

    public static void ts_query_cursor_set_max_start_depth(MemorySegment self, int max_start_depth) {
        MethodHandle mh$ = ts_query_cursor_set_max_start_depth.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_query_cursor_set_max_start_depth", self, max_start_depth);
            }
            mh$.invokeExact(self, max_start_depth);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_copy$descriptor() {
        return ts_language_copy.DESC;
    }

    public static MethodHandle ts_language_copy$handle() {
        return ts_language_copy.HANDLE;
    }

    public static MemorySegment ts_language_copy$address() {
        return ts_language_copy.ADDR;
    }

    public static MemorySegment ts_language_copy(MemorySegment self) {
        MethodHandle mh$ = ts_language_copy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_copy", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_delete$descriptor() {
        return ts_language_delete.DESC;
    }

    public static MethodHandle ts_language_delete$handle() {
        return ts_language_delete.HANDLE;
    }

    public static MemorySegment ts_language_delete$address() {
        return ts_language_delete.ADDR;
    }

    public static void ts_language_delete(MemorySegment self) {
        MethodHandle mh$ = ts_language_delete.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_delete", self);
            }
            mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_symbol_count$descriptor() {
        return ts_language_symbol_count.DESC;
    }

    public static MethodHandle ts_language_symbol_count$handle() {
        return ts_language_symbol_count.HANDLE;
    }

    public static MemorySegment ts_language_symbol_count$address() {
        return ts_language_symbol_count.ADDR;
    }

    public static int ts_language_symbol_count(MemorySegment self) {
        MethodHandle mh$ = ts_language_symbol_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_symbol_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_state_count$descriptor() {
        return ts_language_state_count.DESC;
    }

    public static MethodHandle ts_language_state_count$handle() {
        return ts_language_state_count.HANDLE;
    }

    public static MemorySegment ts_language_state_count$address() {
        return ts_language_state_count.ADDR;
    }

    public static int ts_language_state_count(MemorySegment self) {
        MethodHandle mh$ = ts_language_state_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_state_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_symbol_name$descriptor() {
        return ts_language_symbol_name.DESC;
    }

    public static MethodHandle ts_language_symbol_name$handle() {
        return ts_language_symbol_name.HANDLE;
    }

    public static MemorySegment ts_language_symbol_name$address() {
        return ts_language_symbol_name.ADDR;
    }

    public static MemorySegment ts_language_symbol_name(MemorySegment self, short symbol) {
        MethodHandle mh$ = ts_language_symbol_name.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_symbol_name", self, symbol);
            }
            return mh$.invokeExact(self, symbol);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_symbol_for_name$descriptor() {
        return ts_language_symbol_for_name.DESC;
    }

    public static MethodHandle ts_language_symbol_for_name$handle() {
        return ts_language_symbol_for_name.HANDLE;
    }

    public static MemorySegment ts_language_symbol_for_name$address() {
        return ts_language_symbol_for_name.ADDR;
    }

    public static short ts_language_symbol_for_name(MemorySegment self, MemorySegment string, int length, boolean is_named) {
        MethodHandle mh$ = ts_language_symbol_for_name.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_symbol_for_name", self, string, length, is_named);
            }
            return mh$.invokeExact(self, string, length, is_named);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_field_count$descriptor() {
        return ts_language_field_count.DESC;
    }

    public static MethodHandle ts_language_field_count$handle() {
        return ts_language_field_count.HANDLE;
    }

    public static MemorySegment ts_language_field_count$address() {
        return ts_language_field_count.ADDR;
    }

    public static int ts_language_field_count(MemorySegment self) {
        MethodHandle mh$ = ts_language_field_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_field_count", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_field_name_for_id$descriptor() {
        return ts_language_field_name_for_id.DESC;
    }

    public static MethodHandle ts_language_field_name_for_id$handle() {
        return ts_language_field_name_for_id.HANDLE;
    }

    public static MemorySegment ts_language_field_name_for_id$address() {
        return ts_language_field_name_for_id.ADDR;
    }

    public static MemorySegment ts_language_field_name_for_id(MemorySegment self, short id) {
        MethodHandle mh$ = ts_language_field_name_for_id.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_field_name_for_id", self, id);
            }
            return mh$.invokeExact(self, id);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_field_id_for_name$descriptor() {
        return ts_language_field_id_for_name.DESC;
    }

    public static MethodHandle ts_language_field_id_for_name$handle() {
        return ts_language_field_id_for_name.HANDLE;
    }

    public static MemorySegment ts_language_field_id_for_name$address() {
        return ts_language_field_id_for_name.ADDR;
    }

    public static short ts_language_field_id_for_name(MemorySegment self, MemorySegment name, int name_length) {
        MethodHandle mh$ = ts_language_field_id_for_name.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_field_id_for_name", self, name, name_length);
            }
            return mh$.invokeExact(self, name, name_length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_symbol_type$descriptor() {
        return ts_language_symbol_type.DESC;
    }

    public static MethodHandle ts_language_symbol_type$handle() {
        return ts_language_symbol_type.HANDLE;
    }

    public static MemorySegment ts_language_symbol_type$address() {
        return ts_language_symbol_type.ADDR;
    }

    public static int ts_language_symbol_type(MemorySegment self, short symbol) {
        MethodHandle mh$ = ts_language_symbol_type.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_symbol_type", self, symbol);
            }
            return mh$.invokeExact(self, symbol);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_version$descriptor() {
        return ts_language_version.DESC;
    }

    public static MethodHandle ts_language_version$handle() {
        return ts_language_version.HANDLE;
    }

    public static MemorySegment ts_language_version$address() {
        return ts_language_version.ADDR;
    }

    public static int ts_language_version(MemorySegment self) {
        MethodHandle mh$ = ts_language_version.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_version", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_language_next_state$descriptor() {
        return ts_language_next_state.DESC;
    }

    public static MethodHandle ts_language_next_state$handle() {
        return ts_language_next_state.HANDLE;
    }

    public static MemorySegment ts_language_next_state$address() {
        return ts_language_next_state.ADDR;
    }

    public static short ts_language_next_state(MemorySegment self, short state, short symbol) {
        MethodHandle mh$ = ts_language_next_state.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_language_next_state", self, state, symbol);
            }
            return mh$.invokeExact(self, state, symbol);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_lookahead_iterator_new$descriptor() {
        return ts_lookahead_iterator_new.DESC;
    }

    public static MethodHandle ts_lookahead_iterator_new$handle() {
        return ts_lookahead_iterator_new.HANDLE;
    }

    public static MemorySegment ts_lookahead_iterator_new$address() {
        return ts_lookahead_iterator_new.ADDR;
    }

    public static MemorySegment ts_lookahead_iterator_new(MemorySegment self, short state) {
        MethodHandle mh$ = ts_lookahead_iterator_new.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_lookahead_iterator_new", self, state);
            }
            return mh$.invokeExact(self, state);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_lookahead_iterator_delete$descriptor() {
        return ts_lookahead_iterator_delete.DESC;
    }

    public static MethodHandle ts_lookahead_iterator_delete$handle() {
        return ts_lookahead_iterator_delete.HANDLE;
    }

    public static MemorySegment ts_lookahead_iterator_delete$address() {
        return ts_lookahead_iterator_delete.ADDR;
    }

    public static void ts_lookahead_iterator_delete(MemorySegment self) {
        MethodHandle mh$ = ts_lookahead_iterator_delete.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_lookahead_iterator_delete", self);
            }
            mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_lookahead_iterator_reset_state$descriptor() {
        return ts_lookahead_iterator_reset_state.DESC;
    }

    public static MethodHandle ts_lookahead_iterator_reset_state$handle() {
        return ts_lookahead_iterator_reset_state.HANDLE;
    }

    public static MemorySegment ts_lookahead_iterator_reset_state$address() {
        return ts_lookahead_iterator_reset_state.ADDR;
    }

    public static boolean ts_lookahead_iterator_reset_state(MemorySegment self, short state) {
        MethodHandle mh$ = ts_lookahead_iterator_reset_state.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_lookahead_iterator_reset_state", self, state);
            }
            return mh$.invokeExact(self, state);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_lookahead_iterator_reset$descriptor() {
        return ts_lookahead_iterator_reset.DESC;
    }

    public static MethodHandle ts_lookahead_iterator_reset$handle() {
        return ts_lookahead_iterator_reset.HANDLE;
    }

    public static MemorySegment ts_lookahead_iterator_reset$address() {
        return ts_lookahead_iterator_reset.ADDR;
    }

    public static boolean ts_lookahead_iterator_reset(MemorySegment self, MemorySegment language, short state) {
        MethodHandle mh$ = ts_lookahead_iterator_reset.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_lookahead_iterator_reset", self, language, state);
            }
            return mh$.invokeExact(self, language, state);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_lookahead_iterator_language$descriptor() {
        return ts_lookahead_iterator_language.DESC;
    }

    public static MethodHandle ts_lookahead_iterator_language$handle() {
        return ts_lookahead_iterator_language.HANDLE;
    }

    public static MemorySegment ts_lookahead_iterator_language$address() {
        return ts_lookahead_iterator_language.ADDR;
    }

    public static MemorySegment ts_lookahead_iterator_language(MemorySegment self) {
        MethodHandle mh$ = ts_lookahead_iterator_language.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_lookahead_iterator_language", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_lookahead_iterator_next$descriptor() {
        return ts_lookahead_iterator_next.DESC;
    }

    public static MethodHandle ts_lookahead_iterator_next$handle() {
        return ts_lookahead_iterator_next.HANDLE;
    }

    public static MemorySegment ts_lookahead_iterator_next$address() {
        return ts_lookahead_iterator_next.ADDR;
    }

    public static boolean ts_lookahead_iterator_next(MemorySegment self) {
        MethodHandle mh$ = ts_lookahead_iterator_next.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_lookahead_iterator_next", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_lookahead_iterator_current_symbol$descriptor() {
        return ts_lookahead_iterator_current_symbol.DESC;
    }

    public static MethodHandle ts_lookahead_iterator_current_symbol$handle() {
        return ts_lookahead_iterator_current_symbol.HANDLE;
    }

    public static MemorySegment ts_lookahead_iterator_current_symbol$address() {
        return ts_lookahead_iterator_current_symbol.ADDR;
    }

    public static short ts_lookahead_iterator_current_symbol(MemorySegment self) {
        MethodHandle mh$ = ts_lookahead_iterator_current_symbol.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_lookahead_iterator_current_symbol", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor ts_lookahead_iterator_current_symbol_name$descriptor() {
        return ts_lookahead_iterator_current_symbol_name.DESC;
    }

    public static MethodHandle ts_lookahead_iterator_current_symbol_name$handle() {
        return ts_lookahead_iterator_current_symbol_name.HANDLE;
    }

    public static MemorySegment ts_lookahead_iterator_current_symbol_name$address() {
        return ts_lookahead_iterator_current_symbol_name.ADDR;
    }

    public static MemorySegment ts_lookahead_iterator_current_symbol_name(MemorySegment self) {
        MethodHandle mh$ = ts_lookahead_iterator_current_symbol_name.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                TreeSitter.traceDowncall("ts_lookahead_iterator_current_symbol_name", self);
            }
            return mh$.invokeExact(self);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class free {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("free");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private free() {
        }
    }

    private static class ts_parser_new {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, new MemoryLayout[0]);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_new");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_new() {
        }
    }

    private static class ts_parser_delete {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_delete");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_delete() {
        }
    }

    private static class ts_parser_language {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_language");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_language() {
        }
    }

    private static class ts_parser_set_language {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_set_language");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_set_language() {
        }
    }

    private static class ts_parser_set_included_ranges {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_set_included_ranges");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_set_included_ranges() {
        }
    }

    private static class ts_parser_included_ranges {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_included_ranges");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_included_ranges() {
        }
    }

    private static class ts_parser_parse {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, TSInput.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_parse");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_parse() {
        }
    }

    private static class ts_parser_parse_string {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_parse_string");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_parse_string() {
        }
    }

    private static class ts_parser_parse_string_encoding {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_INT, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_parse_string_encoding");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_parse_string_encoding() {
        }
    }

    private static class ts_parser_reset {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_reset");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_reset() {
        }
    }

    private static class ts_parser_set_timeout_micros {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_set_timeout_micros");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_set_timeout_micros() {
        }
    }

    private static class ts_parser_timeout_micros {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_timeout_micros");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_timeout_micros() {
        }
    }

    private static class ts_parser_set_cancellation_flag {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_set_cancellation_flag");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_set_cancellation_flag() {
        }
    }

    private static class ts_parser_cancellation_flag {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_cancellation_flag");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_cancellation_flag() {
        }
    }

    private static class ts_parser_set_logger {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, TSLogger.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_set_logger");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_set_logger() {
        }
    }

    private static class ts_parser_logger {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSLogger.layout(), C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_logger");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_logger() {
        }
    }

    private static class ts_parser_print_dot_graphs {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_parser_print_dot_graphs");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_parser_print_dot_graphs() {
        }
    }

    private static class ts_tree_copy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_copy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_copy() {
        }
    }

    private static class ts_tree_delete {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_delete");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_delete() {
        }
    }

    private static class ts_tree_root_node {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_root_node");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_root_node() {
        }
    }

    private static class ts_tree_root_node_with_offset {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), C_POINTER, C_INT, TSPoint.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_root_node_with_offset");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_root_node_with_offset() {
        }
    }

    private static class ts_tree_language {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_language");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_language() {
        }
    }

    private static class ts_tree_included_ranges {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_included_ranges");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_included_ranges() {
        }
    }

    private static class ts_tree_edit {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_edit");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_edit() {
        }
    }

    private static class ts_tree_get_changed_ranges {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_get_changed_ranges");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_get_changed_ranges() {
        }
    }

    private static class ts_tree_print_dot_graph {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_print_dot_graph");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_print_dot_graph() {
        }
    }

    private static class ts_node_type {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_type");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_type() {
        }
    }

    private static class ts_node_symbol {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_symbol");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_symbol() {
        }
    }

    private static class ts_node_language {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_language");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_language() {
        }
    }

    private static class ts_node_grammar_type {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_grammar_type");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_grammar_type() {
        }
    }

    private static class ts_node_grammar_symbol {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_grammar_symbol");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_grammar_symbol() {
        }
    }

    private static class ts_node_start_byte {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_start_byte");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_start_byte() {
        }
    }

    private static class ts_node_start_point {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSPoint.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_start_point");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_start_point() {
        }
    }

    private static class ts_node_end_byte {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_end_byte");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_end_byte() {
        }
    }

    private static class ts_node_end_point {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSPoint.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_end_point");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_end_point() {
        }
    }

    private static class ts_node_string {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_string");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_string() {
        }
    }

    private static class ts_node_is_null {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_is_null");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_is_null() {
        }
    }

    private static class ts_node_is_named {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_is_named");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_is_named() {
        }
    }

    private static class ts_node_is_missing {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_is_missing");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_is_missing() {
        }
    }

    private static class ts_node_is_extra {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_is_extra");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_is_extra() {
        }
    }

    private static class ts_node_has_changes {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_has_changes");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_has_changes() {
        }
    }

    private static class ts_node_has_error {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_has_error");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_has_error() {
        }
    }

    private static class ts_node_is_error {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_is_error");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_is_error() {
        }
    }

    private static class ts_node_parse_state {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_parse_state");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_parse_state() {
        }
    }

    private static class ts_node_next_parse_state {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_next_parse_state");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_next_parse_state() {
        }
    }

    private static class ts_node_parent {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_parent");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_parent() {
        }
    }

    private static class ts_node_child_containing_descendant {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_child_containing_descendant");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_child_containing_descendant() {
        }
    }

    private static class ts_node_child {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_child");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_child() {
        }
    }

    private static class ts_node_field_name_for_child {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, TSNode.layout(), C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_field_name_for_child");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_field_name_for_child() {
        }
    }

    private static class ts_node_child_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_child_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_child_count() {
        }
    }

    private static class ts_node_named_child {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_named_child");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_named_child() {
        }
    }

    private static class ts_node_named_child_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_named_child_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_named_child_count() {
        }
    }

    private static class ts_node_child_by_field_name {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_child_by_field_name");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_child_by_field_name() {
        }
    }

    private static class ts_node_child_by_field_id {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), C_SHORT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_child_by_field_id");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_child_by_field_id() {
        }
    }

    private static class ts_node_next_sibling {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_next_sibling");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_next_sibling() {
        }
    }

    private static class ts_node_prev_sibling {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_prev_sibling");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_prev_sibling() {
        }
    }

    private static class ts_node_next_named_sibling {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_next_named_sibling");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_next_named_sibling() {
        }
    }

    private static class ts_node_prev_named_sibling {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_prev_named_sibling");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_prev_named_sibling() {
        }
    }

    private static class ts_node_first_child_for_byte {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_first_child_for_byte");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_first_child_for_byte() {
        }
    }

    private static class ts_node_first_named_child_for_byte {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_first_named_child_for_byte");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_first_named_child_for_byte() {
        }
    }

    private static class ts_node_descendant_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_descendant_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_descendant_count() {
        }
    }

    private static class ts_node_descendant_for_byte_range {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), C_INT, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_descendant_for_byte_range");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_descendant_for_byte_range() {
        }
    }

    private static class ts_node_descendant_for_point_range {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), TSPoint.layout(), TSPoint.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_descendant_for_point_range");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_descendant_for_point_range() {
        }
    }

    private static class ts_node_named_descendant_for_byte_range {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), C_INT, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_named_descendant_for_byte_range");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_named_descendant_for_byte_range() {
        }
    }

    private static class ts_node_named_descendant_for_point_range {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), TSNode.layout(), TSPoint.layout(), TSPoint.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_named_descendant_for_point_range");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_named_descendant_for_point_range() {
        }
    }

    private static class ts_node_edit {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_edit");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_edit() {
        }
    }

    private static class ts_node_eq {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, TSNode.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_node_eq");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_node_eq() {
        }
    }

    private static class ts_tree_cursor_new {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSTreeCursor.layout(), TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_new");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_new() {
        }
    }

    private static class ts_tree_cursor_delete {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_delete");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_delete() {
        }
    }

    private static class ts_tree_cursor_reset {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_reset");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_reset() {
        }
    }

    private static class ts_tree_cursor_reset_to {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_reset_to");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_reset_to() {
        }
    }

    private static class ts_tree_cursor_current_node {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSNode.layout(), C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_current_node");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_current_node() {
        }
    }

    private static class ts_tree_cursor_current_field_name {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_current_field_name");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_current_field_name() {
        }
    }

    private static class ts_tree_cursor_current_field_id {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_current_field_id");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_current_field_id() {
        }
    }

    private static class ts_tree_cursor_goto_parent {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_goto_parent");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_goto_parent() {
        }
    }

    private static class ts_tree_cursor_goto_next_sibling {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_goto_next_sibling");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_goto_next_sibling() {
        }
    }

    private static class ts_tree_cursor_goto_previous_sibling {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_goto_previous_sibling");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_goto_previous_sibling() {
        }
    }

    private static class ts_tree_cursor_goto_first_child {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_goto_first_child");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_goto_first_child() {
        }
    }

    private static class ts_tree_cursor_goto_last_child {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_goto_last_child");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_goto_last_child() {
        }
    }

    private static class ts_tree_cursor_goto_descendant {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_goto_descendant");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_goto_descendant() {
        }
    }

    private static class ts_tree_cursor_current_descendant_index {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_current_descendant_index");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_current_descendant_index() {
        }
    }

    private static class ts_tree_cursor_current_depth {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_current_depth");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_current_depth() {
        }
    }

    private static class ts_tree_cursor_goto_first_child_for_byte {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_goto_first_child_for_byte");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_goto_first_child_for_byte() {
        }
    }

    private static class ts_tree_cursor_goto_first_child_for_point {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER, TSPoint.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_goto_first_child_for_point");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_goto_first_child_for_point() {
        }
    }

    private static class ts_tree_cursor_copy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(TSTreeCursor.layout(), C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_tree_cursor_copy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_tree_cursor_copy() {
        }
    }

    private static class ts_query_new {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_INT, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_new");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_new() {
        }
    }

    private static class ts_query_delete {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_delete");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_delete() {
        }
    }

    private static class ts_query_pattern_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_pattern_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_pattern_count() {
        }
    }

    private static class ts_query_capture_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_capture_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_capture_count() {
        }
    }

    private static class ts_query_string_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_string_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_string_count() {
        }
    }

    private static class ts_query_start_byte_for_pattern {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_start_byte_for_pattern");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_start_byte_for_pattern() {
        }
    }

    private static class ts_query_end_byte_for_pattern {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_end_byte_for_pattern");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_end_byte_for_pattern() {
        }
    }

    private static class ts_query_predicates_for_pattern {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_predicates_for_pattern");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_predicates_for_pattern() {
        }
    }

    private static class ts_query_is_pattern_rooted {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_is_pattern_rooted");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_is_pattern_rooted() {
        }
    }

    private static class ts_query_is_pattern_non_local {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_is_pattern_non_local");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_is_pattern_non_local() {
        }
    }

    private static class ts_query_is_pattern_guaranteed_at_step {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_is_pattern_guaranteed_at_step");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_is_pattern_guaranteed_at_step() {
        }
    }

    private static class ts_query_capture_name_for_id {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_capture_name_for_id");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_capture_name_for_id() {
        }
    }

    private static class ts_query_capture_quantifier_for_id {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_INT, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_capture_quantifier_for_id");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_capture_quantifier_for_id() {
        }
    }

    private static class ts_query_string_value_for_id {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_string_value_for_id");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_string_value_for_id() {
        }
    }

    private static class ts_query_disable_capture {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_disable_capture");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_disable_capture() {
        }
    }

    private static class ts_query_disable_pattern {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_disable_pattern");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_disable_pattern() {
        }
    }

    private static class ts_query_cursor_new {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, new MemoryLayout[0]);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_new");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_new() {
        }
    }

    private static class ts_query_cursor_delete {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_delete");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_delete() {
        }
    }

    private static class ts_query_cursor_exec {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, TSNode.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_exec");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_exec() {
        }
    }

    private static class ts_query_cursor_did_exceed_match_limit {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_did_exceed_match_limit");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_did_exceed_match_limit() {
        }
    }

    private static class ts_query_cursor_match_limit {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_match_limit");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_match_limit() {
        }
    }

    private static class ts_query_cursor_set_match_limit {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_set_match_limit");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_set_match_limit() {
        }
    }

    private static class ts_query_cursor_set_timeout_micros {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_set_timeout_micros");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_set_timeout_micros() {
        }
    }

    private static class ts_query_cursor_timeout_micros {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_timeout_micros");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_timeout_micros() {
        }
    }

    private static class ts_query_cursor_set_byte_range {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_set_byte_range");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_set_byte_range() {
        }
    }

    private static class ts_query_cursor_set_point_range {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, TSPoint.layout(), TSPoint.layout());
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_set_point_range");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_set_point_range() {
        }
    }

    private static class ts_query_cursor_next_match {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_next_match");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_next_match() {
        }
    }

    private static class ts_query_cursor_remove_match {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_remove_match");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_remove_match() {
        }
    }

    private static class ts_query_cursor_next_capture {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_next_capture");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_next_capture() {
        }
    }

    private static class ts_query_cursor_set_max_start_depth {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_query_cursor_set_max_start_depth");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_query_cursor_set_max_start_depth() {
        }
    }

    private static class ts_language_copy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_copy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_copy() {
        }
    }

    private static class ts_language_delete {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_delete");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_delete() {
        }
    }

    private static class ts_language_symbol_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_symbol_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_symbol_count() {
        }
    }

    private static class ts_language_state_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_state_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_state_count() {
        }
    }

    private static class ts_language_symbol_name {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_symbol_name");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_symbol_name() {
        }
    }

    private static class ts_language_symbol_for_name {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, C_POINTER, C_POINTER, C_INT, C_BOOL);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_symbol_for_name");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_symbol_for_name() {
        }
    }

    private static class ts_language_field_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_field_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_field_count() {
        }
    }

    private static class ts_language_field_name_for_id {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_field_name_for_id");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_field_name_for_id() {
        }
    }

    private static class ts_language_field_id_for_name {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_field_id_for_name");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_field_id_for_name() {
        }
    }

    private static class ts_language_symbol_type {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_symbol_type");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_symbol_type() {
        }
    }

    private static class ts_language_version {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_version");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_version() {
        }
    }

    private static class ts_language_next_state {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, C_POINTER, C_SHORT, C_SHORT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_language_next_state");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_language_next_state() {
        }
    }

    private static class ts_lookahead_iterator_new {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_lookahead_iterator_new");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_lookahead_iterator_new() {
        }
    }

    private static class ts_lookahead_iterator_delete {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_lookahead_iterator_delete");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_lookahead_iterator_delete() {
        }
    }

    private static class ts_lookahead_iterator_reset_state {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_lookahead_iterator_reset_state");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_lookahead_iterator_reset_state() {
        }
    }

    private static class ts_lookahead_iterator_reset {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_lookahead_iterator_reset");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_lookahead_iterator_reset() {
        }
    }

    private static class ts_lookahead_iterator_language {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_lookahead_iterator_language");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_lookahead_iterator_language() {
        }
    }

    private static class ts_lookahead_iterator_next {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_lookahead_iterator_next");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_lookahead_iterator_next() {
        }
    }

    private static class ts_lookahead_iterator_current_symbol {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_lookahead_iterator_current_symbol");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_lookahead_iterator_current_symbol() {
        }
    }

    private static class ts_lookahead_iterator_current_symbol_name {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = TreeSitter.findOrThrow("ts_lookahead_iterator_current_symbol_name");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private ts_lookahead_iterator_current_symbol_name() {
        }
    }
}

