/*
 * Decompiled with CFR 0.152.
 */
package com.github.tennaito.rsql.jpa;

import com.github.tennaito.rsql.jpa.AbstractJpaVisitor;
import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;
import com.github.tennaito.rsql.misc.EntityManagerAdapter;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Root;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JpaCriteriaQueryVisitor<T>
extends AbstractJpaVisitor<CriteriaQuery<T>, T>
implements RSQLVisitor<CriteriaQuery<T>, EntityManagerAdapter> {
    private static final Logger LOG = Logger.getLogger(JpaCriteriaQueryVisitor.class.getName());
    private final JpaPredicateVisitor<T> predicateVisitor;

    public JpaCriteriaQueryVisitor(T ... t) {
        super(t);
        this.predicateVisitor = new JpaPredicateVisitor<T>(t);
    }

    protected JpaPredicateVisitor<T> getPredicateVisitor() {
        this.predicateVisitor.setBuilderTools(this.getBuilderTools());
        return this.predicateVisitor;
    }

    public CriteriaQuery<T> visit(AndNode node, EntityManagerAdapter entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for AndNode: {0}", node);
        CriteriaQuery criteria = entityManager.getCriteriaBuilder().createQuery(this.entityClass);
        Root root = criteria.from(this.entityClass);
        return criteria.where((Expression)this.getPredicateVisitor().defineRoot((From)root).visit(node, entityManager));
    }

    public CriteriaQuery<T> visit(OrNode node, EntityManagerAdapter entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for OrNode: {0}", node);
        CriteriaQuery criteria = entityManager.getCriteriaBuilder().createQuery(this.entityClass);
        Root root = criteria.from(this.entityClass);
        return criteria.where((Expression)this.getPredicateVisitor().defineRoot((From)root).visit(node, entityManager));
    }

    public CriteriaQuery<T> visit(ComparisonNode node, EntityManagerAdapter entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for ComparisonNode: {0}", node);
        CriteriaQuery criteria = entityManager.getCriteriaBuilder().createQuery(this.entityClass);
        Root root = criteria.from(this.entityClass);
        return criteria.where((Expression)this.getPredicateVisitor().defineRoot((From)root).visit(node, entityManager));
    }
}

