/*
 * Decompiled with CFR 0.152.
 */
package com.github.tennaito.rsql.jpa;

import com.github.tennaito.rsql.jpa.AbstractJpaVisitor;
import com.github.tennaito.rsql.jpa.PredicateBuilder;
import com.github.tennaito.rsql.misc.EntityManagerAdapter;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JpaPredicateVisitor<T>
extends AbstractJpaVisitor<Predicate, T>
implements RSQLVisitor<Predicate, EntityManagerAdapter> {
    private static final Logger LOG = Logger.getLogger(JpaPredicateVisitor.class.getName());
    private From root;

    public JpaPredicateVisitor(T ... t) {
        super(t);
    }

    public JpaPredicateVisitor<T> defineRoot(From root) {
        this.root = root;
        return this;
    }

    public Predicate visit(AndNode node, EntityManagerAdapter entityManager) {
        LOG.log(Level.INFO, "Creating Predicate for AndNode: {0}", node);
        return PredicateBuilder.createPredicate((LogicalNode)node, this.root, this.entityClass, entityManager, this.getBuilderTools());
    }

    public Predicate visit(OrNode node, EntityManagerAdapter entityManager) {
        LOG.log(Level.INFO, "Creating Predicate for OrNode: {0}", node);
        return PredicateBuilder.createPredicate((LogicalNode)node, this.root, this.entityClass, entityManager, this.getBuilderTools());
    }

    public Predicate visit(ComparisonNode node, EntityManagerAdapter entityManager) {
        LOG.log(Level.INFO, "Creating Predicate for ComparisonNode: {0}", node);
        return PredicateBuilder.createPredicate(node, this.root, this.entityClass, entityManager, this.getBuilderTools());
    }
}

