/*
 * Decompiled with CFR 0.152.
 */
package io.github.tsegismont.streamutils;

import io.github.tsegismont.streamutils.impl.FilteringStream;
import io.github.tsegismont.streamutils.impl.LimitingStream;
import io.github.tsegismont.streamutils.impl.MappingStream;
import io.github.tsegismont.streamutils.impl.SkippingStream;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.streams.ReadStream;
import java.util.function.Function;
import java.util.function.Predicate;

public class Streams {
    private Streams() {
    }

    public static <T, R> ReadStream<R> map(ReadStream<T> source, Function<T, R> mapping) {
        return new MappingStream<T, R>(source, mapping);
    }

    public static <T> ReadStream<T> filter(ReadStream<T> source, Predicate<T> predicate) {
        return new FilteringStream<T>(source, predicate);
    }

    public static <T> ReadStream<T> filter(ReadStream<T> source, Predicate<T> predicate, Vertx vertx) {
        return new FilteringStream<T>(source, predicate, vertx);
    }

    public static <T> ReadStream<T> filter(ReadStream<T> source, Predicate<T> predicate, Context context) {
        return new FilteringStream<T>(source, predicate, context);
    }

    public static <T> ReadStream<T> skip(ReadStream<T> source, long skip) {
        return new SkippingStream<T>(source, skip);
    }

    public static <T> ReadStream<T> limit(ReadStream<T> source, long limit) {
        return new LimitingStream<T>(source, limit);
    }
}

