/*
 * Decompiled with CFR 0.152.
 */
package io.github.tsegismont.streamutils.impl;

import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import java.util.Objects;
import java.util.function.Function;

public final class MappingStream<T, R>
implements ReadStream<R> {
    private final ReadStream<T> source;
    private final Function<T, R> mapping;

    public MappingStream(ReadStream<T> source, Function<T, R> mapping) {
        Objects.requireNonNull(source, "Source cannot be null");
        Objects.requireNonNull(mapping, "Mapping function cannot be null");
        this.source = source;
        this.mapping = mapping;
    }

    public ReadStream<R> exceptionHandler(Handler<Throwable> handler) {
        this.source.exceptionHandler(handler);
        return this;
    }

    public ReadStream<R> handler(Handler<R> handler) {
        if (handler == null) {
            this.source.handler(null);
        } else {
            this.source.handler(event -> handler.handle(this.mapping.apply(event)));
        }
        return this;
    }

    public ReadStream<R> pause() {
        this.source.pause();
        return this;
    }

    public ReadStream<R> resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    public ReadStream<R> fetch(long amount) {
        this.source.fetch(amount);
        return this;
    }

    public ReadStream<R> endHandler(Handler<Void> endHandler) {
        this.source.endHandler(endHandler);
        return this;
    }
}

