/*
 * Decompiled with CFR 0.152.
 */
package io.github.tsegismont.streamutils.impl;

import io.vertx.core.Handler;
import io.vertx.core.impl.Arguments;
import io.vertx.core.streams.ReadStream;
import java.util.Objects;

public final class SkippingStream<T>
implements ReadStream<T> {
    private final ReadStream<T> source;
    private final long skip;
    private long skipped;

    public SkippingStream(ReadStream<T> source, long skip) {
        Objects.requireNonNull(source, "Source cannot be null");
        Arguments.require((skip >= 0L ? 1 : 0) != 0, (String)"Skip amount must be positive");
        this.source = source;
        this.skip = skip;
    }

    public ReadStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.source.exceptionHandler(handler);
        return this;
    }

    public ReadStream<T> handler(Handler<T> handler) {
        if (handler == null) {
            this.source.handler(null);
            return this;
        }
        this.source.handler(item -> {
            boolean emit;
            SkippingStream skippingStream = this;
            synchronized (skippingStream) {
                if (this.skipped < this.skip) {
                    emit = false;
                    ++this.skipped;
                } else {
                    emit = true;
                }
            }
            if (emit) {
                handler.handle(item);
            }
        });
        return this;
    }

    public ReadStream<T> pause() {
        this.source.pause();
        return this;
    }

    public ReadStream<T> resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadStream<T> fetch(long l) {
        long value;
        SkippingStream skippingStream = this;
        synchronized (skippingStream) {
            value = this.skipped < this.skip ? (l < Long.MAX_VALUE - this.skip + this.skipped ? l + this.skip - this.skipped : Long.MAX_VALUE) : l;
        }
        this.source.fetch(value);
        return this;
    }

    public ReadStream<T> endHandler(Handler<Void> handler) {
        this.source.endHandler(handler);
        return this;
    }
}

