/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.DatatypeSort;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;

public class Constructor<R>
extends Z3Object {
    private final int n;

    Constructor(Context ctx, int n, long nativeObj) {
        super(ctx, nativeObj);
        this.n = n;
    }

    public int getNumFields() {
        return this.n;
    }

    public FuncDecl<DatatypeSort<R>> ConstructorDecl() {
        Native.LongPtr constructor = new Native.LongPtr();
        Native.LongPtr tester = new Native.LongPtr();
        long[] accessors = new long[this.n];
        Native.queryConstructor(this.getContext().nCtx(), this.getNativeObject(), this.n, constructor, tester, accessors);
        return new FuncDecl<DatatypeSort<R>>(this.getContext(), constructor.value);
    }

    public FuncDecl<BoolSort> getTesterDecl() {
        Native.LongPtr constructor = new Native.LongPtr();
        Native.LongPtr tester = new Native.LongPtr();
        long[] accessors = new long[this.n];
        Native.queryConstructor(this.getContext().nCtx(), this.getNativeObject(), this.n, constructor, tester, accessors);
        return new FuncDecl<BoolSort>(this.getContext(), tester.value);
    }

    public FuncDecl<?>[] getAccessorDecls() {
        Native.LongPtr constructor = new Native.LongPtr();
        Native.LongPtr tester = new Native.LongPtr();
        long[] accessors = new long[this.n];
        Native.queryConstructor(this.getContext().nCtx(), this.getNativeObject(), this.n, constructor, tester, accessors);
        FuncDecl[] t = new FuncDecl[this.n];
        for (int i = 0; i < this.n; ++i) {
            t[i] = new FuncDecl(this.getContext(), accessors[i]);
        }
        return t;
    }

    @Override
    void incRef() {
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getConstructorDRQ().storeReference(this.getContext(), this);
    }

    static <R> Constructor<R> of(Context ctx, Symbol name, Symbol recognizer, Symbol[] fieldNames, Sort[] sorts, int[] sortRefs) {
        int n = AST.arrayLength(fieldNames);
        if (n != AST.arrayLength(sorts)) {
            throw new Z3Exception("Number of field names does not match number of sorts");
        }
        if (sortRefs != null && sortRefs.length != n) {
            throw new Z3Exception("Number of field names does not match number of sort refs");
        }
        if (sortRefs == null) {
            sortRefs = new int[n];
        }
        long nativeObj = Native.mkConstructor(ctx.nCtx(), name.getNativeObject(), recognizer.getNativeObject(), n, Symbol.arrayToNative(fieldNames), Sort.arrayToNative(sorts), sortRefs);
        return new Constructor<R>(ctx, n, nativeObj);
    }
}

