/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Pattern;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;

public class Quantifier
extends BoolExpr {
    public boolean isUniversal() {
        return Native.isQuantifierForall(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isExistential() {
        return Native.isQuantifierExists(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getWeight() {
        return Native.getQuantifierWeight(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getNumPatterns() {
        return Native.getQuantifierNumPatterns(this.getContext().nCtx(), this.getNativeObject());
    }

    public Pattern[] getPatterns() {
        int n = this.getNumPatterns();
        Pattern[] res = new Pattern[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new Pattern(this.getContext(), Native.getQuantifierPatternAst(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public int getNumNoPatterns() {
        return Native.getQuantifierNumNoPatterns(this.getContext().nCtx(), this.getNativeObject());
    }

    public Pattern[] getNoPatterns() {
        int n = this.getNumNoPatterns();
        Pattern[] res = new Pattern[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new Pattern(this.getContext(), Native.getQuantifierNoPatternAst(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public int getNumBound() {
        return Native.getQuantifierNumBound(this.getContext().nCtx(), this.getNativeObject());
    }

    public Symbol[] getBoundVariableNames() {
        int n = this.getNumBound();
        Symbol[] res = new Symbol[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Symbol.create(this.getContext(), Native.getQuantifierBoundName(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public Sort[] getBoundVariableSorts() {
        int n = this.getNumBound();
        Sort[] res = new Sort[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Sort.create(this.getContext(), Native.getQuantifierBoundSort(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public BoolExpr getBody() {
        return (BoolExpr)Expr.create(this.getContext(), Native.getQuantifierBody(this.getContext().nCtx(), this.getNativeObject()));
    }

    @Override
    public Quantifier translate(Context ctx) {
        return (Quantifier)super.translate(ctx);
    }

    public static Quantifier of(Context ctx, boolean isForall, Sort[] sorts, Symbol[] names, Expr<BoolSort> body, int weight, Pattern[] patterns, Expr<?>[] noPatterns, Symbol quantifierID, Symbol skolemID) {
        ctx.checkContextMatch(patterns);
        ctx.checkContextMatch(noPatterns);
        ctx.checkContextMatch(sorts);
        ctx.checkContextMatch(names);
        ctx.checkContextMatch(body);
        if (sorts.length != names.length) {
            throw new Z3Exception("Number of sorts does not match number of names");
        }
        long nativeObj = noPatterns == null && quantifierID == null && skolemID == null ? Native.mkQuantifier(ctx.nCtx(), isForall, weight, AST.arrayLength(patterns), AST.arrayToNative(patterns), AST.arrayLength(sorts), AST.arrayToNative(sorts), Symbol.arrayToNative(names), body.getNativeObject()) : Native.mkQuantifierEx(ctx.nCtx(), isForall, weight, AST.getNativeObject(quantifierID), AST.getNativeObject(skolemID), AST.arrayLength(patterns), AST.arrayToNative(patterns), AST.arrayLength(noPatterns), AST.arrayToNative(noPatterns), AST.arrayLength(sorts), AST.arrayToNative(sorts), Symbol.arrayToNative(names), body.getNativeObject());
        return new Quantifier(ctx, nativeObj);
    }

    public static Quantifier of(Context ctx, boolean isForall, Expr<?>[] bound, Expr<BoolSort> body, int weight, Pattern[] patterns, Expr<?>[] noPatterns, Symbol quantifierID, Symbol skolemID) {
        ctx.checkContextMatch(noPatterns);
        ctx.checkContextMatch(patterns);
        ctx.checkContextMatch(body);
        long nativeObj = noPatterns == null && quantifierID == null && skolemID == null ? Native.mkQuantifierConst(ctx.nCtx(), isForall, weight, AST.arrayLength(bound), AST.arrayToNative(bound), AST.arrayLength(patterns), AST.arrayToNative(patterns), body.getNativeObject()) : Native.mkQuantifierConstEx(ctx.nCtx(), isForall, weight, AST.getNativeObject(quantifierID), AST.getNativeObject(skolemID), AST.arrayLength(bound), AST.arrayToNative(bound), AST.arrayLength(patterns), AST.arrayToNative(patterns), AST.arrayLength(noPatterns), AST.arrayToNative(noPatterns), body.getNativeObject());
        return new Quantifier(ctx, nativeObj);
    }

    Quantifier(Context ctx, long obj) {
        super(ctx, obj);
    }

    @Override
    void checkNativeObject(long obj) {
        if (Native.getAstKind(this.getContext().nCtx(), obj) != Z3_ast_kind.Z3_QUANTIFIER_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a quantifier");
        }
        super.checkNativeObject(obj);
    }
}

