/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ArraySort;
import com.microsoft.z3.BitVecSort;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.DatatypeSort;
import com.microsoft.z3.FPRMSort;
import com.microsoft.z3.FPSort;
import com.microsoft.z3.FiniteDomainSort;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.Native;
import com.microsoft.z3.ReSort;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.RelationSort;
import com.microsoft.z3.SeqSort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.UninterpretedSort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_sort_kind;

public class Sort
extends AST {
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)o;
        return this.getContext().nCtx() == other.getContext().nCtx() && Native.isEqSort(this.getContext().nCtx(), this.getNativeObject(), other.getNativeObject());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int getId() {
        return Native.getSortId(this.getContext().nCtx(), this.getNativeObject());
    }

    public Z3_sort_kind getSortKind() {
        return Z3_sort_kind.fromInt(Native.getSortKind(this.getContext().nCtx(), this.getNativeObject()));
    }

    public Symbol getName() {
        return Symbol.create(this.getContext(), Native.getSortName(this.getContext().nCtx(), this.getNativeObject()));
    }

    @Override
    public String toString() {
        return Native.sortToString(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    public Sort translate(Context ctx) {
        return (Sort)super.translate(ctx);
    }

    Sort(Context ctx, long obj) {
        super(ctx, obj);
    }

    @Override
    void checkNativeObject(long obj) {
        if (Native.getAstKind(this.getContext().nCtx(), obj) != Z3_ast_kind.Z3_SORT_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a sort");
        }
        super.checkNativeObject(obj);
    }

    static Sort create(Context ctx, long obj) {
        Z3_sort_kind sk = Z3_sort_kind.fromInt(Native.getSortKind(ctx.nCtx(), obj));
        switch (sk) {
            case Z3_ARRAY_SORT: {
                return new ArraySort(ctx, obj);
            }
            case Z3_BOOL_SORT: {
                return new BoolSort(ctx, obj);
            }
            case Z3_BV_SORT: {
                return new BitVecSort(ctx, obj);
            }
            case Z3_DATATYPE_SORT: {
                return new DatatypeSort(ctx, obj);
            }
            case Z3_INT_SORT: {
                return new IntSort(ctx, obj);
            }
            case Z3_REAL_SORT: {
                return new RealSort(ctx, obj);
            }
            case Z3_UNINTERPRETED_SORT: {
                return new UninterpretedSort(ctx, obj);
            }
            case Z3_FINITE_DOMAIN_SORT: {
                return new FiniteDomainSort(ctx, obj);
            }
            case Z3_RELATION_SORT: {
                return new RelationSort(ctx, obj);
            }
            case Z3_FLOATING_POINT_SORT: {
                return new FPSort(ctx, obj);
            }
            case Z3_ROUNDING_MODE_SORT: {
                return new FPRMSort(ctx, obj);
            }
            case Z3_SEQ_SORT: {
                return new SeqSort(ctx, obj);
            }
            case Z3_RE_SORT: {
                return new ReSort(ctx, obj);
            }
        }
        throw new Z3Exception("Unknown sort kind");
    }
}

