/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class Z3Loader {
    private Z3Loader() {
        throw new AssertionError();
    }

    static void loadZ3() {
        Path libZ3JavaOut;
        Path libZ3Out;
        OperatingSystem os = OperatingSystem.identify();
        CPUArchitecture cpu = CPUArchitecture.identify();
        Class<Z3Loader> clazz = Z3Loader.class;
        InputStream libZ3 = clazz.getResourceAsStream(Z3Loader.getLibraryPath(os, cpu, "z3"));
        InputStream libZ3Java = clazz.getResourceAsStream(Z3Loader.getLibraryPath(os, cpu, "z3java"));
        Z3Loader.assertLibrariesFound(libZ3, libZ3Java, os, cpu);
        try {
            Path libraryDir = Files.createTempDirectory("z3-turnkey", new FileAttribute[0]);
            libraryDir.toFile().deleteOnExit();
            libZ3Out = libraryDir.resolve(Z3Loader.getLibraryName(os, "z3"));
            libZ3Out.toFile().deleteOnExit();
            libZ3JavaOut = libraryDir.resolve(Z3Loader.getLibraryName(os, "z3java"));
            libZ3JavaOut.toFile().deleteOnExit();
            Z3Loader.unpackLibrary(libZ3, libZ3Out);
            Z3Loader.unpackLibrary(libZ3Java, libZ3JavaOut);
        }
        catch (IOException e) {
            throw new LinkageError("Could not unpack native libraries", e);
        }
        System.load(libZ3Out.toAbsolutePath().toString());
        System.load(libZ3JavaOut.toAbsolutePath().toString());
    }

    private static String getLibraryPath(OperatingSystem os, CPUArchitecture cpu, String library) {
        return "/native/" + os.name + "-" + cpu.name + "/" + Z3Loader.getLibraryName(os, library);
    }

    private static String getLibraryName(OperatingSystem os, String library) {
        return "lib" + library + "." + os.libraryExtension;
    }

    private static void assertLibrariesFound(InputStream libZ3, InputStream libZ3Java, OperatingSystem os, CPUArchitecture cpu) {
        if (libZ3 == null && libZ3Java == null) {
            throw new UnsatisfiedLinkError("No native libraries present for " + (Object)((Object)os) + " on " + (Object)((Object)cpu));
        }
        if (libZ3 == null) {
            throw new IllegalStateException("Z3 native library is missing from the distribution. This is a packaging error.");
        }
        if (libZ3Java == null) {
            throw new IllegalStateException("Z3 native java support library is missing from the distribution. This is a packaging error.");
        }
    }

    private static void unpackLibrary(InputStream lib, Path destination) throws IOException {
        try (OutputStream out = Files.newOutputStream(destination, new OpenOption[0]);){
            Z3Loader.copy(lib, out);
        }
        lib.close();
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer, 0, buffer.length)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    private static enum CPUArchitecture {
        X86("x86"),
        AMD64("amd64");

        final String name;

        private CPUArchitecture(String name) {
            this.name = name;
        }

        static CPUArchitecture identify() {
            String osArch;
            switch (osArch = System.getProperty("os.arch")) {
                case "i386": 
                case "i686": {
                    return X86;
                }
                case "amd64": 
                case "x86_64": {
                    return AMD64;
                }
            }
            throw new UnsatisfiedLinkError("Unsupported CPU architecture: " + osArch);
        }
    }

    private static enum OperatingSystem {
        OS_X("osx", "dylib"),
        LINUX("linux", "so"),
        WINDOWS("windows", "dll");

        final String name;
        final String libraryExtension;

        private OperatingSystem(String name, String libraryExtension) {
            this.name = name;
            this.libraryExtension = libraryExtension;
        }

        static OperatingSystem identify() {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Darwin") || osName.startsWith("Mac")) {
                return OS_X;
            }
            if (osName.startsWith("Linux")) {
                return LINUX;
            }
            if (osName.startsWith("Windows")) {
                return WINDOWS;
            }
            throw new UnsatisfiedLinkError("Unsupported operating system: " + osName);
        }
    }
}

