/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.javacc.GrammarDirectoryScanner;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JJDoc;

public class JJDocMojo
extends AbstractMavenReport {
    private MavenProject project;
    private Renderer siteRenderer;
    private File[] sourceDirectories;
    private File defaultGrammarDirectoryJavaCC;
    private File defaultGrammarDirectoryJJTree;
    private File defaultGrammarDirectoryJTB;
    private String jjdocDirectory;
    private File outputDirectory;
    private String grammarEncoding;
    private String outputEncoding;
    private String cssHref;
    private Boolean text;
    private Boolean bnf;
    private boolean oneTable;

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    private File getJJDocOutputDirectory() {
        return new File(this.getReportOutputDirectory(), this.jjdocDirectory);
    }

    private File[] getSourceDirectories() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        if (this.sourceDirectories != null && this.sourceDirectories.length > 0) {
            linkedHashSet.addAll(Arrays.asList(this.sourceDirectories));
        } else {
            if (this.defaultGrammarDirectoryJavaCC != null) {
                linkedHashSet.add(this.defaultGrammarDirectoryJavaCC);
            }
            if (this.defaultGrammarDirectoryJJTree != null) {
                linkedHashSet.add(this.defaultGrammarDirectoryJJTree);
            }
            if (this.defaultGrammarDirectoryJTB != null) {
                linkedHashSet.add(this.defaultGrammarDirectoryJTB);
            }
        }
        return linkedHashSet.toArray(new File[linkedHashSet.size()]);
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jjdoc.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jjdoc.short.description");
    }

    public String getOutputName() {
        return this.jjdocDirectory + "/index";
    }

    public boolean canGenerateReport() {
        File[] fileArray;
        for (File file : fileArray = this.getSourceDirectories()) {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length <= 0) continue;
            return true;
        }
        return false;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        File[] fileArray;
        Sink sink = this.getSink();
        this.createReportHeader(this.getBundle(locale), sink);
        for (File file : fileArray = this.getSourceDirectories()) {
            GrammarInfo[] grammarInfoArray = this._scanForGrammars(file);
            if (grammarInfoArray == null) {
                this.getLog().debug((CharSequence)("Skipping non-existing source directory: " + file));
                continue;
            }
            Arrays.sort(grammarInfoArray, GrammarInfoComparator.getInstance());
            for (GrammarInfo grammarInfo : grammarInfoArray) {
                File file2 = grammarInfo.getGrammarFile();
                String string = grammarInfo.getRelativeGrammarFile();
                string = string.replaceAll("(?i)\\.(jj|jjt|jtb)$", this.getOutputFileExtension());
                File file3 = new File(this.getJJDocOutputDirectory(), string);
                JJDoc jJDoc = this.newJJDoc();
                jJDoc.setInputFile(file2);
                jJDoc.setOutputFile(file3);
                try {
                    jJDoc.run();
                }
                catch (Exception exception) {
                    throw new MavenReportException("Failed to create BNF documentation: " + file2, exception);
                }
                this.createReportLink(sink, file, file2, string);
            }
        }
        this.createReportFooter(sink);
        sink.flush();
        sink.close();
    }

    private String getOutputFileExtension() {
        if (Boolean.TRUE.equals(this.text) || Boolean.TRUE.equals(this.bnf)) {
            return ".txt";
        }
        return ".html";
    }

    private void createReportHeader(ResourceBundle resourceBundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(resourceBundle.getString("report.jjdoc.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(resourceBundle.getString("report.jjdoc.title"));
        sink.sectionTitle1_();
        sink.text(resourceBundle.getString("report.jjdoc.description"));
        sink.section1_();
        sink.lineBreak();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(resourceBundle.getString("report.jjdoc.table.heading"));
        sink.tableHeaderCell_();
        sink.tableRow_();
    }

    private void createReportLink(Sink sink, File file, File file2, String string) {
        sink.tableRow();
        sink.tableCell();
        String string2 = string;
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        sink.link(string2);
        String string3 = file.toURI().relativize(file2.toURI()).toString();
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        sink.text(string3);
        sink.link_();
        sink.tableCell_();
        sink.tableRow_();
    }

    private void createReportFooter(Sink sink) {
        sink.table_();
        sink.body_();
    }

    private JJDoc newJJDoc() {
        JJDoc jJDoc = new JJDoc();
        jJDoc.setLog(this.getLog());
        jJDoc.setGrammarEncoding(this.grammarEncoding);
        jJDoc.setOutputEncoding(this.outputEncoding);
        jJDoc.setCssHref(this.cssHref);
        jJDoc.setText(this.text);
        jJDoc.setBnf(this.bnf);
        jJDoc.setOneTable(this.oneTable);
        return jJDoc;
    }

    private GrammarInfo[] _scanForGrammars(File file) throws MavenReportException {
        GrammarInfo[] grammarInfoArray;
        if (!file.isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + file));
        try {
            String[] stringArray = new String[]{"**/*.jj", "**/*.JJ", "**/*.jjt", "**/*.JJT", "**/*.jtb", "**/*.JTB"};
            GrammarDirectoryScanner grammarDirectoryScanner = new GrammarDirectoryScanner();
            grammarDirectoryScanner.setSourceDirectory(file);
            grammarDirectoryScanner.setIncludes(stringArray);
            grammarDirectoryScanner.scan();
            grammarInfoArray = grammarDirectoryScanner.getIncludedGrammars();
        }
        catch (Exception exception) {
            throw new MavenReportException("Failed to scan for grammars: " + file, exception);
        }
        this.getLog().debug((CharSequence)("Found grammars: " + Arrays.asList(grammarInfoArray)));
        return grammarInfoArray;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jjdoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private static class GrammarInfoComparator
    implements Comparator<GrammarInfo> {
        private static final GrammarInfoComparator INSTANCE = new GrammarInfoComparator();

        private GrammarInfoComparator() {
        }

        public static GrammarInfoComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(GrammarInfo grammarInfo, GrammarInfo grammarInfo2) {
            int n;
            String[] stringArray = grammarInfo.getRelativeGrammarFile().split("\\" + File.separatorChar);
            String[] stringArray2 = grammarInfo2.getRelativeGrammarFile().split("\\" + File.separatorChar);
            int n2 = Math.min(stringArray.length, stringArray2.length) - 1;
            for (int i = 0; i < n2; ++i) {
                n = stringArray[i].compareToIgnoreCase(stringArray2[i]);
                if (n == 0) continue;
                return n;
            }
            n = stringArray.length - stringArray2.length;
            if (n != 0) {
                return n;
            }
            return stringArray[stringArray.length - 1].compareToIgnoreCase(stringArray2[stringArray.length - 1]);
        }
    }
}

