/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import de.janno.evaluator.dice.BracketPair;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Parameters;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.Roller;
import de.janno.evaluator.dice.Token;
import de.janno.evaluator.dice.Tokenizer;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.function.Cancel;
import de.janno.evaluator.dice.function.Color;
import de.janno.evaluator.dice.function.Concat;
import de.janno.evaluator.dice.function.Double;
import de.janno.evaluator.dice.function.GroupCount;
import de.janno.evaluator.dice.function.IfEqual;
import de.janno.evaluator.dice.function.IfGreater;
import de.janno.evaluator.dice.function.IfIn;
import de.janno.evaluator.dice.function.IfLesser;
import de.janno.evaluator.dice.function.Max;
import de.janno.evaluator.dice.function.Min;
import de.janno.evaluator.dice.function.Replace;
import de.janno.evaluator.dice.function.SortAsc;
import de.janno.evaluator.dice.function.SortDesc;
import de.janno.evaluator.dice.function.Value;
import de.janno.evaluator.dice.operator.die.ExplodingAddDice;
import de.janno.evaluator.dice.operator.die.ExplodingDice;
import de.janno.evaluator.dice.operator.die.RegularDice;
import de.janno.evaluator.dice.operator.die.Reroll;
import de.janno.evaluator.dice.operator.list.Count;
import de.janno.evaluator.dice.operator.list.EqualFilter;
import de.janno.evaluator.dice.operator.list.GreaterEqualThanFilter;
import de.janno.evaluator.dice.operator.list.GreaterThanFilter;
import de.janno.evaluator.dice.operator.list.KeepHighest;
import de.janno.evaluator.dice.operator.list.KeepLowest;
import de.janno.evaluator.dice.operator.list.LesserEqualThanFilter;
import de.janno.evaluator.dice.operator.list.LesserThanFilter;
import de.janno.evaluator.dice.operator.list.Repeat;
import de.janno.evaluator.dice.operator.list.RepeatList;
import de.janno.evaluator.dice.operator.list.Sum;
import de.janno.evaluator.dice.operator.math.Appending;
import de.janno.evaluator.dice.operator.math.Divide;
import de.janno.evaluator.dice.operator.math.Modulo;
import de.janno.evaluator.dice.operator.math.Multiply;
import de.janno.evaluator.dice.operator.math.NegateOrNegativAppending;
import de.janno.evaluator.dice.random.NumberSupplier;
import de.janno.evaluator.dice.random.RandomNumberSupplier;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

public class DiceEvaluator {
    private static final int DEFAULT_MAX_NUMBER_OF_DICE = 1000;
    private static final String SEPARATOR = ",";
    private static final String LEGACY_LIST_SEPARATOR = "/";
    private static final Pattern LIST_REGEX = Pattern.compile("(.+([%s%s].+)+)".formatted(",", "/"));
    private final Tokenizer tokenizer;
    private final Parameters parameters;

    public DiceEvaluator() {
        this(new RandomNumberSupplier(), 1000);
    }

    public DiceEvaluator(@NonNull NumberSupplier numberSupplier, int maxNumberOfDice) {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        this.parameters = Parameters.builder().expressionBracket(BracketPair.PARENTHESES).functionBracket(BracketPair.PARENTHESES).escapeBracket(BracketPair.APOSTROPHE).escapeBracket(BracketPair.BRACKETS).operators((Collection<? extends Operator>)ImmutableList.builder().add((Object)new RegularDice(numberSupplier, maxNumberOfDice)).add((Object)new ExplodingDice(numberSupplier, maxNumberOfDice)).add((Object)new ExplodingAddDice(numberSupplier, maxNumberOfDice)).add((Object)new Appending()).add((Object)new Sum()).add((Object)new Repeat()).add((Object)new RepeatList()).add((Object)new NegateOrNegativAppending()).add((Object)new Divide()).add((Object)new Multiply()).add((Object)new Modulo()).add((Object)new KeepHighest()).add((Object)new KeepLowest()).add((Object)new GreaterThanFilter()).add((Object)new LesserThanFilter()).add((Object)new GreaterEqualThanFilter()).add((Object)new LesserEqualThanFilter()).add((Object)new EqualFilter()).add((Object)new Count()).add((Object)new Reroll()).build()).functions((Collection<? extends Function>)ImmutableList.builder().add((Object)new Color()).add((Object)new Value()).add((Object)new Concat()).add((Object)new SortAsc()).add((Object)new SortDesc()).add((Object)new Min()).add((Object)new Max()).add((Object)new Cancel()).add((Object)new Double()).add((Object)new IfEqual()).add((Object)new IfGreater()).add((Object)new IfIn()).add((Object)new Replace()).add((Object)new IfLesser()).add((Object)new GroupCount()).build()).separator(SEPARATOR).build();
        this.tokenizer = new Tokenizer(this.parameters);
    }

    public static String getHelpText() {
        URL url = Resources.getResource((String)"help.md");
        try {
            return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<RollBuilder> reverse(Collection<RollBuilder> collection) {
        ArrayList<RollBuilder> result = new ArrayList<RollBuilder>(collection.size());
        for (RollBuilder t : collection) {
            result.add(0, t);
        }
        return result;
    }

    private static boolean hasStackTokenPrecedence(Token currentToken, Token stackToken) {
        return stackToken.getOperator().isPresent() && (Operator.Associativity.LEFT.equals((Object)currentToken.getOperatorAssociativity().orElseThrow()) && currentToken.getOperatorPrecedence().orElseThrow() <= stackToken.getOperatorPrecedence().orElseThrow() || currentToken.getOperatorPrecedence().orElseThrow() < stackToken.getOperatorPrecedence().orElseThrow());
    }

    public static Roller createRollSupplier(List<RollBuilder> rollBuilders) {
        return () -> {
            HashMap<String, Roll> constantMap = new HashMap<String, Roll>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RollBuilder rs : rollBuilders) {
                List<Roll> r = rs.extendRoll(constantMap);
                builder.addAll(r);
            }
            return builder.build();
        };
    }

    @NonNull
    private RollBuilder toValue(@NonNull String literal) {
        if (literal == null) {
            throw new NullPointerException("literal is marked non-null but is null");
        }
        Matcher matcher = LIST_REGEX.matcher(literal);
        if (matcher.find()) {
            List<String> list = Arrays.asList(matcher.group(1).split("[%s%s]".formatted(SEPARATOR, LEGACY_LIST_SEPARATOR)));
            return constants -> ImmutableList.of((Object)new Roll(list.toString(), (ImmutableList<RollElement>)((ImmutableList)list.stream().map(String::trim).map(s -> new RollElement((String)s, "")).collect(ImmutableList.toImmutableList())), UniqueRandomElements.empty(), (ImmutableList<Roll>)ImmutableList.of()));
        }
        return constants -> {
            if (constants.containsKey(literal)) {
                return ImmutableList.of((Object)((Roll)constants.get(literal)));
            }
            return ImmutableList.of((Object)new Roll(literal, (ImmutableList<RollElement>)ImmutableList.of((Object)new RollElement(literal, "")), UniqueRandomElements.empty(), (ImmutableList<Roll>)ImmutableList.of()));
        };
    }

    private void processTokenToValues(Deque<RollBuilder> values, Token token) throws ExpressionException {
        if (token.getLiteral().isPresent()) {
            String literal = token.getLiteral().get();
            values.push(this.toValue(literal));
        } else if (token.getOperator().isPresent()) {
            Operator operator = token.getOperator().get();
            int argumentCount = token.getOperatorType().orElseThrow().argumentCount;
            if (values.size() < argumentCount) {
                throw new ExpressionException("Not enough values, %s needs %d".formatted(operator.getName(), argumentCount));
            }
            values.push(operator.evaluate(this.getArguments(values, argumentCount)));
        } else {
            throw new ExpressionException(token.toString());
        }
    }

    private void doFunction(Deque<RollBuilder> values, Function function, int argumentCount) throws ExpressionException {
        if (function.getMinArgumentCount() > argumentCount || function.getMaxArgumentCount() < argumentCount || values.size() < argumentCount) {
            throw new ExpressionException("Invalid argument count for %s".formatted(function.getName()));
        }
        RollBuilder res = function.evaluate(this.getArguments(values, argumentCount));
        values.push(res);
    }

    private List<RollBuilder> getArguments(Deque<RollBuilder> values, int argumentCount) {
        ArrayList<RollBuilder> result = new ArrayList<RollBuilder>(argumentCount);
        for (int i = 0; i < argumentCount; ++i) {
            result.add(0, values.pop());
        }
        return result;
    }

    private boolean isFunctionOpenBracket(Token token) {
        if (token == null || !token.isOpenBracket()) {
            return false;
        }
        return this.parameters.getFunctionBrackets().contains(token.getBrackets().orElseThrow());
    }

    public List<Roll> evaluate(String expression) throws ExpressionException {
        return this.buildRollSupplier(expression).roll();
    }

    public Roller buildRollSupplier(String expression) throws ExpressionException {
        if (Strings.isNullOrEmpty((String)(expression = expression.trim()))) {
            return ImmutableList::of;
        }
        List<Token> tokens = this.tokenizer.tokenize(expression);
        ArrayDeque<RollBuilder> values = new ArrayDeque<RollBuilder>(tokens.size());
        ArrayDeque<Token> stack = new ArrayDeque<Token>(tokens.size());
        ArrayDeque<Integer> previousValuesSize = new ArrayDeque<Integer>(tokens.size());
        Optional<Token> previous = Optional.empty();
        for (Token token : tokens) {
            if (previous.flatMap(Token::getFunction).isPresent() && !this.isFunctionOpenBracket(token)) {
                String functionName = previous.flatMap(Token::getFunction).map(Function::getName).orElseThrow();
                String allowedBrackets = this.parameters.getFunctionBrackets().stream().map(BracketPair::getOpen).collect(Collectors.joining(" or "));
                throw new ExpressionException("A function, in this case '%s', must be followed a open function bracket: %s".formatted(functionName, allowedBrackets));
            }
            if (token.getBrackets().isPresent() && token.isOpenBracket()) {
                stack.push(token);
                if (previous.flatMap(Token::getFunction).isPresent()) {
                    if (!this.parameters.getFunctionBrackets().contains(token.getBrackets().get())) {
                        throw new ExpressionException("Invalid bracket after function: %s".formatted(token));
                    }
                } else if (!this.parameters.getExpressionBrackets().contains(token.getBrackets().get())) {
                    throw new ExpressionException("Invalid bracket in expression: %s".formatted(token));
                }
            } else if (token.isCloseBracket()) {
                if (previous.isEmpty()) {
                    throw new ExpressionException("expression can't start with a close bracket");
                }
                if (previous.map(Token::isSeparator).get().booleanValue()) {
                    throw new ExpressionException("argument is missing");
                }
                BracketPair brackets = token.getBrackets().get();
                boolean openBracketFound = false;
                while (!stack.isEmpty() && !openBracketFound) {
                    Token stackToken = (Token)stack.pop();
                    if (stackToken.getBrackets().isPresent() && stackToken.isOpenBracket()) {
                        if (stackToken.getBrackets().get().equals(brackets)) {
                            openBracketFound = true;
                            continue;
                        }
                        throw new ExpressionException("Invalid parenthesis match %s%s".formatted(stackToken.getBrackets().get().getOpen(), brackets.getClose()));
                    }
                    this.processTokenToValues(values, stackToken);
                }
                if (!openBracketFound) {
                    throw new ExpressionException("Parentheses mismatched");
                }
                if (!stack.isEmpty() && ((Token)stack.peek()).getFunction().isPresent()) {
                    int argumentCount = values.size() - (Integer)previousValuesSize.pop();
                    this.doFunction(values, ((Token)stack.pop()).getFunction().orElseThrow(), argumentCount);
                }
            } else if (token.isSeparator()) {
                if (previous.isEmpty()) {
                    throw new ExpressionException("expression can't start with a separator");
                }
                if (((Token)previous.get()).isOpenBracket() || ((Token)previous.get()).isSeparator()) {
                    throw new ExpressionException("A separator can't be followed by another separator or open bracket");
                }
                boolean openBracketOnStackReached = false;
                while (!stack.isEmpty() && !openBracketOnStackReached) {
                    if (((Token)stack.peek()).isOpenBracket()) {
                        openBracketOnStackReached = true;
                        continue;
                    }
                    this.processTokenToValues(values, (Token)stack.pop());
                }
                if (openBracketOnStackReached) {
                    stack.push((Token)stack.pop());
                }
            } else if (token.getFunction().isPresent()) {
                stack.push(token);
                previousValuesSize.push(values.size());
            } else if (token.getOperator().isPresent()) {
                while (!stack.isEmpty() && DiceEvaluator.hasStackTokenPrecedence(token, (Token)stack.peek())) {
                    this.processTokenToValues(values, (Token)stack.pop());
                }
                stack.push(token);
            } else if (token.getLiteral().isPresent()) {
                if (previous.flatMap(Token::getLiteral).isPresent() && !stack.isEmpty()) {
                    this.processTokenToValues(values, (Token)stack.pop());
                }
                this.processTokenToValues(values, token);
            } else {
                throw new IllegalStateException("Unknown Token: %s".formatted(token));
            }
            previous = Optional.of(token);
        }
        for (Token stackToken : stack) {
            if (stackToken.isOpenBracket() || stackToken.isCloseBracket()) {
                throw new ExpressionException("Parentheses mismatched");
            }
            this.processTokenToValues(values, stackToken);
        }
        return DiceEvaluator.createRollSupplier(DiceEvaluator.reverse(values));
    }
}

