/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.random.NumberSupplier;
import java.util.List;
import lombok.NonNull;

public final class DiceHelper {
    @NonNull
    public static ImmutableList<Integer> explodingDice(int number, int sides, @NonNull NumberSupplier numberSupplier) throws ExpressionException {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        if (sides == 0) {
            return ImmutableList.of();
        }
        if (sides < 0) {
            throw new ExpressionException("Sides of dice to roll must be positive");
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        int diceToRoll = number;
        while (diceToRoll > 0) {
            ImmutableList<Integer> roll = DiceHelper.rollDice(diceToRoll, sides, numberSupplier);
            resultBuilder.addAll(roll);
            diceToRoll = (int)roll.stream().filter(i -> i == sides).count();
        }
        return resultBuilder.build();
    }

    @NonNull
    public static ImmutableList<RollElement> toRollElements(@NonNull List<Integer> in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return (ImmutableList)in.stream().map(String::valueOf).map(i -> new RollElement((String)i, "")).collect(ImmutableList.toImmutableList());
    }

    @NonNull
    public static ImmutableList<Integer> explodingAddDice(int number, int sides, @NonNull NumberSupplier numberSupplier) throws ExpressionException {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        if (sides == 0) {
            return ImmutableList.of();
        }
        if (sides < 0) {
            throw new ExpressionException("Sides of dice to roll must be positive");
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < number; ++i) {
            resultBuilder.add((Object)DiceHelper.rollExplodingAddDie(sides, numberSupplier));
        }
        return resultBuilder.build();
    }

    public static int rollExplodingAddDie(int sides, @NonNull NumberSupplier numberSupplier) throws ExpressionException {
        int current;
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        int res = current = numberSupplier.get(0, sides);
        while (current == sides) {
            current = numberSupplier.get(0, sides);
            res += current;
        }
        return res;
    }

    @NonNull
    public static ImmutableList<Integer> rollDice(int number, int sides, @NonNull NumberSupplier numberSupplier) throws ExpressionException {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        if (sides == 0) {
            return ImmutableList.of();
        }
        if (sides < 0) {
            throw new ExpressionException("Sides of dice to roll must be positive");
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < number; ++i) {
            resultBuilder.add((Object)numberSupplier.get(0, sides));
        }
        return resultBuilder.build();
    }

    @NonNull
    public static RollElement pickOneOf(List<RollElement> list, @NonNull NumberSupplier numberSupplier) throws ExpressionException {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        return list.get(numberSupplier.get(0, list.size()) - 1);
    }
}

