/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public abstract class Function {
    @NonNull
    private final String name;
    private final int minArgumentCount;
    private final int maxArgumentCount;

    public Function(@NonNull String name, int argumentCount) {
        this(name, argumentCount, argumentCount);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public Function(@NonNull String name, int minArgumentCount, int maxArgumentCount) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (minArgumentCount < 0 || minArgumentCount > maxArgumentCount) {
            throw new IllegalArgumentException("Invalid argument count");
        }
        this.name = name;
        this.minArgumentCount = minArgumentCount;
        this.maxArgumentCount = maxArgumentCount;
    }

    protected static String getExpression(String name, List<Roll> arguments) {
        return "%s(%s)".formatted(name, arguments.stream().map(Roll::getExpression).collect(Collectors.joining(",")));
    }

    @NonNull
    public abstract RollBuilder evaluate(@NonNull List<RollBuilder> var1) throws ExpressionException;

    @NonNull
    public String getName() {
        return this.name;
    }

    public int getMinArgumentCount() {
        return this.minArgumentCount;
    }

    public int getMaxArgumentCount() {
        return this.maxArgumentCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function other = (Function)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinArgumentCount() != other.getMinArgumentCount()) {
            return false;
        }
        if (this.getMaxArgumentCount() != other.getMaxArgumentCount()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Function;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinArgumentCount();
        result = result * 59 + this.getMaxArgumentCount();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "Function(name=" + this.getName() + ", minArgumentCount=" + this.getMinArgumentCount() + ", maxArgumentCount=" + this.getMaxArgumentCount() + ")";
    }
}

