/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.RollElement;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class RandomElement {
    @NonNull
    private final RollElement rollElement;
    @Nullable
    private final ImmutableList<String> randomSelectedFrom;
    @Nullable
    private final Integer minInc;
    @Nullable
    private final Integer maxInc;

    public RandomElement(@NonNull RollElement rollElement, ImmutableList<String> randomSelectedFrom) {
        if (rollElement == null) {
            throw new NullPointerException("rollElement is marked non-null but is null");
        }
        this.rollElement = rollElement;
        this.randomSelectedFrom = randomSelectedFrom;
        this.minInc = null;
        this.maxInc = null;
    }

    public RandomElement(@NonNull RollElement rollElement, int minInc, int maxInc) {
        if (rollElement == null) {
            throw new NullPointerException("rollElement is marked non-null but is null");
        }
        this.rollElement = rollElement;
        this.minInc = minInc;
        this.maxInc = maxInc;
        this.randomSelectedFrom = null;
    }

    public String toString() {
        if (this.randomSelectedFrom != null) {
            return "%s\u2208%s".formatted(this.rollElement.getValue(), this.randomSelectedFrom);
        }
        return "%s\u2208[%d...%d]".formatted(this.rollElement.getValue(), this.minInc, this.maxInc);
    }

    @NonNull
    public RollElement getRollElement() {
        return this.rollElement;
    }

    @Nullable
    public ImmutableList<String> getRandomSelectedFrom() {
        return this.randomSelectedFrom;
    }

    @Nullable
    public Integer getMinInc() {
        return this.minInc;
    }

    @Nullable
    public Integer getMaxInc() {
        return this.maxInc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomElement)) {
            return false;
        }
        RandomElement other = (RandomElement)o;
        Integer this$minInc = this.getMinInc();
        Integer other$minInc = other.getMinInc();
        if (this$minInc == null ? other$minInc != null : !((Object)this$minInc).equals(other$minInc)) {
            return false;
        }
        Integer this$maxInc = this.getMaxInc();
        Integer other$maxInc = other.getMaxInc();
        if (this$maxInc == null ? other$maxInc != null : !((Object)this$maxInc).equals(other$maxInc)) {
            return false;
        }
        RollElement this$rollElement = this.getRollElement();
        RollElement other$rollElement = other.getRollElement();
        if (this$rollElement == null ? other$rollElement != null : !((Object)this$rollElement).equals(other$rollElement)) {
            return false;
        }
        ImmutableList<String> this$randomSelectedFrom = this.getRandomSelectedFrom();
        ImmutableList<String> other$randomSelectedFrom = other.getRandomSelectedFrom();
        return !(this$randomSelectedFrom == null ? other$randomSelectedFrom != null : !this$randomSelectedFrom.equals(other$randomSelectedFrom));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minInc = this.getMinInc();
        result = result * 59 + ($minInc == null ? 43 : ((Object)$minInc).hashCode());
        Integer $maxInc = this.getMaxInc();
        result = result * 59 + ($maxInc == null ? 43 : ((Object)$maxInc).hashCode());
        RollElement $rollElement = this.getRollElement();
        result = result * 59 + ($rollElement == null ? 43 : ((Object)$rollElement).hashCode());
        ImmutableList<String> $randomSelectedFrom = this.getRandomSelectedFrom();
        result = result * 59 + ($randomSelectedFrom == null ? 43 : $randomSelectedFrom.hashCode());
        return result;
    }
}

