/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class Roll {
    @NonNull
    private final String expression;
    @NonNull
    private final ImmutableList<RollElement> elements;
    @NonNull
    private final UniqueRandomElements randomElementsInRoll;
    @NonNull
    private final ImmutableList<Roll> childrenRolls;

    public Optional<Integer> asInteger() {
        if (this.elements.size() == 1) {
            return ((RollElement)this.elements.get(0)).asInteger();
        }
        return Optional.empty();
    }

    public boolean containsOnlyIntegers() {
        return this.elements.stream().map(RollElement::asInteger).allMatch(Optional::isPresent);
    }

    public String getResultString() {
        return this.elements.stream().map(RollElement::toString).collect(Collectors.joining(", "));
    }

    public String getRandomElementsString() {
        return this.randomElementsInRoll.getRandomElements().stream().map(l -> l.getRandomElements().stream().map(RandomElement::getRollElement).map(RollElement::getValue).toList().toString()).collect(Collectors.joining(" "));
    }

    public Roll(@NonNull String expression, @NonNull ImmutableList<RollElement> elements, @NonNull UniqueRandomElements randomElementsInRoll, @NonNull ImmutableList<Roll> childrenRolls) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        if (randomElementsInRoll == null) {
            throw new NullPointerException("randomElementsInRoll is marked non-null but is null");
        }
        if (childrenRolls == null) {
            throw new NullPointerException("childrenRolls is marked non-null but is null");
        }
        this.expression = expression;
        this.elements = elements;
        this.randomElementsInRoll = randomElementsInRoll;
        this.childrenRolls = childrenRolls;
    }

    @NonNull
    public String getExpression() {
        return this.expression;
    }

    @NonNull
    public ImmutableList<RollElement> getElements() {
        return this.elements;
    }

    @NonNull
    public UniqueRandomElements getRandomElementsInRoll() {
        return this.randomElementsInRoll;
    }

    @NonNull
    public ImmutableList<Roll> getChildrenRolls() {
        return this.childrenRolls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Roll)) {
            return false;
        }
        Roll other = (Roll)o;
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        ImmutableList<RollElement> this$elements = this.getElements();
        ImmutableList<RollElement> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !this$elements.equals(other$elements)) {
            return false;
        }
        UniqueRandomElements this$randomElementsInRoll = this.getRandomElementsInRoll();
        UniqueRandomElements other$randomElementsInRoll = other.getRandomElementsInRoll();
        if (this$randomElementsInRoll == null ? other$randomElementsInRoll != null : !((Object)this$randomElementsInRoll).equals(other$randomElementsInRoll)) {
            return false;
        }
        ImmutableList<Roll> this$childrenRolls = this.getChildrenRolls();
        ImmutableList<Roll> other$childrenRolls = other.getChildrenRolls();
        return !(this$childrenRolls == null ? other$childrenRolls != null : !this$childrenRolls.equals(other$childrenRolls));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        ImmutableList<RollElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : $elements.hashCode());
        UniqueRandomElements $randomElementsInRoll = this.getRandomElementsInRoll();
        result = result * 59 + ($randomElementsInRoll == null ? 43 : ((Object)$randomElementsInRoll).hashCode());
        ImmutableList<Roll> $childrenRolls = this.getChildrenRolls();
        result = result * 59 + ($childrenRolls == null ? 43 : $childrenRolls.hashCode());
        return result;
    }

    public String toString() {
        return "Roll(expression=" + this.getExpression() + ", elements=" + this.getElements() + ", randomElementsInRoll=" + this.getRandomElementsInRoll() + ", childrenRolls=" + this.getChildrenRolls() + ")";
    }
}

