/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import java.util.Optional;
import lombok.NonNull;

public final class RollElement
implements Comparable<RollElement> {
    public static final String NO_COLOR = "";
    @NonNull
    private final String value;
    @NonNull
    private final String color;

    public boolean isInteger() {
        try {
            Integer.parseInt(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Optional<Integer> asInteger() {
        if (this.isInteger()) {
            return Optional.of(Integer.parseInt(this.value));
        }
        return Optional.empty();
    }

    @Override
    public int compareTo(@NonNull RollElement rollElement) {
        if (rollElement == null) {
            throw new NullPointerException("rollElement is marked non-null but is null");
        }
        if (!this.getColor().equals(rollElement.getColor())) {
            return this.getColor().compareTo(rollElement.getColor());
        }
        if (this.asInteger().isPresent() && rollElement.asInteger().isPresent()) {
            return this.asInteger().get().compareTo(rollElement.asInteger().get());
        }
        return this.getValue().compareTo(rollElement.getValue());
    }

    public String toString() {
        String outputColor = NO_COLOR.equals(this.color) ? NO_COLOR : "%s:".formatted(this.color);
        return "%s%s".formatted(outputColor, this.value);
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    @NonNull
    public String getColor() {
        return this.color;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollElement)) {
            return false;
        }
        RollElement other = (RollElement)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        return !(this$color == null ? other$color != null : !this$color.equals(other$color));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        return result;
    }

    public RollElement(@NonNull String value, @NonNull String color) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.value = value;
        this.color = color;
    }
}

