/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import de.janno.evaluator.dice.BracketPair;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Operator;
import java.util.Optional;
import lombok.NonNull;

public class Token {
    @NonNull
    private final Kind kind;
    private final Operator operator;
    private final Function function;
    private final String literal;
    private final BracketPair bracketPair;
    private final Operator.OperatorType operatorType;

    private Token(@NonNull Kind kind, Operator operator, Function function, String literal, Operator.OperatorType operatorType, BracketPair bracketPair) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        this.kind = kind;
        this.operator = operator;
        this.function = function;
        this.literal = literal;
        this.operatorType = operatorType;
        this.bracketPair = bracketPair;
    }

    public static Token of(Operator operator) {
        return new Token(Kind.OPERATOR, operator, null, null, null, null);
    }

    public static Token of(Operator operator, Operator.OperatorType operatorType) {
        if (operatorType == Operator.OperatorType.UNARY && !operator.supportUnaryOperation()) {
            throw new IllegalArgumentException(operator + "only supports binary operation");
        }
        if (operatorType == Operator.OperatorType.BINARY && !operator.supportBinaryOperation()) {
            throw new IllegalArgumentException(operator + "only supports unary operation");
        }
        return new Token(Kind.OPERATOR, operator, null, null, operatorType, null);
    }

    public static Token of(Function function) {
        return new Token(Kind.FUNCTION, null, function, null, null, null);
    }

    public static Token of(String literal) {
        return new Token(Kind.LITERAL, null, null, literal, null, null);
    }

    public static Token openTokenOf(BracketPair bracketPair) {
        return new Token(Kind.OPEN_BRACKET, null, null, null, null, bracketPair);
    }

    public static Token closeTokenOf(BracketPair bracketPair) {
        return new Token(Kind.CLOSE_BRACKET, null, null, null, null, bracketPair);
    }

    public static Token separator() {
        return new Token(Kind.SEPARATOR, null, null, null, null, null);
    }

    public Optional<BracketPair> getBrackets() {
        return Optional.ofNullable(this.bracketPair);
    }

    public Optional<Operator> getOperator() {
        return Optional.ofNullable(this.operator);
    }

    public Optional<Operator.OperatorType> getOperatorType() {
        return Optional.ofNullable(this.operatorType);
    }

    public Optional<Function> getFunction() {
        return Optional.ofNullable(this.function);
    }

    public Optional<String> getLiteral() {
        return Optional.ofNullable(this.literal);
    }

    public boolean isOpenBracket() {
        return this.kind.equals((Object)Kind.OPEN_BRACKET);
    }

    public boolean isCloseBracket() {
        return this.kind.equals((Object)Kind.CLOSE_BRACKET);
    }

    public boolean isSeparator() {
        return this.kind.equals((Object)Kind.SEPARATOR);
    }

    public Optional<Operator.Associativity> getOperatorAssociativity() {
        return this.getOperator().map(o -> o.getAssociativityForOperantType(this.operatorType));
    }

    public Optional<Integer> getOperatorPrecedence() {
        return this.getOperator().map(o -> o.getPrecedenceForOperantType(this.operatorType));
    }

    public String toString() {
        return switch (this.kind) {
            default -> throw new IncompatibleClassChangeError();
            case Kind.OPERATOR -> this.operator.getName();
            case Kind.FUNCTION -> this.function.getName();
            case Kind.LITERAL -> "'%s'".formatted(this.literal);
            case Kind.OPEN_BRACKET -> this.bracketPair.getOpen();
            case Kind.CLOSE_BRACKET -> this.bracketPair.getClose();
            case Kind.SEPARATOR -> "SEPARATOR";
        };
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Kind this$kind = this.kind;
        Kind other$kind = other.kind;
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        Optional<Operator> this$operator = this.getOperator();
        Optional<Operator> other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)this$operator).equals(other$operator)) {
            return false;
        }
        Optional<Function> this$function = this.getFunction();
        Optional<Function> other$function = other.getFunction();
        if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
            return false;
        }
        Optional<String> this$literal = this.getLiteral();
        Optional<String> other$literal = other.getLiteral();
        if (this$literal == null ? other$literal != null : !((Object)this$literal).equals(other$literal)) {
            return false;
        }
        BracketPair this$bracketPair = this.bracketPair;
        BracketPair other$bracketPair = other.bracketPair;
        if (this$bracketPair == null ? other$bracketPair != null : !((Object)this$bracketPair).equals(other$bracketPair)) {
            return false;
        }
        Optional<Operator.OperatorType> this$operatorType = this.getOperatorType();
        Optional<Operator.OperatorType> other$operatorType = other.getOperatorType();
        return !(this$operatorType == null ? other$operatorType != null : !((Object)this$operatorType).equals(other$operatorType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Kind $kind = this.kind;
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        Optional<Operator> $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)$operator).hashCode());
        Optional<Function> $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
        Optional<String> $literal = this.getLiteral();
        result = result * 59 + ($literal == null ? 43 : ((Object)$literal).hashCode());
        BracketPair $bracketPair = this.bracketPair;
        result = result * 59 + ($bracketPair == null ? 43 : ((Object)$bracketPair).hashCode());
        Optional<Operator.OperatorType> $operatorType = this.getOperatorType();
        result = result * 59 + ($operatorType == null ? 43 : ((Object)$operatorType).hashCode());
        return result;
    }

    private static enum Kind {
        OPEN_BRACKET,
        CLOSE_BRACKET,
        SEPARATOR,
        FUNCTION,
        OPERATOR,
        LITERAL;

    }
}

