/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.RandomElements;
import de.janno.evaluator.dice.Roll;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;

public class UniqueRandomElements {
    private final ImmutableList<RandomElements> randomElements;

    public UniqueRandomElements(ImmutableList<RandomElements> randomElements) {
        HashSet uuids = new HashSet();
        this.randomElements = (ImmutableList)randomElements.stream().filter(r -> !r.getRandomElements().isEmpty()).filter(r -> uuids.add(r.getUuid())).collect(ImmutableList.toImmutableList());
    }

    public static UniqueRandomElements from(Collection<Roll> rolls) {
        Builder builder = UniqueRandomElements.builder();
        rolls.forEach(r -> builder.add(r.getRandomElementsInRoll()));
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UniqueRandomElements empty() {
        return new UniqueRandomElements((ImmutableList<RandomElements>)ImmutableList.of());
    }

    public String toString() {
        return this.randomElements.stream().map(RandomElements::toString).collect(Collectors.joining(", "));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniqueRandomElements)) {
            return false;
        }
        UniqueRandomElements other = (UniqueRandomElements)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableList<RandomElements> this$randomElements = this.getRandomElements();
        ImmutableList<RandomElements> other$randomElements = other.getRandomElements();
        return !(this$randomElements == null ? other$randomElements != null : !this$randomElements.equals(other$randomElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UniqueRandomElements;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<RandomElements> $randomElements = this.getRandomElements();
        result = result * 59 + ($randomElements == null ? 43 : $randomElements.hashCode());
        return result;
    }

    public ImmutableList<RandomElements> getRandomElements() {
        return this.randomElements;
    }

    public static class Builder {
        private final ImmutableList.Builder<RandomElements> randomElements = ImmutableList.builder();

        public Builder add(RandomElements randomElements) {
            this.randomElements.add((Object)randomElements);
            return this;
        }

        public Builder addAsRandomElements(Collection<RandomElement> randomElements) {
            this.randomElements.add((Object)new RandomElements((ImmutableList<RandomElement>)ImmutableList.copyOf(randomElements)));
            return this;
        }

        public Builder add(UniqueRandomElements randomElements) {
            this.randomElements.addAll(randomElements.getRandomElements());
            return this;
        }

        public UniqueRandomElements build() {
            return new UniqueRandomElements((ImmutableList<RandomElements>)this.randomElements.build());
        }
    }
}

