/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollElement;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class ValidatorUtil {
    public static ExpressionException throwNotIntegerExpression(@NonNull String inputName, @NonNull Roll roll, @NonNull String location) {
        if (inputName == null) {
            throw new NullPointerException("inputName is marked non-null but is null");
        }
        if (roll == null) {
            throw new NullPointerException("roll is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return new ExpressionException(String.format("'%s' requires as %s input a single integer but was '%s'%s", inputName, location, roll.getElements().stream().map(RollElement::getValue).toList(), ValidatorUtil.getSumHelp(roll)));
    }

    private static String getSumHelp(@NonNull Roll roll) {
        if (roll == null) {
            throw new NullPointerException("roll is marked non-null but is null");
        }
        boolean numberList = roll.getElements().stream().allMatch(RollElement::isInteger);
        return numberList ? ". Try to sum the numbers together like (%s=)".formatted(roll.getExpression()) : "";
    }

    public static void checkContainsOnlyInteger(@NonNull String inputName, @NonNull Roll roll, @NonNull String location) throws ExpressionException {
        if (inputName == null) {
            throw new NullPointerException("inputName is marked non-null but is null");
        }
        if (roll == null) {
            throw new NullPointerException("roll is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (!roll.containsOnlyIntegers()) {
            throw new ExpressionException(String.format("'%s' requires as %s input only integers but was '%s'", inputName, location, roll.getElements().stream().map(RollElement::getValue).toList()));
        }
    }

    public static void checkContainsSingleElement(@NonNull String inputName, @NonNull Roll roll, @NonNull String location) throws ExpressionException {
        if (inputName == null) {
            throw new NullPointerException("inputName is marked non-null but is null");
        }
        if (roll == null) {
            throw new NullPointerException("roll is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (roll.getElements().size() != 1) {
            throw new ExpressionException(String.format("'%s' requires as %s a single element but was '%s'%s", inputName, location, roll.getElements().stream().map(RollElement::getValue).toList(), ValidatorUtil.getSumHelp(roll)));
        }
    }

    public static void checkRollSize(@NonNull String inputName, @NonNull List<Roll> rolls, int minInc, int maxInc) throws ExpressionException {
        if (inputName == null) {
            throw new NullPointerException("inputName is marked non-null but is null");
        }
        if (rolls == null) {
            throw new NullPointerException("rolls is marked non-null but is null");
        }
        if (rolls.size() < minInc || rolls.size() > maxInc) {
            String range = minInc == maxInc ? String.valueOf(minInc) : "%d-%d".formatted(maxInc, maxInc);
            throw new ExpressionException(String.format("'%s' requires as %s inputs but was '%s'", inputName, range, rolls.stream().map(Roll::getElements).toList()));
        }
    }

    public static void checkAllElementsAreSameColor(@NonNull String operatorName, Roll ... rolls) throws ExpressionException {
        if (operatorName == null) {
            throw new NullPointerException("operatorName is marked non-null but is null");
        }
        if (rolls == null) {
            throw new NullPointerException("rolls is marked non-null but is null");
        }
        Set allElementColors = Arrays.stream(rolls).flatMap(r -> r.getElements().stream()).map(RollElement::getColor).collect(Collectors.toSet());
        if (allElementColors.size() != 1) {
            throw new ExpressionException(String.format("'%s' requires all elements to be the same color, the colors where '%s'", operatorName, allElementColors));
        }
    }
}

