/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import lombok.NonNull;

public abstract class AbstractIf
extends Function {
    public AbstractIf(@NonNull String name) {
        super(name, 3, Integer.MAX_VALUE);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> arguments) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return constants -> {
            Roll result;
            int counter;
            List<Roll> rolls = RollBuilder.extendAllBuilder(arguments, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, this.getMinArgumentCount(), this.getMaxArgumentCount());
            Roll input = rolls.get(0);
            UniqueRandomElements.Builder randomElements = UniqueRandomElements.builder();
            randomElements.add(input.getRandomElementsInRoll());
            for (counter = 1; counter < rolls.size() - 1; counter += 2) {
                Roll compareTo = rolls.get(counter);
                Roll trueResult = rolls.get(counter + 1);
                randomElements.add(compareTo.getRandomElementsInRoll());
                if (!this.compare(input, counter, compareTo, counter + 1)) continue;
                randomElements.add(trueResult.getRandomElementsInRoll());
                return ImmutableList.of((Object)new Roll(AbstractIf.getExpression(this.getName(), rolls), trueResult.getElements(), randomElements.build(), (ImmutableList<Roll>)ImmutableList.builder().addAll(input.getChildrenRolls()).addAll(trueResult.getChildrenRolls()).build()));
            }
            if (counter != rolls.size()) {
                result = rolls.get(rolls.size() - 1);
                randomElements.add(result.getRandomElementsInRoll());
            } else {
                result = input;
            }
            return ImmutableList.of((Object)new Roll(AbstractIf.getExpression(this.getName(), rolls), result.getElements(), randomElements.build(), (ImmutableList<Roll>)ImmutableList.builder().addAll(input.getChildrenRolls()).addAll(result.getChildrenRolls()).build()));
        };
    }

    protected abstract boolean compare(Roll var1, int var2, Roll var3, int var4) throws ExpressionException;
}

